/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.overlay.element;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.reaper.ancientnature.client.overlay.Anchor;

public abstract class GuiElement {
    protected int width;
    protected int height;
    protected int offsetX;
    protected int offsetY;
    protected Anchor anchor;

    public GuiElement(int width, int height, Anchor anchor, int offsetX, int offsetY) {
        this.width = width;
        this.height = height;
        this.anchor = anchor;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void render(GuiGraphics graphics, int screenWidth, int screenHeight, RenderGuiOverlayEvent.Pre event) {
        int x = this.calculateTopLeftX(screenWidth);
        int y = this.calculateTopLeftY(screenHeight);
        this.draw(graphics, x, y);
    }

    protected abstract void draw(GuiGraphics var1, int var2, int var3);

    protected int calculateTopLeftX(int screenWidth) {
        int anchorX = switch (this.anchor) {
            default -> throw new IncompatibleClassChangeError();
            case Anchor.TOP_LEFT, Anchor.CENTER_LEFT, Anchor.BOTTOM_LEFT -> this.offsetX;
            case Anchor.TOP_CENTER, Anchor.CENTER, Anchor.BOTTOM_CENTER -> screenWidth / 2 + this.offsetX;
            case Anchor.TOP_RIGHT, Anchor.CENTER_RIGHT, Anchor.BOTTOM_RIGHT -> screenWidth - this.offsetX;
        };
        int anchorPixelOffsetX = switch (this.anchor) {
            default -> throw new IncompatibleClassChangeError();
            case Anchor.TOP_LEFT, Anchor.CENTER_LEFT, Anchor.BOTTOM_LEFT -> 0;
            case Anchor.TOP_CENTER, Anchor.CENTER, Anchor.BOTTOM_CENTER -> this.width / 2;
            case Anchor.TOP_RIGHT, Anchor.CENTER_RIGHT, Anchor.BOTTOM_RIGHT -> this.width;
        };
        return anchorX - anchorPixelOffsetX;
    }

    protected int calculateTopLeftY(int screenHeight) {
        int anchorY = switch (this.anchor) {
            default -> throw new IncompatibleClassChangeError();
            case Anchor.TOP_LEFT, Anchor.TOP_CENTER, Anchor.TOP_RIGHT -> this.offsetY;
            case Anchor.CENTER_LEFT, Anchor.CENTER, Anchor.CENTER_RIGHT -> screenHeight / 2 + this.offsetY;
            case Anchor.BOTTOM_LEFT, Anchor.BOTTOM_CENTER, Anchor.BOTTOM_RIGHT -> screenHeight - this.offsetY;
        };
        int anchorPixelOffsetY = switch (this.anchor) {
            default -> throw new IncompatibleClassChangeError();
            case Anchor.TOP_LEFT, Anchor.TOP_CENTER, Anchor.TOP_RIGHT -> 0;
            case Anchor.CENTER_LEFT, Anchor.CENTER, Anchor.CENTER_RIGHT -> this.height / 2;
            case Anchor.BOTTOM_LEFT, Anchor.BOTTOM_CENTER, Anchor.BOTTOM_RIGHT -> this.height;
        };
        return anchorY - anchorPixelOffsetY;
    }
}

