/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.overlay.element;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.reaper.ancientnature.client.overlay.Anchor;
import net.reaper.ancientnature.client.overlay.element.GuiElement;

public class ProgressBarElement
extends GuiElement {
    private final ResourceLocation texture;
    private final int texWidth;
    private final int texHeight;
    private final int emptyU;
    private final int emptyV;
    private final int fullU;
    private final int fullV;
    private float progress;

    public ProgressBarElement(ResourceLocation texture, int barWidth, int barHeight, int texWidth, int texHeight, int emptyU, int emptyV, int fullU, int fullV, Anchor anchor, int offsetX, int offsetY) {
        super(barWidth, barHeight, anchor, offsetX, offsetY);
        this.texture = texture;
        this.texWidth = texWidth;
        this.texHeight = texHeight;
        this.emptyU = emptyU;
        this.emptyV = emptyV;
        this.fullU = fullU;
        this.fullV = fullV;
    }

    public void setProgress(float progress) {
        this.progress = Math.min(1.0f, Math.max(0.0f, progress));
    }

    @Override
    protected void draw(GuiGraphics graphics, int x, int y) {
        int filledWidth = (int)((float)this.width * this.progress);
        graphics.m_280163_(this.texture, x, y, (float)this.emptyU, (float)this.emptyV, this.width, this.height, this.texWidth, this.texHeight);
        if (filledWidth > 0) {
            graphics.m_280163_(this.texture, x, y, (float)this.fullU, (float)this.fullV, filledWidth, this.height, this.texWidth, this.texHeight);
        }
    }
}

