/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.ancientnature.client.particle.option.DodoFeatherData;
import net.reaper.ancientnature.mixin.accessor.MutableSpriteSetAccessor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DodoFeatherParticle
extends TextureSheetParticle {
    private final float rotSpeed;
    private final float flutterAmplitude;
    private final float flutterFrequency;

    public DodoFeatherParticle(@NotNull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
        super(level, x, y, z, dx, dy, dz);
        this.f_107226_ = 0.02f;
        this.f_107219_ = true;
        this.f_107215_ = dx * 0.2 + (this.f_107223_.m_188500_() - 0.5) * 0.02;
        this.f_107216_ = dy * 0.2 + this.f_107223_.m_188500_() * 0.02;
        this.f_107217_ = dz * 0.2 + (this.f_107223_.m_188500_() - 0.5) * 0.02;
        this.rotSpeed = (float)((Math.random() - 0.5) * (double)0.1f);
        this.flutterAmplitude = 0.05f + this.f_107223_.m_188501_() * 0.05f;
        this.flutterFrequency = 0.2f + this.f_107223_.m_188501_() * 0.15f;
        this.f_107231_ = this.f_107223_.m_188501_() * (float)Math.PI * 2.0f;
        this.f_107225_ = 30;
        this.f_107224_ = 0;
        this.f_107663_ = 0.05f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        float flutter = (float)Math.sin((float)this.f_107224_ * this.flutterFrequency) * this.flutterAmplitude;
        this.f_107215_ += (double)(flutter * 0.02f);
        this.f_107217_ += (double)(flutter * 0.02f);
        this.f_107215_ *= (double)0.96f;
        this.f_107217_ *= (double)0.96f;
        this.f_107216_ -= (double)(this.f_107226_ * 0.25f);
        if (this.f_107216_ < (double)-0.08f) {
            this.f_107216_ = -0.08f;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107218_) {
            this.f_107215_ *= (double)0.7f;
            this.f_107217_ *= (double)0.7f;
            this.f_107216_ *= (double)-0.3f;
            if (Math.abs(this.f_107216_) < (double)0.02f) {
                this.f_107216_ = 0.0;
            }
        }
        this.f_107231_ += this.rotSpeed;
        this.f_107204_ = this.f_107231_;
    }

    public float getAlphaFromAge(int age, int lifetime) {
        return (float)(lifetime - age) / (float)lifetime;
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pCamera, float pPartialTicks) {
        this.f_107230_ = this.getAlphaFromAge(this.f_107224_, this.f_107225_);
        super.m_5744_(pBuffer, pCamera, pPartialTicks);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<DodoFeatherData> {
        private final SpriteSet sprites;

        public Provider(@NotNull SpriteSet sprites) {
            this.sprites = sprites;
        }

        @NotNull
        public Particle createParticle(@NotNull DodoFeatherData data, @NotNull ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            DodoFeatherParticle particle = new DodoFeatherParticle(level, x, y, z, dx, dy, dz);
            particle.m_108337_(((MutableSpriteSetAccessor)this.sprites).getSprites().get(Type.fromName(data.name()).getId()));
            return particle;
        }
    }

    public static enum Type implements StringRepresentable
    {
        MALE(0, "male"),
        MALE_BABY(1, "male_baby"),
        FEMALE(2, "female"),
        FEMALE_BABY(3, "female_baby"),
        FAZ(4, "faz"),
        FAZ_BABY(5, "faz_baby"),
        WILL(6, "will"),
        WILL_BABY(7, "will_baby"),
        DOYDOY(8, "doydoy"),
        DOYDOY_BABY(9, "doydoy_baby"),
        PINATA(10, "pinata"),
        PIZZA(11, "pizza");

        private final int id;
        private final String name;

        private Type(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        @NotNull
        public static Type fromName(String name) {
            return Arrays.stream(Type.values()).filter(t -> t.name.equalsIgnoreCase(name)).findFirst().orElse(MALE);
        }
    }
}

