/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.ancientnature.client.particle.option.SoundWaveData;
import org.jetbrains.annotations.NotNull;

public class SoundWaveParticle
extends TextureSheetParticle {
    public final float xRot;
    public final float yRot;
    private final double speed;

    public SoundWaveParticle(@NotNull ClientLevel level, double x, double y, double z, @NotNull SpriteSet spriteSet, double speed, @NotNull SoundWaveData data) {
        super(level, x, y, z);
        this.f_107219_ = false;
        this.f_172258_ = 0.0f;
        this.f_107663_ = 2.0f;
        this.f_107226_ = 0.0f;
        this.f_107225_ = 15;
        this.m_108339_(spriteSet);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.xRot = data.xRot();
        this.yRot = data.yRot();
        this.speed = speed;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        float ageFrac = (float)this.f_107224_ / (float)this.f_107225_;
        Vec3 motionVec = Vec3.m_82498_((float)this.xRot, (float)this.yRot).m_82490_(this.speed);
        this.f_107215_ += motionVec.f_82479_ * (double)(1.0f - 0.1f * ageFrac);
        this.f_107216_ += motionVec.f_82480_ * (double)(1.0f - 0.1f * ageFrac);
        this.f_107217_ += motionVec.f_82481_ * (double)(1.0f - 0.1f * ageFrac);
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public float getAlphaFromAge(int age, int lifeTime) {
        return (float)(lifeTime - age) / (float)lifeTime;
    }

    public void m_5744_(@NotNull VertexConsumer buffer, @NotNull Camera camera, float partialTick) {
        float alpha;
        Vec3 up;
        float zDir;
        float yDir;
        Vec3 camPos = camera.m_90583_();
        float cx = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - camPos.m_7096_());
        float cy = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - camPos.m_7098_());
        float cz = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - camPos.m_7094_());
        float xRotRad = (float)Math.toRadians(this.xRot);
        float yRotRad = (float)Math.toRadians(this.yRot);
        float xDir = -Mth.m_14031_((float)yRotRad) * Mth.m_14089_((float)xRotRad);
        Vec3 motionDir = new Vec3((double)xDir, (double)(yDir = -Mth.m_14031_((float)xRotRad)), (double)(zDir = Mth.m_14089_((float)yRotRad) * Mth.m_14089_((float)xRotRad))).m_82541_();
        Vec3 right = motionDir.m_82537_(up = new Vec3(0.0, 1.0, 0.0));
        if (right.m_82556_() < 1.0E-4) {
            up = new Vec3(1.0, 0.0, 0.0);
            right = motionDir.m_82537_(up);
        }
        right = right.m_82541_();
        Vec3 forward = right.m_82537_(motionDir).m_82541_();
        float size = this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + partialTick) / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        Vec3 r = right.m_82490_((double)size);
        Vec3 f = forward.m_82490_((double)size);
        Vec3 v0 = new Vec3((double)cx, (double)cy, (double)cz).m_82549_(r).m_82549_(f);
        Vec3 v1 = new Vec3((double)cx, (double)cy, (double)cz).m_82549_(r).m_82546_(f);
        Vec3 v2 = new Vec3((double)cx, (double)cy, (double)cz).m_82546_(r).m_82546_(f);
        Vec3 v3 = new Vec3((double)cx, (double)cy, (double)cz).m_82546_(r).m_82549_(f);
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0u = this.m_5951_();
        float v1u = this.m_5950_();
        int light = this.m_6355_(partialTick);
        this.f_107230_ = alpha = this.getAlphaFromAge(this.f_107224_, this.f_107225_);
        buffer.m_5483_(v0.f_82479_, v0.f_82480_, v0.f_82481_).m_7421_(u1, v1u).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(light).m_5752_();
        buffer.m_5483_(v1.f_82479_, v1.f_82480_, v1.f_82481_).m_7421_(u1, v0u).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(light).m_5752_();
        buffer.m_5483_(v2.f_82479_, v2.f_82480_, v2.f_82481_).m_7421_(u0, v0u).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(light).m_5752_();
        buffer.m_5483_(v3.f_82479_, v3.f_82480_, v3.f_82481_).m_7421_(u0, v1u).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(light).m_5752_();
        buffer.m_5483_(v3.f_82479_, v3.f_82480_, v3.f_82481_).m_7421_(u0, v1u).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(light).m_5752_();
        buffer.m_5483_(v2.f_82479_, v2.f_82480_, v2.f_82481_).m_7421_(u0, v0u).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(light).m_5752_();
        buffer.m_5483_(v1.f_82479_, v1.f_82480_, v1.f_82481_).m_7421_(u1, v0u).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(light).m_5752_();
        buffer.m_5483_(v0.f_82479_, v0.f_82480_, v0.f_82481_).m_7421_(u1, v1u).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(light).m_5752_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SoundWaveData> {
        private final SpriteSet sprites;

        public Provider(@NotNull SpriteSet sprites) {
            this.sprites = sprites;
        }

        @NotNull
        public Particle createParticle(@NotNull SoundWaveData data, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SoundWaveParticle(level, x, y, z, this.sprites, xSpeed, data);
        }
    }
}

