/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.particle.option;

import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.reaper.ancientnature.core.registry.ANParticles;
import org.jetbrains.annotations.NotNull;

public record SoundWaveData(float xRot, float yRot) implements ParticleOptions
{
    public static final Codec<SoundWaveData> CODEC = RecordCodecBuilder.create((Function)new Function<RecordCodecBuilder.Instance<SoundWaveData>, App<RecordCodecBuilder.Mu<SoundWaveData>, SoundWaveData>>(){

        @Override
        @NotNull
        public App<RecordCodecBuilder.Mu<SoundWaveData>, SoundWaveData> apply(@NotNull RecordCodecBuilder.Instance<SoundWaveData> inst) {
            return inst.group((App)Codec.FLOAT.fieldOf("xRot").forGetter(d -> Float.valueOf(d.xRot)), (App)Codec.FLOAT.fieldOf("yRot").forGetter(d -> Float.valueOf(d.yRot))).apply(inst, SoundWaveData::new);
        }
    });
    public static final ParticleOptions.Deserializer<SoundWaveData> DESERIALIZER = new ParticleOptions.Deserializer<SoundWaveData>(){

        @NotNull
        public SoundWaveData fromCommand(@NotNull ParticleType<SoundWaveData> type, @NotNull StringReader reader) {
            try {
                reader.expect(' ');
                float xRot = reader.readFloat();
                reader.expect(' ');
                float yRot = reader.readFloat();
                return new SoundWaveData(xRot, yRot);
            }
            catch (Exception exception) {
                throw new RuntimeException("Invalid particle data", exception);
            }
        }

        @NotNull
        public SoundWaveData fromNetwork(@NotNull ParticleType<SoundWaveData> type, @NotNull FriendlyByteBuf buf) {
            return new SoundWaveData(buf.readFloat(), buf.readFloat());
        }
    };

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)ANParticles.SOUND_WAVE.get();
    }

    public void m_7711_(@NotNull FriendlyByteBuf buf) {
        buf.writeFloat(this.xRot);
        buf.writeFloat(this.yRot);
    }

    @NotNull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%f %f", Float.valueOf(this.xRot), Float.valueOf(this.yRot));
    }
}

