/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.reaper.ancientnature.client.model.ANLayers;
import net.reaper.ancientnature.client.model.TriceratopSkullModel;
import net.reaper.ancientnature.client.model.animation.TriceratopsSkullAnimation;
import net.reaper.ancientnature.common.block.TriceratopsSkullBlock;
import net.reaper.ancientnature.common.block.blockentity.TriceratopsSkullBlockEntity;

public class TriceratopsBlockRenderer
implements BlockEntityRenderer<TriceratopsSkullBlockEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("ancientnature", "textures/block/triceratops_skull.png");
    private final TriceratopSkullModel model;
    private static TriceratopSkullModel CACHED_MODEL;

    public TriceratopsBlockRenderer(BlockEntityRendererProvider.Context context) {
        CACHED_MODEL = this.model = new TriceratopSkullModel(context.m_173582_(ANLayers.TRICERATOPS_SKULL_LAYER));
    }

    public void render(TriceratopsSkullBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_(TriceratopsSkullBlock.FACING);
        float yRotation = -facing.m_122435_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yRotation));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        this.model.resetToDefaultPose();
        AnimationDefinition animation = this.getAnimationForState(blockEntity);
        this.model.applyStaticAnimation(animation);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private AnimationDefinition getAnimationForState(TriceratopsSkullBlockEntity blockEntity) {
        boolean isOpen = blockEntity.isOpen();
        boolean isOnFloor = (Boolean)blockEntity.m_58900_().m_61143_((Property)TriceratopsSkullBlock.FLOOR);
        boolean isOnWall = (Boolean)blockEntity.m_58900_().m_61143_((Property)TriceratopsSkullBlock.WALL);
        if (isOpen && isOnFloor) {
            return TriceratopsSkullAnimation.FLOOR_OPEN;
        }
        if (isOpen && isOnWall) {
            return TriceratopsSkullAnimation.WALL_OPEN;
        }
        if (isOpen) {
            return TriceratopsSkullAnimation.NO_FLOOR_OPEN;
        }
        if (isOnWall) {
            return TriceratopsSkullAnimation.WALL;
        }
        return TriceratopsSkullAnimation.FLOOR;
    }

    public static TriceratopSkullModel getModel() {
        return CACHED_MODEL;
    }
}

