/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.client.screens;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.client.screens.ANCyclingSlotBackground;
import net.reaper.ancientnature.common.block.blockentity.RevivalStandBlockEntity;
import net.reaper.ancientnature.common.menu.RevivalStandMenu;
import net.reaper.ancientnature.common.util.ScreenUtils;
import org.jetbrains.annotations.NotNull;

public class RevivalStandScreen
extends AbstractContainerScreen<RevivalStandMenu> {
    private static final ResourceLocation FERN_AMBER = new ResourceLocation("ancientnature", "textures/gui/items/amber/fern_amber.png");
    private static final ResourceLocation LIZARD_AMBER = AncientNature.modLoc("textures/gui/items/amber/lizard_amber.png");
    private static final ResourceLocation MOSQUITO_AMBER = AncientNature.modLoc("textures/gui/items/amber/mosquito_amber.png");
    private static final ResourceLocation EGG = AncientNature.modLoc("textures/gui/items/egg_roe/egg.png");
    private static final ResourceLocation CRAB_ROE = AncientNature.modLoc("textures/gui/items/egg_roe/horseshoe_crab_roe.png");
    private static final ResourceLocation ANOMALOCARIS = AncientNature.modLoc("textures/gui/items/fossil/anomalocaris_fossil.png");
    private static final ResourceLocation ARANDASPIS = AncientNature.modLoc("textures/gui/items/fossil/arandaspis_fossil.png");
    private static final ResourceLocation DODO = AncientNature.modLoc("textures/gui/items/fossil/dodo_fossil.png");
    private static final ResourceLocation ESTEMMENOSUCHUS = AncientNature.modLoc("textures/gui/items/fossil/estemmenosuchus_fossil.png");
    private static final ResourceLocation GINKGO = AncientNature.modLoc("textures/gui/items/fossil/ginkgo_fossil.png");
    private static final ResourceLocation JAKAPIL = AncientNature.modLoc("textures/gui/items/fossil/jakapil_fossil.png");
    private static final ResourceLocation LEPIDODENDRON = AncientNature.modLoc("textures/gui/items/fossil/lepidodendron_fossil.png");
    private static final ResourceLocation PARANOGMIUS = AncientNature.modLoc("textures/gui/items/fossil/paranogmius_fossil.png");
    private static final ResourceLocation THYLACINE = AncientNature.modLoc("textures/gui/items/fossil/thylacine_fossil.png");
    private static final ResourceLocation TRILOBITE = AncientNature.modLoc("textures/gui/items/fossil/trilobite_fossil.png");
    private static final ResourceLocation TUZIOA = AncientNature.modLoc("textures/gui/items/fossil/tuzoia_fossil.png");
    private static final ResourceLocation ZAPHRENTIS = AncientNature.modLoc("textures/gui/items/fossil/zaphrentis_fossil.png");
    public static final ResourceLocation TEXTURE = AncientNature.modLoc("textures/gui/revivalstand_gui.png");
    private static final Component MISSING_AMBER_ITEM = Component.m_237115_((String)"container.ancientnature.missing_amber_item");
    private static final Component MISSING_EGG_ITEM = Component.m_237115_((String)"container.ancientnature.missing_egg_item");
    private static final Component MISSING_FOSSIL_ITEM = Component.m_237115_((String)"container.ancientnature.missing_fossil_item");
    private static final List<ResourceLocation> AMBER_ICONS = List.of(FERN_AMBER, LIZARD_AMBER, MOSQUITO_AMBER);
    private static final List<ResourceLocation> EGG_ICONS = List.of(EGG, CRAB_ROE);
    private static final List<ResourceLocation> FOSSIL_ICONS = List.of(ANOMALOCARIS, ARANDASPIS, DODO, ESTEMMENOSUCHUS, GINKGO, JAKAPIL, LEPIDODENDRON, PARANOGMIUS, THYLACINE, TRILOBITE, TUZIOA, ZAPHRENTIS);
    private final ANCyclingSlotBackground amberIcon = new ANCyclingSlotBackground(1);
    private final ANCyclingSlotBackground fossilIcon = new ANCyclingSlotBackground(2);
    private final ANCyclingSlotBackground eggIcon = new ANCyclingSlotBackground(3);
    private static final Map<Integer, Component> MISSING_ITEM_TOOLTIPS = Map.of(1, MISSING_AMBER_ITEM, 2, MISSING_FOSSIL_ITEM, 3, MISSING_EGG_ITEM);

    public RevivalStandScreen(RevivalStandMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_ - 17, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ + 12, 0x404040, false);
    }

    public void m_181908_() {
        super.m_181908_();
        this.amberIcon.tick(AMBER_ICONS);
        this.fossilIcon.tick(FOSSIL_ICONS);
        this.eggIcon.tick(EGG_ICONS);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        this.renderOnboardingTooltips(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_ - 17, 0, 0, this.f_97726_, 196);
        this.amberIcon.render(this.f_97732_, graphics, partialTick, this.f_97735_, this.f_97736_);
        this.fossilIcon.render(this.f_97732_, graphics, partialTick, this.f_97735_, this.f_97736_);
        this.eggIcon.render(this.f_97732_, graphics, partialTick, this.f_97735_, this.f_97736_);
        ScreenUtils.renderImageAnimationBottomTop(graphics, TEXTURE, this.f_97735_ + 85, this.f_97736_ + 20, 180, 7, 5, 11, ((RevivalStandBlockEntity)((Object)((RevivalStandMenu)this.f_97732_).getTileEntity())).getAmberProgress(), ((RevivalStandBlockEntity)((Object)((RevivalStandMenu)this.f_97732_).getTileEntity())).getMaxAmberProgress());
        ScreenUtils.renderImageAnimationBottomTop(graphics, TEXTURE, this.f_97735_ + 82, this.f_97736_ + 53, 176, 21, 11, 15, ((RevivalStandBlockEntity)((Object)((RevivalStandMenu)this.f_97732_).getTileEntity())).getFuel(), ((RevivalStandBlockEntity)((Object)((RevivalStandMenu)this.f_97732_).getTileEntity())).getMaxFuel());
        int fossilScale = ScreenUtils.getScaledInt(((RevivalStandBlockEntity)((Object)((RevivalStandMenu)this.f_97732_).getTileEntity())).getFossilProgress(), ((RevivalStandBlockEntity)((Object)((RevivalStandMenu)this.f_97732_).getTileEntity())).getMaxFossilProgress(), 25);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 60, this.f_97736_ + 23, 176, 1, fossilScale, 4);
    }

    private void renderOnboardingTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if (this.f_97734_ != null) {
            int index = this.f_97734_.f_40219_;
            ItemStack itemStack = ((RevivalStandMenu)this.f_97732_).m_38853_(index).m_7993_();
            Optional.ofNullable(MISSING_ITEM_TOOLTIPS.get(index)).filter(tooltip -> itemStack.m_41619_()).ifPresent(component -> pGuiGraphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)component, 115), pMouseX, pMouseY));
        }
    }
}

