/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.base;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;

public abstract class AgeableFish
extends AbstractFish {
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(AgeableFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int BABY_START_AGE = -24000;
    protected int age;
    protected int forcedAge;
    protected int forcedAgeTimer;

    public AgeableFish(EntityType<? extends AbstractFish> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BABY_ID, (Object)false);
    }

    public int getAge() {
        if (this.m_9236_().f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(DATA_BABY_ID) != false ? -1 : 1;
        }
        return this.age;
    }

    public void ageUp(int pAmount, boolean pForced) {
        int i = this.getAge();
        if ((i += pAmount * 20) > 0) {
            i = 0;
        }
        this.setAge(i);
        if (pForced && this.forcedAgeTimer == 0) {
            this.forcedAgeTimer = 40;
        }
        if (this.getAge() == 0) {
            this.setAge(this.forcedAge);
        }
    }

    public void ageUp(int pAmount) {
        this.ageUp(pAmount, false);
    }

    public void setAge(int pAge) {
        int i = this.getAge();
        this.age = pAge;
        if (i < 0 && pAge >= 0 || i >= 0 && pAge < 0) {
            this.f_19804_.m_135381_(DATA_BABY_ID, (Object)(pAge < 0 ? 1 : 0));
            this.ageBoundaryReached();
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Age", this.getAge());
        pCompound.m_128405_("ForcedAge", this.forcedAge);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setAge(pCompound.m_128451_("Age"));
        this.forcedAge = pCompound.m_128451_("ForcedAge");
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_BABY_ID.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.m_6084_()) {
            int i = this.getAge();
            if (i < 0) {
                this.setAge(++i);
            } else if (i > 0) {
                this.setAge(--i);
            }
        }
    }

    protected void ageBoundaryReached() {
        Boat boat;
        Entity entity;
        if (!this.m_6162_() && this.m_20159_() && (entity = this.m_20202_()) instanceof Boat && !(boat = (Boat)entity).m_271938_((Entity)this)) {
            this.m_8127_();
        }
    }

    public boolean m_6162_() {
        return this.getAge() < 0;
    }

    public void m_6863_(boolean pBaby) {
        this.setAge(pBaby ? -24000 : 0);
    }

    public static int getSpeedUpSecondsWhenFeeding(int pTicksUntilAdult) {
        return (int)((float)(pTicksUntilAdult / 20) * 0.1f);
    }
}

