/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.FluidState;
import net.reaper.ancientnature.api.common.animator.IAnimateable;
import net.reaper.ancientnature.api.common.animator.MobAnimator;
import net.reaper.ancientnature.api.common.tag.IHasEntityTags;
import net.reaper.ancientnature.api.common.tag.TagBuilder;
import net.reaper.ancientnature.client.entity.animation.SmoothAnimationState;
import net.reaper.ancientnature.common.entity.ai.control.SmoothBodyRotationControl;
import net.reaper.ancientnature.common.entity.ai.hunger.HungerController;
import net.reaper.ancientnature.common.entity.ai.hunger.IEatable;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.MobDiet;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.MobDietRegistry;
import net.reaper.ancientnature.common.entity.ai.properties.AnimalProperties;
import net.reaper.ancientnature.common.entity.ai.roar.IRoaringAnimal;
import net.reaper.ancientnature.common.entity.ai.roar.RoarController;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.enums.Gender;
import net.reaper.ancientnature.common.enums.TamableOrders;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANEntityData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAnimal<T extends BaseAnimal<T>>
extends TamableAnimal
implements IRoaringAnimal,
IEatable,
IAnimateable<T>,
IHasEntityTags {
    private static final EntityDataAccessor<Gender> GENDER = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)((EntityDataSerializer)ANEntityData.GENDER.get()));
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_EATING = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SMART_ANIMAL_POSE = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> POSE_TICK = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_HUNGRY = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> STAMINA = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> HAS_EGGS = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ROARING = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ORDER = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GESTATION_TICKS = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STARVATION_TICKS = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    public MobAnimator<T> animator = null;
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(BaseAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final int EGG_LAYING_COOLDOWN = 6000;
    public static final int STOMACH_IS_FULL_TICKS = 12000;
    public SmoothAnimationState idleAnimation = new SmoothAnimationState();
    public SmoothAnimationState eatAnimation = new SmoothAnimationState();
    public SmoothAnimationState attackAnimation = new SmoothAnimationState();
    public int idleAnimationTimeout;
    public int attackAnimationTimeout;
    public int attackTicker = 0;
    public int eatAnimationTimeout;
    public int poseTicks;
    public RoarController<T> roar;
    @Nullable
    public BlockPos jukeboxPosition;
    @NotNull
    public AnimalDiet animalDiet;
    @NotNull
    public MobDiet diet = MobDietRegistry.INSTANCE.getOrLoad(this.m_6095_());
    @Nullable
    public HungerController<T> hunger;
    public int restoreStaminaCooldown;
    public float tailRot;
    public float prevTailRot;
    public boolean isSprintingToOwner;
    @Nullable
    public ItemEntity targetItem = null;

    @Override
    @NotNull
    public MobAnimator<T> getAnimator() {
        if (this.animator == null) {
            this.animator = new MobAnimator<BaseAnimal>(this);
        }
        return this.animator;
    }

    @Override
    public void initAnimations() {
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmoothBodyRotationControl<BaseAnimal>(this);
    }

    @Override
    public void addTags(@NotNull TagBuilder builder) {
    }

    public BaseAnimal(@NotNull EntityType<? extends TamableAnimal> type, @NotNull Level level) {
        super(type, level);
        AnimalDiet.Builder dietBuilder = new AnimalDiet.Builder();
        this.defineDiet(dietBuilder);
        this.animalDiet = dietBuilder.build();
    }

    @NotNull
    public BaseAnimal entity() {
        return this;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GENDER, (Object)Gender.MALE);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(SMART_ANIMAL_POSE, (Object)BaseAnimalPose.IDLE.ordinal());
        this.f_19804_.m_135372_(POSE_TICK, (Object)0);
        this.f_19804_.m_135372_(TICKS_UNTIL_HUNGRY, (Object)0);
        this.f_19804_.m_135372_(STAMINA, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HAS_EGGS, (Object)false);
        this.f_19804_.m_135372_(IS_EATING, (Object)false);
        this.f_19804_.m_135372_(IS_ROARING, (Object)false);
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(GESTATION_TICKS, (Object)0);
        this.f_19804_.m_135372_(ORDER, (Object)TamableOrders.IDLE.ordinal());
        this.f_19804_.m_135372_(HUNGER, (Object)0);
        this.f_19804_.m_135372_(STARVATION_TICKS, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("age", this.m_146764_());
        tag.m_128405_("PoseTicks", this.getPoseTicks());
        tag.m_128379_("HasEggs", this.doesHaveEggs());
        tag.m_128350_("ticksUntilHungry", (float)this.getTicksUntilHungry());
        tag.m_128350_("Stamina", this.getStamina());
        tag.m_128405_("GestationTicks", this.getGestationTicks());
        tag.m_128405_("Hunger", this.getHunger());
        tag.m_128405_("StarvationTicks", this.getStarvationTicks());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setPoseTicks(tag.m_128451_("PoseTicks"));
        this.setHasEggs(tag.m_128471_("HasEggs"));
        this.m_146762_(tag.m_128451_("age"));
        this.setTicksUntilHungry(tag.m_128451_("ticksUntilHungry"));
        this.setStamina(tag.m_128457_("Stamina"));
        this.setGestationTicks(tag.m_128451_("GestationTicks"));
        tag.m_128405_("Order", this.getOrder().ordinal());
        this.setHunger(tag.m_128451_("Hunger"));
        this.setStarvationTicks(tag.m_128451_("StarvationTicks"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.poseTicks > 0) {
            --this.poseTicks;
        }
        if (this.attackTicker > 0) {
            --this.attackTicker;
        } else {
            this.setAttacking(false);
        }
        if (this.getTicksUntilHungry() > 0) {
            this.setTicksUntilHungry(this.getTicksUntilHungry() - 1);
        }
        if (this.isGestating()) {
            int newTicks = this.getGestationTicks() - 1;
            this.setGestationTicks(newTicks);
            if (newTicks <= 0) {
                this.setHasEggs(true);
            }
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
        if (this.roar != null) {
            this.roar.tick();
        }
        if (!this.m_9236_().f_46443_ && this.hunger != null) {
            this.hunger.update();
        }
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
    }

    public int getAnimationLengthInTicks(BaseAnimalPose pose) {
        return 0;
    }

    public int getAttackAnimationDamageDelay() {
        return 0;
    }

    public int getEatAnimationConsumeDelay() {
        return 0;
    }

    protected void attackAnimationSetup() {
        if (this.attackAnimationTimeout <= 0 && this.isAttacking()) {
            this.idleAnimation.m_216973_();
            this.attackAnimationTimeout = 20;
            this.attackAnimation.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking() || this.isEating()) {
            this.attackAnimation.m_216973_();
        }
    }

    protected void eatingAnimationSetup() {
        if (this.isEating() && this.eatAnimationTimeout <= 0) {
            this.idleAnimation.m_216973_();
            this.eatAnimationTimeout = 20;
            this.eatAnimation.m_216977_(this.f_19797_);
        } else if (!this.isEating()) {
            this.eatAnimation.m_216973_();
            this.setEating(false);
        } else {
            --this.eatAnimationTimeout;
        }
    }

    protected void setupAnimationStates() {
        this.attackAnimationSetup();
        this.eatingAnimationSetup();
    }

    protected boolean isFluidDeepEnoughToSwim(float pDepthRequired) {
        FluidState fluidState;
        float totalDepth = 0.0f;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)this.m_20183_());
        while (pos.m_123342_() >= this.m_9236_().m_141937_() && !(fluidState = this.m_9236_().m_6425_((BlockPos)pos)).m_76178_()) {
            float blockFluidHeight = fluidState.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)pos);
            if ((totalDepth += blockFluidHeight) >= pDepthRequired) {
                return true;
            }
            pos.m_122173_(Direction.DOWN);
        }
        return false;
    }

    protected void m_267689_(float partialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob other) {
        Entity entity = this.m_6095_().m_20615_((Level)level);
        if (entity instanceof BaseAnimal) {
            BaseAnimal animal = (BaseAnimal)entity;
            return animal;
        }
        return null;
    }

    public Gender getGender() {
        return (Gender)((Object)this.f_19804_.m_135370_(GENDER));
    }

    public void setGender(Gender gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public int getBabyAge() {
        return this.m_146764_();
    }

    public int m_146764_() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public void m_146762_(int pAge) {
        this.f_19804_.m_135381_(AGE, (Object)pAge);
    }

    public boolean canBeBaby() {
        return true;
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.m_6162_() && this.m_146764_() <= 0 && !this.doesHaveEggs();
    }

    public boolean doesHaveEggs() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGGS);
    }

    public void setHasEggs(boolean hasEggs) {
        this.f_19804_.m_135381_(HAS_EGGS, (Object)hasEggs);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public void setAttacking(boolean isAttacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)isAttacking);
    }

    @Override
    public boolean isRoaring() {
        return (Boolean)this.f_19804_.m_135370_(IS_ROARING);
    }

    @Override
    public void setRoaring(boolean isRoar) {
        this.f_19804_.m_135381_(IS_ROARING, (Object)isRoar);
    }

    public int getGestationTicks() {
        return (Integer)this.f_19804_.m_135370_(GESTATION_TICKS);
    }

    public void setGestationTicks(int ticks) {
        this.f_19804_.m_135381_(GESTATION_TICKS, (Object)ticks);
    }

    public boolean isGestating() {
        return this.getGestationTicks() > 0;
    }

    public int getGestationTime() {
        return 3600;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && this.m_21824_()) {
            this.setNextOrder();
            this.sendOrderMessage(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void setNextOrder() {
        if (this.getOrder() == TamableOrders.WANDER || this.getOrder() == TamableOrders.IDLE) {
            this.setOrder(TamableOrders.FOLLOW);
        } else if (this.getOrder() == TamableOrders.FOLLOW) {
            this.setOrder(TamableOrders.SIT);
        } else if (this.getOrder() == TamableOrders.SIT) {
            this.setOrder(TamableOrders.WANDER);
        }
    }

    protected void sendOrderMessage(Player pPlayer) {
        if (this.getOrder() == TamableOrders.WANDER) {
            pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.ancientnature.order.wander")), true);
        } else if (this.getOrder() == TamableOrders.FOLLOW) {
            pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.ancientnature.order.follow")), true);
        } else if (this.getOrder() == TamableOrders.SIT) {
            pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.ancientnature.order.sit")), true);
        } else if (this.getOrder() == TamableOrders.ATTACK) {
            pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.ancientnature.order.attack")), true);
        }
    }

    public TamableOrders getOrder() {
        return TamableOrders.values()[(Integer)this.f_19804_.m_135370_(ORDER)];
    }

    public void setOrder(@NotNull TamableOrders order) {
        this.f_19804_.m_135381_(ORDER, (Object)order.ordinal());
    }

    public boolean cantFollowOwner() {
        return this.getOrder() != TamableOrders.FOLLOW;
    }

    public boolean canBeTamed() {
        return true;
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return this.animalDiet.test(stack);
    }

    public void defineDiet(AnimalDiet.Builder dietBuilder) {
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(IS_EATING);
    }

    public void setEating(boolean isEating) {
        this.f_19804_.m_135381_(IS_EATING, (Object)isEating);
    }

    @Nullable
    protected HungerController<T> createHunger() {
        return new HungerController<T>(this, new HungerController.Params(20, 1)){

            @Override
            public int getMaxHunger() {
                return 300;
            }
        };
    }

    @Override
    @Nullable
    public ItemEntity getTargetItem() {
        return this.targetItem;
    }

    @Override
    public void setTargetItem(@Nullable ItemEntity item) {
        this.targetItem = item;
    }

    public void setHunger(int value) {
        this.f_19804_.m_135381_(HUNGER, (Object)value);
    }

    public int getHunger() {
        return (Integer)this.f_19804_.m_135370_(HUNGER);
    }

    public void setStarvationTicks(int value) {
        this.f_19804_.m_135381_(STARVATION_TICKS, (Object)value);
    }

    public int getStarvationTicks() {
        return (Integer)this.f_19804_.m_135370_(STARVATION_TICKS);
    }

    public int getTicksUntilHungry() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_HUNGRY);
    }

    public void setTicksUntilHungry(int ticks) {
        this.f_19804_.m_135381_(TICKS_UNTIL_HUNGRY, (Object)ticks);
    }

    public boolean isHungry() {
        return this.getTicksUntilHungry() <= 0;
    }

    public boolean isHalfHungry() {
        return this.getTicksUntilHungry() <= 6000;
    }

    public boolean isHungryEnoughToHunt() {
        return (double)this.getTicksUntilHungry() <= 9000.0;
    }

    public AnimalProperties getProperties() {
        return new AnimalProperties();
    }

    public float getStamina() {
        return ((Float)this.f_19804_.m_135370_(STAMINA)).floatValue();
    }

    public void setStamina(float stamina) {
        this.f_19804_.m_135381_(STAMINA, (Object)Float.valueOf(Mth.m_14036_((float)stamina, (float)0.0f, (float)100.0f)));
    }

    public int getPoseTicks() {
        return this.poseTicks;
    }

    public void setPoseTicks(int poseTicks) {
        this.poseTicks = Math.max(0, poseTicks);
    }

    public BaseAnimalPose getSmartPose() {
        return BaseAnimalPose.values()[(Integer)this.f_19804_.m_135370_(SMART_ANIMAL_POSE)];
    }

    public void setSmartPose(@NotNull BaseAnimalPose pose) {
        this.f_19804_.m_135381_(SMART_ANIMAL_POSE, (Object)pose.ordinal());
    }

    @Nullable
    protected EntityDimensions getSitBox() {
        return null;
    }

    @Nullable
    protected EntityDimensions getBabySitBox() {
        return null;
    }

    @Nullable
    protected EntityDimensions getBabyBox() {
        return null;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        EntityDimensions sitBox;
        if (this.m_6162_()) {
            EntityDimensions babySitBox;
            if ((this.getSmartPose() == BaseAnimalPose.SIT || this.getSmartPose() == BaseAnimalPose.SLEEP) && (babySitBox = this.getBabySitBox()) != null) {
                return babySitBox;
            }
            EntityDimensions babyBox = this.getBabyBox();
            if (babyBox != null) {
                return babyBox;
            }
        } else if ((this.getSmartPose() == BaseAnimalPose.SIT || this.getSmartPose() == BaseAnimalPose.SLEEP) && (sitBox = this.getSitBox()) != null) {
            return sitBox;
        }
        return super.m_6972_(pose);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        if (AGE.equals(key) || SMART_ANIMAL_POSE.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        this.setSmartPose(BaseAnimalPose.IDLE);
        this.setStamina(100.0f);
        return super.m_6518_(level, difficulty, reason, data, tag);
    }
}

