/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.ai.properties.ControlType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseRideableAnimal<T extends BaseSleepingAnimal<T>>
extends BaseSleepingAnimal<T>
implements ContainerListener {
    public static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(BaseRideableAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public SimpleContainer animalInventory;
    private LazyOptional<?> itemHandler = null;
    protected ControlType controlType = ControlType.GROUND;
    public int tickControlled;

    protected BaseRideableAnimal(EntityType<? extends BaseSleepingAnimal> entityType, Level level) {
        super(entityType, level);
        if (this.hasInventory()) {
            this.initializeAnimalInventory();
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SADDLED, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Saddled", this.isSaddled());
        if (this.hasInventory() && this.animalInventory != null) {
            ListTag listTag = new ListTag();
            for (int index = 0; index < this.animalInventory.m_6643_(); ++index) {
                ItemStack itemstack = this.animalInventory.m_8020_(index);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundNBT = new CompoundTag();
                compoundNBT.m_128344_("Slot", (byte)index);
                itemstack.m_41739_(compoundNBT);
                listTag.add((Object)compoundNBT);
            }
            tag.m_128365_("Items", (Tag)listTag);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setSaddled(tag.m_128471_("Saddled"));
        if (this.hasInventory()) {
            ListTag listTag = tag.m_128437_("Items", 10);
            this.initializeAnimalInventory();
            for (int index = 0; index < listTag.size(); ++index) {
                CompoundTag tag1 = listTag.m_128728_(index);
                int slot = tag1.m_128445_("Slot") & 0xFF;
                this.animalInventory.m_6836_(slot, ItemStack.m_41712_((CompoundTag)tag1));
            }
            this.updateContainerEquipment();
        }
    }

    public boolean hasInventory() {
        return true;
    }

    public int getInventorySize() {
        return 8;
    }

    public void initializeAnimalInventory() {
        SimpleContainer prevInventory = this.animalInventory;
        this.animalInventory = new SimpleContainer(this.getInventorySize()){

            public boolean m_6542_(@NotNull Player pPlayer) {
                return BaseRideableAnimal.this.m_6084_() && !BaseRideableAnimal.this.f_19817_;
            }
        };
        if (prevInventory != null) {
            prevInventory.m_19181_((ContainerListener)this);
            int maxSlotsToCopy = Math.min(prevInventory.m_6643_(), this.animalInventory.m_6643_());
            for (int index = 0; index < maxSlotsToCopy; ++index) {
                ItemStack itemstack = prevInventory.m_8020_(index);
                if (itemstack.m_41619_()) continue;
                this.animalInventory.m_6836_(index, itemstack.m_41777_());
            }
        }
        this.animalInventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.animalInventory));
    }

    public void m_5757_(@NotNull Container container) {
        boolean wasSaddled = this.isSaddled();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !wasSaddled && this.isSaddled()) {
            this.m_5496_(SoundEvents.f_244204_, 0.5f, 1.0f);
        }
    }

    public void m_6667_(@NotNull DamageSource source) {
        super.m_6667_(source);
        if (!this.m_9236_().f_46443_ && this.animalInventory != null) {
            for (int index = 0; index < this.animalInventory.m_6643_(); ++index) {
                ItemStack itemstack = this.animalInventory.m_8020_(index);
                if (itemstack.m_41619_()) continue;
                this.m_5552_(itemstack, 0.0f);
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.setSaddled(!this.animalInventory.m_8020_(0).m_41619_());
        }
    }

    @NotNull
    public SlotAccess m_141942_(int slot) {
        if (this.animalInventory != null) {
            int inventorySize = this.animalInventory.m_6643_();
            if (slot == 0) {
                return new SlotAccess(){

                    @NotNull
                    public ItemStack m_142196_() {
                        return BaseRideableAnimal.this.animalInventory.m_8020_(0);
                    }

                    public boolean m_142104_(@NotNull ItemStack pStack) {
                        if (pStack.m_41619_() || pStack.m_150930_(BaseRideableAnimal.this.getSaddleItem().m_41720_())) {
                            BaseRideableAnimal.this.animalInventory.m_6836_(0, pStack);
                            return true;
                        }
                        return false;
                    }
                };
            }
            if (slot >= 0 && slot < inventorySize) {
                return SlotAccess.m_147292_((Container)this.animalInventory, (int)slot);
            }
        }
        return super.m_141942_(slot);
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public boolean isSaddleable() {
        return this.m_6084_() && !this.m_6162_();
    }

    public ItemStack getSaddleItem() {
        return ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.tickControlled = this.m_146895_() != null ? ++this.tickControlled : 0;
    }

    public boolean canSprintByPlayer() {
        return true;
    }

    public boolean isRideable() {
        return true;
    }

    @Contract(value="null->false")
    public boolean makeEntityRide(@Nullable LivingEntity entity) {
        if (entity != null && entity.m_20202_() != this) {
            entity.m_146922_(this.m_146908_());
            entity.m_146926_(this.m_146909_());
            entity.m_5616_(this.m_6080_());
            entity.m_20329_((Entity)this);
            return true;
        }
        return false;
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_().m_122479_()) {
            int[][] offsets = DismountHelper.m_38467_((Direction)direction);
            for (Pose pose : passenger.m_7431_()) {
                for (int[] offset : offsets) {
                    BlockPos targetPos = this.m_20183_().m_7918_(offset[0], 0, offset[1]);
                    double floorHeight = this.m_9236_().m_45573_(targetPos);
                    if (!DismountHelper.m_38439_((double)floorHeight)) continue;
                    Vec3 dismountPos = Vec3.m_82514_((Vec3i)targetPos, (double)floorHeight);
                    if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)passenger, (AABB)passenger.m_21270_(pose).m_82383_(dismountPos))) continue;
                    passenger.m_20124_(pose);
                    return dismountPos;
                }
            }
        }
        return super.m_7688_(passenger);
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    protected void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (this.m_20365_(passenger)) {
            callback.m_20372_(passenger, this.m_20185_(), this.m_20186_() + this.m_6048_(), this.m_20189_());
        } else {
            super.m_19956_(passenger, callback);
        }
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        if (this.m_21830_((LivingEntity)player) && !this.m_6162_() && this.isRideable()) {
            if (!this.isSaddled()) {
                return InteractionResult.PASS;
            }
            if (this.m_7310_((Entity)player) && this.makeEntityRide((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_7111_(player, vec, hand);
    }

    protected float[] getInputSpeed(@NotNull Player rider) {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player rider, @NotNull Vec3 travelVector) {
        if (this.isRideable() && this.m_20160_()) {
            float forwardMovementFactor = rider.f_20902_ < 0.0f ? 0.0f : 1.0f;
            float[] speed = this.getInputSpeed(rider);
            return new Vec3((double)(rider.f_20900_ * speed[0]), (double)speed[1], (double)(rider.f_20902_ * speed[2] * forwardMovementFactor));
        }
        return Vec3.f_82478_;
    }

    protected void m_274498_(@NotNull Player player, @NotNull Vec3 travelVector) {
        super.m_274498_(player, travelVector);
        if (this.isRideable()) {
            this.m_6710_(null);
            if (this.controlType == ControlType.GROUND && (player.f_20900_ != 0.0f || player.f_20902_ != 0.0f)) {
                float rot;
                this.f_19859_ = rot = Mth.m_14189_((float)0.1f, (float)this.f_19859_, (float)player.m_6080_());
                this.f_20883_ = rot;
                this.f_20885_ = rot;
                this.m_146922_(Mth.m_14189_((float)0.1f, (float)this.m_146908_(), (float)player.m_146908_()));
            }
        }
    }

    public LivingEntity m_6688_() {
        Player player;
        Entity entity = this.m_146895_();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    public abstract void equipSaddle(@Nullable SoundSource var1);
}

