/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.base;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.reaper.ancientnature.client.entity.animation.SmoothAnimationState;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepAnims;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepController;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepPeriod;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepingLookControl;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.enums.TamableOrders;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSleepingAnimal<T extends BaseSleepingAnimal<T>>
extends BaseAnimal<T> {
    private static final EntityDataAccessor<Integer> BEDTIME_VARIANCE = SynchedEntityData.m_135353_(BaseSleepingAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Long> DAY_TIME = SynchedEntityData.m_135353_(BaseSleepingAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private int wakeUpCounter = 0;
    private static final int WAKE_UP_DURATION = 200;
    private int wakeUpRadius = 5;
    public SmoothAnimationState swimAnimation = new SmoothAnimationState();
    public SmoothAnimationState sitAnimation = new SmoothAnimationState();
    public SmoothAnimationState sleepAnimation = new SmoothAnimationState();
    public SmoothAnimationState upAnimation = new SmoothAnimationState();
    public SmoothAnimationState downAnimation = new SmoothAnimationState();
    public SmoothAnimationState fallAlseepAnimation = new SmoothAnimationState();
    public SmoothAnimationState wakeUpAnimation = new SmoothAnimationState();
    public static final EntityDataAccessor<Boolean> SLEEP = SynchedEntityData.m_135353_(BaseSleepingAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> REST = SynchedEntityData.m_135353_(BaseSleepingAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    public SleepAnims sleepAnims = null;
    @Nullable
    public SleepController<T> sleep;

    @Nullable
    public SleepAnims getSleepAnimations() {
        return null;
    }

    @NotNull
    public SleepController<T> createSleep() {
        return new SleepController<BaseSleepingAnimal>(this, new SleepController.Params(true, true, SleepPeriod.DAY)).setAnims(this.sleepAnims);
    }

    public boolean isRest() {
        return (Boolean)this.f_19804_.m_135370_(REST);
    }

    public void setRest(boolean value) {
        this.f_19804_.m_135381_(REST, (Object)value);
    }

    public boolean isSleep() {
        return (Boolean)this.f_19804_.m_135370_(SLEEP);
    }

    public void setSleep(boolean value) {
        this.f_19804_.m_135381_(SLEEP, (Object)value);
    }

    protected BaseSleepingAnimal(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        AnimalDiet.Builder dietBuilder = new AnimalDiet.Builder();
        this.defineDiet(dietBuilder);
        this.animalDiet = dietBuilder.build();
        this.f_21365_ = new SleepingLookControl((Mob)this);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (!this.f_24974_.m_5803_()) {
                    super.m_8126_();
                }
            }
        };
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.hunger != null) {
            this.hunger.update();
            this.setupAnimationStates();
        }
        if (this.sleep != null) {
            this.sleep.update();
        }
        if (this.wakeUpCounter > 0) {
            --this.wakeUpCounter;
        }
        this.checkWakeUpConditions();
        this.updateDayTime();
    }

    private void updateDayTime() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(DAY_TIME, (Object)this.m_9236_().m_46468_());
    }

    public boolean canAttack() {
        return true;
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
    }

    public boolean shouldSleep() {
        if (this.m_20069_()) {
            return false;
        }
        int dayTime = ((Long)this.f_19804_.m_135370_(DAY_TIME)).intValue();
        int bedtimeVariance = this.getBedtimeVariance();
        if (this.wakeUpCounter > 0) {
            return false;
        }
        return dayTime >= 13000 + bedtimeVariance && dayTime < 23000 + bedtimeVariance;
    }

    protected void m_8099_() {
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("bedtimeVariance", this.getBedtimeVariance());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setBedtimeVariance(pCompound.m_128451_("bedtimeVariance"));
    }

    private void setBedtimeVariance(int bedtimeVariance) {
        this.f_19804_.m_135381_(BEDTIME_VARIANCE, (Object)bedtimeVariance);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BEDTIME_VARIANCE, (Object)0);
        this.f_19804_.m_135372_(DAY_TIME, (Object)this.m_9236_().m_46468_());
        this.f_19804_.m_135372_(SLEEP, (Object)false);
        this.f_19804_.m_135372_(REST, (Object)false);
    }

    public int getBedtimeVariance() {
        return (Integer)this.f_19804_.m_135370_(BEDTIME_VARIANCE);
    }

    public boolean m_5803_() {
        return this.getSmartPose() == BaseAnimalPose.SLEEP;
    }

    @Override
    protected void m_267689_(float pPartialTick) {
        float f = !this.m_5803_() && this.getSmartPose() != BaseAnimalPose.DOWN && this.getSmartPose() != BaseAnimalPose.SIT && this.getSmartPose() != BaseAnimalPose.FALL_ASLEEP && this.getSmartPose() != BaseAnimalPose.SLEEP ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void swimAnimationSetup() {
        this.m_20282_(this.isFluidDeepEnoughToSwim(0.6f));
        if (this.m_6069_()) {
            this.idleAnimation.m_216973_();
            this.downAnimation.m_216973_();
            this.sitAnimation.m_216973_();
            this.upAnimation.m_216973_();
            this.fallAlseepAnimation.m_216973_();
            this.sleepAnimation.m_216973_();
            this.wakeUpAnimation.m_216973_();
            if (!this.swimAnimation.m_216984_()) {
                this.swimAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.swimAnimation.m_216973_();
        }
    }

    @Override
    protected void eatingAnimationSetup() {
        if (this.isEating() && this.eatAnimationTimeout <= 0) {
            this.idleAnimation.m_216973_();
            this.attackAnimation.m_216973_();
            this.eatAnimationTimeout = 20;
            this.eatAnimation.m_216977_(this.f_19797_);
        } else if (!this.isEating()) {
            this.eatAnimation.m_216973_();
            this.eatAnimationTimeout = 0;
            this.setEating(false);
        }
    }

    @Override
    protected void attackAnimationSetup() {
        if (this.attackAnimationTimeout <= 0 && this.isAttacking()) {
            this.idleAnimation.m_216973_();
            this.attackAnimationTimeout = 20;
            this.attackAnimation.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking() || this.isEating()) {
            this.setAttacking(false);
        }
    }

    @Override
    protected void setupAnimationStates() {
        float moveX = (float)(this.m_20185_() - this.f_19854_);
        float moveZ = (float)(this.m_20189_() - this.f_19856_);
        float speed = Mth.m_14116_((float)(moveX * moveX + moveZ * moveZ));
        if (BaseAnimalPose.IDLE == this.getSmartPose() && (double)speed <= 0.05) {
            this.idleAnimation.m_216982_(this.f_19797_);
        } else {
            this.idleAnimation.m_216973_();
        }
        this.swimAnimationSetup();
        this.eatingAnimationSetup();
        this.attackAnimationSetup();
        if (this.getOrder() == TamableOrders.SIT && this.getSmartPose() != BaseAnimalPose.SIT && !this.m_6069_() || this.m_20159_()) {
            if (this.getSmartPose() == BaseAnimalPose.IDLE) {
                this.downAnimation.m_216982_(this.f_19797_);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.DOWN));
                this.setSmartPose(BaseAnimalPose.DOWN);
            }
            if (this.getSmartPose() == BaseAnimalPose.DOWN && this.getPoseTicks() == 0) {
                this.downAnimation.m_216973_();
                this.idleAnimation.m_216973_();
                this.sitAnimation.m_216977_(this.f_19797_);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.SIT));
                this.setSmartPose(BaseAnimalPose.SIT);
            }
        }
        if (this.getOrder() != TamableOrders.SIT && this.getSmartPose() != BaseAnimalPose.IDLE && !this.m_6069_() && !this.m_20159_()) {
            if (this.getSmartPose() == BaseAnimalPose.SIT && !this.m_20159_()) {
                this.sitAnimation.m_216973_();
                this.idleAnimation.m_216973_();
                this.upAnimation.m_216982_(this.f_19797_);
                this.setSmartPose(BaseAnimalPose.UP);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.UP));
            }
            if (this.getSmartPose() == BaseAnimalPose.UP && this.getPoseTicks() == 0 && !this.m_20159_()) {
                this.upAnimation.m_216973_();
                this.idleAnimation.m_216973_();
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.IDLE));
                this.setSmartPose(BaseAnimalPose.IDLE);
            }
        }
        if (this.shouldSleep() && this.getSmartPose() != BaseAnimalPose.SLEEP && !this.m_6069_()) {
            if (this.getSmartPose() == BaseAnimalPose.IDLE) {
                this.downAnimation.m_216982_(this.f_19797_);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.DOWN));
                this.setSmartPose(BaseAnimalPose.DOWN);
            }
            if ((this.getSmartPose() == BaseAnimalPose.DOWN || this.getSmartPose() == BaseAnimalPose.SIT) && this.getPoseTicks() == 0) {
                this.downAnimation.m_216973_();
                this.idleAnimation.m_216973_();
                this.sitAnimation.m_216973_();
                this.fallAlseepAnimation.m_216977_(this.f_19797_);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.FALL_ASLEEP));
                this.setSmartPose(BaseAnimalPose.FALL_ASLEEP);
            }
            if (this.getSmartPose() == BaseAnimalPose.FALL_ASLEEP && this.getPoseTicks() == 0) {
                this.fallAlseepAnimation.m_216973_();
                this.idleAnimation.m_216973_();
                this.sleepAnimation.m_216977_(this.f_19797_);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.SLEEP));
                this.setSmartPose(BaseAnimalPose.SLEEP);
            }
        }
        if (!this.shouldSleep() && this.getSmartPose() == BaseAnimalPose.SLEEP && !this.m_6069_()) {
            this.sleepAnimation.m_216973_();
            this.idleAnimation.m_216973_();
            this.wakeUpAnimation.m_216977_(this.f_19797_);
            this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.WAKE_UP));
            this.setSmartPose(BaseAnimalPose.WAKE_UP);
        }
        if (this.getSmartPose() == BaseAnimalPose.WAKE_UP && this.getPoseTicks() == 0 && !this.m_6069_()) {
            this.wakeUpAnimation.m_216973_();
            this.idleAnimation.m_216973_();
            if (this.getOrder() == TamableOrders.SIT || this.m_20159_()) {
                this.sitAnimation.m_216977_(this.f_19797_);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.SIT));
                this.setSmartPose(BaseAnimalPose.SIT);
            } else {
                this.sitAnimation.m_216973_();
                this.upAnimation.m_216977_(this.f_19797_);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.UP));
                this.setSmartPose(BaseAnimalPose.UP);
            }
        }
        if (this.getSmartPose() == BaseAnimalPose.UP && this.getPoseTicks() == 0 && !this.m_6069_() && !this.m_20159_()) {
            this.upAnimation.m_216973_();
            this.idleAnimation.m_216973_();
            this.idleAnimation.m_216982_(this.f_19797_);
            this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.IDLE));
            this.setSmartPose(BaseAnimalPose.IDLE);
        }
        if (this.shouldSleep() && this.getSmartPose() == BaseAnimalPose.SLEEP && this.getPoseTicks() == 0 && !this.m_6069_()) {
            this.sleepAnimation.m_216973_();
            this.idleAnimation.m_216973_();
            this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.SLEEP));
            this.setSmartPose(BaseAnimalPose.SLEEP);
            this.sleepAnimation.m_216977_(this.f_19797_);
        }
        if (!(this.shouldSleep() || this.getSmartPose() != BaseAnimalPose.DOWN || this.getOrder() == TamableOrders.SIT || this.m_6069_() || this.m_20159_())) {
            this.downAnimation.m_216973_();
            this.idleAnimation.m_216973_();
            this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.UP));
            this.setSmartPose(BaseAnimalPose.UP);
            this.upAnimation.m_216982_(this.f_19797_);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.shouldSleep() || this.getOrder() == TamableOrders.SIT) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            this.f_21344_.m_26573_();
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
        }
    }

    public boolean isSitting() {
        return this.getSmartPose() == BaseAnimalPose.SIT;
    }

    private void checkWakeUpConditions() {
        List nearbyPlayers = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_((double)this.wakeUpRadius));
        for (Player player : nearbyPlayers) {
            if (player.m_6047_() || !(player.m_20184_().m_82556_() > 0.0)) continue;
            this.wakeUpCounter = 200;
            break;
        }
        if (this.f_20916_ > 0) {
            this.wakeUpCounter = 200;
        }
    }

    public void setPose(BaseAnimalPose pose) {
    }
}

