/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.base;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.api.common.misc.BooleanWatcher;
import net.reaper.ancientnature.api.common.tag.EntityTag;
import net.reaper.ancientnature.api.common.tag.TagBuilder;
import net.reaper.ancientnature.api.common.tag.TagType;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.ai.pathing.water.ObstacleNodeEvaluator;
import org.jetbrains.annotations.NotNull;

public abstract class BaseWaterAnimal<T extends BaseWaterAnimal<T>>
extends BaseAnimal<T> {
    public static final EntityTag<Integer> FLOP_TICKS = new EntityTag(BaseWaterAnimal.class, "FlopTicks", TagType.INTEGER);
    protected BooleanWatcher inWaterWatcher = new BooleanWatcher(false);
    @OnlyIn(value=Dist.CLIENT)
    public float roll = 0.0f;

    protected BaseWaterAnimal(@NotNull EntityType<? extends TamableAnimal> type, @NotNull Level level) {
        super(type, level);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 1.0f, 0.1f, false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    @Override
    public void addTags(@NotNull TagBuilder builder) {
        super.addTags(builder);
        builder.add(FLOP_TICKS);
    }

    public boolean m_6040_() {
        return true;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new WaterBoundPathNavigation((Mob)this, level){

            @NotNull
            protected PathFinder m_5532_(int max) {
                this.f_26508_ = new ObstacleNodeEvaluator(2, true);
                return new PathFinder(this.f_26508_, max);
            }
        };
    }

    public void m_7023_(@NotNull Vec3 travelVec) {
        if (this.m_20069_() && (this.m_21515_() || this.m_20160_())) {
            this.m_19920_(this.m_6113_(), travelVec);
            this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_267651_(false);
        } else {
            super.m_7023_(travelVec);
        }
    }

    public boolean canFlop() {
        return true;
    }

    protected abstract void handleAirSupply(int var1);

    public void m_8107_() {
        super.m_8107_();
        if (this.canFlop()) {
            if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
                this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
                this.m_6853_(false);
                this.f_19812_ = true;
                this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
                FLOP_TICKS.set((Entity)this, 20);
            }
            if (FLOP_TICKS.get((Entity)this) > 0) {
                FLOP_TICKS.set((Entity)this, FLOP_TICKS.get((Entity)this) - 1);
            }
        }
    }

    public boolean canBreath() {
        return !this.m_20072_();
    }

    public int getMaxAir() {
        return 300;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_6084_() && !this.m_21525_()) {
            if (this.canBreath() && this.m_6084_()) {
                int air = this.m_20146_() - 1;
                this.m_20301_(air);
                if (air == -20) {
                    this.m_20301_(0);
                    this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
                }
            } else {
                this.m_20301_(this.getMaxAir());
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.inWaterWatcher.update(this.m_20069_(), new BooleanWatcher.Listener(){

                @Override
                public void onTrue() {
                    BaseWaterAnimal.this.onEnterWater();
                }

                @Override
                public void onFalse() {
                    BaseWaterAnimal.this.onExitWater();
                }
            });
        }
    }

    protected void onEnterWater() {
    }

    protected void onExitWater() {
    }

    @NotNull
    public BaseAnimation createFlopAnim(@NotNull AnimData data, @NotNull float duration) {
        return new SimpleAnimation("flop", data, Loop.CYCLE, 1, duration).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

            @Override
            public boolean canPlay(@NotNull BaseAnimation anim) {
                return !BaseWaterAnimal.this.m_20069_() && FLOP_TICKS.get((Entity)BaseWaterAnimal.this) > 0;
            }
        });
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(@NotNull Player player) {
        return false;
    }

    @NotNull
    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    protected int m_7305_(int air) {
        return this.m_6062_();
    }

    public boolean canDrownInFluidType(@NotNull FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    @NotNull
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12329_;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(@NotNull LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    public Vec3 getSwimRadius() {
        return new Vec3(35.0, 10.0, 35.0);
    }
}

