/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.base;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.reaper.ancientnature.api.common.tag.EntityTag;
import net.reaper.ancientnature.api.common.tag.IHasEntityTags;
import net.reaper.ancientnature.api.common.tag.TagBuilder;
import net.reaper.ancientnature.api.common.tag.TagType;
import net.reaper.ancientnature.common.base.BaseWaterAnimal;
import net.reaper.ancientnature.common.entity.ParanogmiusEntity;
import net.reaper.ancientnature.common.enums.Gender;
import org.jetbrains.annotations.NotNull;

public abstract class BucketableWaterAnimal<T extends BucketableWaterAnimal<T>>
extends BaseWaterAnimal<T>
implements Bucketable,
IHasEntityTags {
    public static final EntityTag<Boolean> FROM_BUCKET = new EntityTag(ParanogmiusEntity.class, "FromBucket", TagType.BOOLEAN);
    private final ItemStack bucket;

    protected BucketableWaterAnimal(@NotNull EntityType<? extends TamableAnimal> type, @NotNull Level level, @NotNull ItemStack bucket) {
        super(type, level);
        this.bucket = bucket;
    }

    @Override
    public void addTags(@NotNull TagBuilder builder) {
        super.addTags(builder);
        builder.add(FROM_BUCKET);
    }

    public boolean m_27487_() {
        return FROM_BUCKET.get((Entity)this);
    }

    public void m_27497_(boolean value) {
        FROM_BUCKET.set((Entity)this, value);
    }

    public void m_6872_(@NotNull ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("Age", this.m_146764_());
        tag.m_128359_("Gender", this.getGender().toString());
        tag.m_128405_("isBaby", this.m_6162_() ? 1 : 0);
    }

    public void m_142278_(@NotNull CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        if (tag.m_128441_("Age")) {
            this.m_146762_(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(Gender.valueOf(tag.m_128461_("Gender").toUpperCase()));
        }
        if (tag.m_128441_("isBaby")) {
            this.m_6863_(tag.m_128451_("isBaby") == 1);
        }
    }

    protected boolean canBeBucketed(@NotNull Player player, @NotNull InteractionHand hand) {
        return true;
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        Optional result;
        if (this.canBeBucketed(player, hand) && (result = Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this)).isPresent() && ((InteractionResult)result.get()).m_19077_()) {
            return (InteractionResult)result.get();
        }
        return super.m_6071_(player, hand);
    }

    @NotNull
    public ItemStack m_28282_() {
        return this.bucket;
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    @NotNull
    public ItemStack getBucket() {
        return this.bucket;
    }
}

