/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.reaper.ancientnature.common.block.ZaphrentisBlock;
import net.reaper.ancientnature.core.registry.ANBlocks;
import org.jetbrains.annotations.Nullable;

public class LivingZaphrentisBlock
extends ZaphrentisBlock {
    public LivingZaphrentisBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return;
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        double x = (double)pPos.m_123341_() + 0.5;
        double y = (double)pPos.m_123342_() + 0.7;
        double z = (double)pPos.m_123343_() + 0.5;
        Direction opposite = direction.m_122424_();
        pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123774_, x + 0.15 * (double)opposite.m_122429_(), y, z + 0.15 * (double)opposite.m_122431_(), 0.0, 0.0, 0.0);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.scanForWater((BlockGetter)pLevel, pPos)) {
            pLevel.m_7731_(pPos, (BlockState)((Block)ANBlocks.DEAD_ZAPHRENTIS.get()).m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)pState.m_61143_((Property)FACING))), 2);
        }
    }

    @Override
    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!this.scanForWater((BlockGetter)pLevel, pCurrentPos)) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 60 + pLevel.m_213780_().m_188503_(40));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected boolean scanForWater(BlockGetter pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        for (Direction direction : Direction.values()) {
            FluidState fluidstate = pLevel.m_6425_(pPos.m_121945_(direction));
            if (!state.canBeHydrated(pLevel, pPos, fluidstate, pPos.m_121945_(direction))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        if (!this.scanForWater((BlockGetter)pContext.m_43725_(), pContext.m_8083_())) {
            pContext.m_43725_().m_186460_(pContext.m_8083_(), (Block)this, 60 + pContext.m_43725_().m_213780_().m_188503_(40));
        }
        return super.m_5573_(pContext);
    }
}

