/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.reaper.ancientnature.common.block.BlockEntityBlock;
import net.reaper.ancientnature.common.block.blockentity.RevivalStandBlockEntity;
import net.reaper.ancientnature.common.util.WorldUtils;
import net.reaper.ancientnature.core.registry.ANAdvancementsRegistry;
import net.reaper.ancientnature.core.registry.ANBlockEntities;
import net.reaper.ancientnature.core.registry.ANParticles;
import net.reaper.ancientnature.core.registry.ANTags;
import org.jetbrains.annotations.Nullable;

public class RevivalStandBlock
extends BlockEntityBlock {
    public static final IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)1, (int)4);
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private int tickCount = 0;
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)RevivalStandBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)31.0, (double)12.0), (VoxelShape[])new VoxelShape[0]);

    public RevivalStandBlock() {
        super(RevivalStandBlockEntity::new, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50255_).m_60978_(1.5f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (((Boolean)pState.m_61143_((Property)ACTIVE)).booleanValue()) {
            return Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)RevivalStandBlock.m_49796_((double)8.0, (double)0.0, (double)7.0, (double)10.0, (double)15.0, (double)9.0));
        }
        return SHAPE;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        RevivalStandBlockEntity te;
        if (!pState.m_60713_(pNewState.m_60734_()) && (te = WorldUtils.getTileEntity(RevivalStandBlockEntity.class, (BlockGetter)pLevel, pPos)) != null && (Integer)pState.m_61143_((Property)STAGE) != 4) {
            Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)new SimpleContainer(te.getFossilsUsed().toArray(new ItemStack[0])));
            Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)Blocks.f_50255_)}));
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)ACTIVE)).booleanValue() && pLevel.m_8055_(pPos.m_7494_()).m_60795_()) {
            int count = 25;
            for (int i = 0; i < count; ++i) {
                double dx = 0.04 * (pRandom.m_188500_() - 0.5);
                double dz = 0.04 * (pRandom.m_188500_() - 0.5);
                double dy = 8.0E-4 + pRandom.m_188500_() * 0.02;
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.01, (double)pPos.m_123343_() + 0.5, dx, dy, dz);
            }
            double dx = Mth.m_216263_((RandomSource)pRandom, (double)-0.02, (double)0.02);
            double dz = Mth.m_216263_((RandomSource)pRandom, (double)-0.02, (double)0.02);
            pLevel.m_7106_((ParticleOptions)ANParticles.REVIVAL_STAND_PARTICLE.get(), (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.0, (double)pPos.m_123343_() + 0.5, dx, 0.04, dz);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{STAGE, ACTIVE});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : RevivalStandBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ANBlockEntities.REVIVAL_STAND_ENTITY.get(), RevivalStandBlockEntity::serverTick);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if ((Integer)pState.m_61143_((Property)STAGE) == 4) {
            RevivalStandBlockEntity te;
            if (!pLevel.f_46443_ && (te = WorldUtils.getTileEntity(RevivalStandBlockEntity.class, (BlockGetter)pLevel, pPos)) != null) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)te, (BlockPos)pPos);
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (pPlayer.m_21120_(pHand).m_204117_(ANTags.Items.FOSSILS) && (Integer)pState.m_61143_((Property)STAGE) < 4) {
            if (!pLevel.f_46443_) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)STAGE, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)STAGE) + 1)), 3);
                RevivalStandBlockEntity te = WorldUtils.getTileEntity(RevivalStandBlockEntity.class, (BlockGetter)pLevel, pPos);
                if (te != null) {
                    ItemStack copy = pPlayer.m_21120_(pHand).m_41777_();
                    copy.m_41764_(1);
                    te.addUsedFossil(copy);
                }
                if (!pPlayer.m_7500_()) {
                    pPlayer.m_21120_(pHand).m_41774_(1);
                }
            }
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                if ((Integer)pState.m_61143_((Property)STAGE) == 3) {
                    ANAdvancementsRegistry.UNUSUAL_POTIONS.triggerForEntity((Entity)serverPlayer);
                }
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pPos, pPlayer.m_21120_(pHand));
            }
            pPlayer.m_146852_(GameEvent.f_157792_, (Entity)pPlayer);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }
}

