/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.reaper.ancientnature.common.base.AgeableFish;

public class RoeBlock
extends Block
implements SimpleWaterloggedBlock {
    protected final int minHatchTicks;
    protected final int maxHatchTicks;
    protected final int minEntities;
    protected final int maxEntities;
    protected final boolean floating;
    protected final Supplier<EntityType<?>> entitySupplier;

    public RoeBlock(BlockBehaviour.Properties pProperties, int minHatchTicks, int maxHatchTicks, int minEntities, int maxEntities, Supplier<EntityType<?>> entitySupplier, boolean floating) {
        super(pProperties);
        this.minHatchTicks = minHatchTicks;
        this.maxHatchTicks = maxHatchTicks;
        this.minEntities = minEntities;
        this.maxEntities = maxEntities;
        this.entitySupplier = entitySupplier;
        this.floating = floating;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction dir = (Direction)pState.m_61143_((Property)BlockStateProperties.f_61372_);
        if (this.floating) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
        }
        return switch (dir) {
            case Direction.DOWN -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
            case Direction.UP -> Block.m_49796_((double)0.0, (double)14.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.NORTH -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.5);
            case Direction.EAST -> Block.m_49796_((double)14.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)16.0, (double)16.0);
            default -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.5, (double)16.0, (double)16.0);
        };
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (this.floating) {
            return RoeBlock.mayPlaceOn((BlockGetter)pLevel, pPos.m_7495_());
        }
        FluidState fluidstate = pLevel.m_6425_(pPos);
        return fluidstate.m_76152_() == Fluids.f_76193_ && pLevel.m_8055_(pPos.m_121945_((Direction)pState.m_61143_((Property)BlockStateProperties.f_61372_))).m_60783_((BlockGetter)pLevel, pPos.m_121945_((Direction)pState.m_61143_((Property)BlockStateProperties.f_61372_)), ((Direction)pState.m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_());
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)pContext.m_43719_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.m_186460_(pPos, (Block)this, this.getEntitySpawnHatchDelay(pLevel.m_213780_()));
    }

    protected int getEntitySpawnHatchDelay(RandomSource pRandom) {
        return pRandom.m_216339_(this.minHatchTicks, this.maxHatchTicks);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.m_7898_(pState, (LevelReader)pLevel, pPos)) {
            this.destroyBlock((Level)pLevel, pPos);
        } else {
            this.hatchFrogspawn(pLevel, pPos, pRandom);
        }
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity.m_6095_().equals(EntityType.f_20450_)) {
            this.destroyBlock(pLevel, pPos);
        }
    }

    protected void hatchFrogspawn(ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.destroyBlock((Level)pLevel, pPos);
        pLevel.m_5594_((Player)null, pPos, SoundEvents.f_215687_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.spawnTadpoles(pLevel, pPos, pRandom);
    }

    protected void destroyBlock(Level pLevel, BlockPos pPos) {
        pLevel.m_46961_(pPos, false);
    }

    protected void spawnTadpoles(ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i = pRandom.m_216339_(this.minEntities, this.maxEntities);
        for (int j = 1; j <= i; ++j) {
            Entity tadpole = this.entitySupplier.get().m_20615_((Level)pLevel);
            if (tadpole == null) continue;
            double d0 = (double)pPos.m_123341_() + this.getRandomTadpolePositionOffset(pRandom);
            double d1 = (double)pPos.m_123343_() + this.getRandomTadpolePositionOffset(pRandom);
            int k = pRandom.m_216339_(1, 361);
            tadpole.m_7678_(d0, (double)pPos.m_123342_() + 0.5, d1, (float)k, 0.0f);
            if (tadpole instanceof Mob) {
                Mob living = (Mob)tadpole;
                living.m_21530_();
            }
            if (tadpole instanceof AgeableMob) {
                AgeableMob ageable = (AgeableMob)tadpole;
                ageable.m_146762_(-24000);
            } else if (tadpole instanceof AgeableFish) {
                AgeableFish ageFish = (AgeableFish)tadpole;
                ageFish.setAge(-24000);
            }
            pLevel.m_7967_(tadpole);
        }
    }

    protected double getRandomTadpolePositionOffset(RandomSource pRandom) {
        double d0 = Tadpole.f_218681_ / 2.0f;
        return Mth.m_14008_((double)pRandom.m_188500_(), (double)d0, (double)(1.0 - d0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{BlockStateProperties.f_61372_, BlockStateProperties.f_61362_});
    }

    private static boolean mayPlaceOn(BlockGetter pLevel, BlockPos pPos) {
        FluidState fluidstate = pLevel.m_6425_(pPos);
        FluidState fluidstate1 = pLevel.m_6425_(pPos.m_7494_());
        return fluidstate.m_76152_() == Fluids.f_76193_ && fluidstate1.m_76152_() == Fluids.f_76191_;
    }
}

