/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.block;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.reaper.ancientnature.common.block.BlockEntityBlock;
import net.reaper.ancientnature.common.block.TriceratopsSkullDummyBlock;
import net.reaper.ancientnature.common.block.blockentity.TriceratopsSkullBlockEntity;
import net.reaper.ancientnature.common.block.blockentity.TriceratopsSkullDummyBlockEntity;
import net.reaper.ancientnature.common.util.misc.TriceratopsSkullShapes;
import net.reaper.ancientnature.core.registry.ANBlocks;
import net.reaper.ancientnature.core.util.ANDamageSources;

public class TriceratopsSkullBlock
extends BlockEntityBlock {
    public static EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty FLOOR = BooleanProperty.m_61465_((String)"floor");
    public static final BooleanProperty WALL = BooleanProperty.m_61465_((String)"wall");

    public TriceratopsSkullBlock(BlockBehaviour.Properties pProperties) {
        super(TriceratopsSkullBlockEntity::new, pProperties.m_60978_(1.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, OPEN, FLOOR, WALL});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)OPEN), 3);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        pEntity.m_142535_(pFallDistance + 2.0f, 2.0f, ANDamageSources.triceratopsSkullDamageSource(pLevel));
        super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pLevel.f_46443_ && pState.m_60734_() != pNewState.m_60734_()) {
            if (((Boolean)pState.m_61143_((Property)WALL)).booleanValue()) {
                TriceratopsSkullBlock.DestroyDummyBlocksWall(pLevel, pPos, pState);
            } else {
                TriceratopsSkullBlock.DestroyDummyBlocksFloor(pLevel, pPos, pState);
            }
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_(FACING);
        boolean isOpen = (Boolean)pState.m_61143_((Property)OPEN);
        VoxelShape baseShape = isOpen && (Boolean)pState.m_61143_((Property)FLOOR) != false ? TriceratopsSkullShapes.FLOOR_OPEN_SHAPES.get(facing) : ((Boolean)pState.m_61143_((Property)WALL) != false ? TriceratopsSkullShapes.WALL_SHAPES.get(facing) : TriceratopsSkullShapes.FLOOR_SHAPES.get(facing));
        if (baseShape == null) {
            return Shapes.m_83144_();
        }
        VoxelShape blockBounds = Shapes.m_83144_();
        return Shapes.m_83148_((VoxelShape)baseShape, (VoxelShape)blockBounds, (BooleanOp)BooleanOp.f_82689_);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)pContext.m_8125_().m_122424_());
        state = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
        state = pContext.m_43719_() == Direction.UP ? (BlockState)((BlockState)state.m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(false)) : (BlockState)((BlockState)state.m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(true));
        boolean canPlace = (Boolean)state.m_61143_((Property)WALL) != false ? TriceratopsSkullBlock.canPlaceDummyBlocksWall(pContext.m_43725_(), pContext.m_8083_(), state) : TriceratopsSkullBlock.canPlaceDummyBlocksFloor(pContext.m_43725_(), pContext.m_8083_(), state);
        if (!canPlace) {
            return null;
        }
        return state;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        if (!pLevel.f_46443_ && pState.m_60734_() != pOldState.m_60734_()) {
            this.calculateStateAndPlaceDummies(pLevel, pPos, pState);
        }
    }

    private void calculateStateAndPlaceDummies(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockState newState = pState;
        boolean hasBlockBelow = !pLevel.m_46859_(pPos.m_7495_());
        newState = (BlockState)newState.m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(hasBlockBelow));
        BlockPos wallPos = pPos.m_121945_(((Direction)pState.m_61143_(FACING)).m_122424_());
        boolean hasBlockBehind = !pLevel.m_46859_(wallPos) && !pLevel.m_8055_(wallPos).m_60713_((Block)ANBlocks.TRICERATOPS_SKULL_DUMMY.get());
        boolean canPlace = (Boolean)(newState = (BlockState)newState.m_61124_((Property)WALL, (Comparable)Boolean.valueOf(hasBlockBehind))).m_61143_((Property)WALL) != false ? TriceratopsSkullBlock.canPlaceDummyBlocksWall(pLevel, pPos, newState) : TriceratopsSkullBlock.canPlaceDummyBlocksFloor(pLevel, pPos, newState);
        if (!canPlace) {
            pLevel.m_7471_(pPos, false);
            return;
        }
        if (newState != pState) {
            pLevel.m_7731_(pPos, newState, 3);
        }
        if (((Boolean)newState.m_61143_((Property)WALL)).booleanValue()) {
            TriceratopsSkullBlock.PlaceDummyBlocksWall(pLevel, pPos, newState);
        } else {
            TriceratopsSkullBlock.PlaceDummyBlocksFloor(pLevel, pPos, newState);
        }
    }

    private static boolean canPlaceDummyBlocksFloor(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction facing = (Direction)pState.m_61143_(FACING);
        BlockPos dummyPos1 = pPos.m_121945_(facing);
        BlockPos dummyPos2 = pPos.m_121945_(facing.m_122424_());
        BlockPos dummyPos3 = dummyPos2.m_121945_(facing.m_122427_());
        BlockPos dummyPos4 = dummyPos2.m_121945_(facing.m_122428_());
        BlockPos dummyPos5 = pPos.m_7494_();
        BlockPos dummyPos6 = dummyPos2.m_7494_();
        BlockPos dummyPos7 = dummyPos3.m_7494_();
        BlockPos dummyPos8 = dummyPos4.m_7494_();
        ArrayList<BlockPos> dummyPositions = new ArrayList<BlockPos>();
        dummyPositions.add(dummyPos1);
        dummyPositions.add(dummyPos2);
        dummyPositions.add(dummyPos3);
        dummyPositions.add(dummyPos4);
        dummyPositions.add(dummyPos5);
        dummyPositions.add(dummyPos6);
        dummyPositions.add(dummyPos7);
        dummyPositions.add(dummyPos8);
        for (BlockPos dummyPos : dummyPositions) {
            BlockState blockState = pLevel.m_8055_(dummyPos);
            if (blockState.m_60795_() || blockState.m_247087_()) continue;
            return false;
        }
        return true;
    }

    private static boolean canPlaceDummyBlocksWall(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction facing = (Direction)pState.m_61143_(FACING);
        BlockPos dummyPos1 = pPos.m_121945_(facing);
        BlockPos dummyPos2 = pPos.m_7494_();
        BlockPos dummyPos3 = pPos.m_7495_();
        BlockPos dummyPos4 = dummyPos3.m_121945_(facing);
        ArrayList<BlockPos> dummyPositions = new ArrayList<BlockPos>();
        dummyPositions.add(dummyPos1);
        dummyPositions.add(dummyPos2);
        dummyPositions.add(dummyPos3);
        dummyPositions.add(dummyPos4);
        for (BlockPos dummyPos : dummyPositions) {
            BlockState blockState = pLevel.m_8055_(dummyPos);
            if (blockState.m_60795_() || blockState.m_247087_()) continue;
            return false;
        }
        return true;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        BlockState newState = pState;
        if (pLevel.m_46859_(pPos.m_7495_()) || pLevel.m_8055_(pPos.m_7495_()).m_60713_((Block)ANBlocks.TRICERATOPS_SKULL_DUMMY.get())) {
            newState = (BlockState)newState.m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(false));
        } else if (!pLevel.m_46859_(pPos.m_7495_()) && !((Boolean)newState.m_61143_((Property)FLOOR)).booleanValue()) {
            newState = (BlockState)newState.m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(true));
        }
        BlockPos wallPos = pPos.m_121945_(((Direction)pState.m_61143_(FACING)).m_122424_());
        if (pLevel.m_46859_(wallPos) && !pLevel.m_8055_(wallPos).m_60713_((Block)ANBlocks.TRICERATOPS_SKULL_DUMMY.get())) {
            newState = (BlockState)newState.m_61124_((Property)WALL, (Comparable)Boolean.valueOf(false));
        } else if (!(pLevel.m_46859_(pPos.m_121945_(((Direction)pState.m_61143_(FACING)).m_122424_())) || ((Boolean)newState.m_61143_((Property)WALL)).booleanValue() || pLevel.m_8055_(wallPos).m_60713_((Block)ANBlocks.TRICERATOPS_SKULL_DUMMY.get()))) {
            newState = (BlockState)newState.m_61124_((Property)WALL, (Comparable)Boolean.valueOf(true));
        }
        if (newState != pState) {
            pLevel.m_7731_(pPos, newState, 3);
        }
    }

    private static void PlaceDummyBlocksFloor(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction facing = (Direction)pState.m_61143_(FACING);
        BlockPos dummyPos1 = pPos.m_121945_(facing);
        BlockPos dummyPos2 = pPos.m_121945_(facing.m_122424_());
        BlockPos dummyPos3 = dummyPos2.m_121945_(facing.m_122427_());
        BlockPos dummyPos4 = dummyPos2.m_121945_(facing.m_122428_());
        BlockPos dummyPos5 = pPos.m_7494_();
        BlockPos dummyPos6 = dummyPos2.m_7494_();
        BlockPos dummyPos7 = dummyPos3.m_7494_();
        BlockPos dummyPos8 = dummyPos4.m_7494_();
        ArrayList<BlockPos> dummyPositions = new ArrayList<BlockPos>();
        dummyPositions.add(dummyPos1);
        dummyPositions.add(dummyPos2);
        dummyPositions.add(dummyPos3);
        dummyPositions.add(dummyPos4);
        dummyPositions.add(dummyPos5);
        dummyPositions.add(dummyPos6);
        dummyPositions.add(dummyPos7);
        dummyPositions.add(dummyPos8);
        for (BlockPos dummyPos : dummyPositions) {
            pLevel.m_7731_(dummyPos, ((Block)ANBlocks.TRICERATOPS_SKULL_DUMMY.get()).m_49966_(), 3);
            BlockEntity blockEntity = pLevel.m_7702_(dummyPos);
            if (!(blockEntity instanceof TriceratopsSkullDummyBlockEntity)) continue;
            ((TriceratopsSkullDummyBlockEntity)blockEntity).setControllerPos(pPos);
        }
    }

    private static void DestroyDummyBlocksFloor(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction facing = (Direction)pState.m_61143_(FACING);
        BlockPos dummyPos1 = pPos.m_121945_(facing);
        BlockPos dummyPos2 = pPos.m_121945_(facing.m_122424_());
        BlockPos dummyPos3 = dummyPos2.m_121945_(facing.m_122427_());
        BlockPos dummyPos4 = dummyPos2.m_121945_(facing.m_122428_());
        BlockPos dummyPos5 = pPos.m_7494_();
        BlockPos dummyPos6 = dummyPos2.m_7494_();
        BlockPos dummyPos7 = dummyPos3.m_7494_();
        BlockPos dummyPos8 = dummyPos4.m_7494_();
        ArrayList<BlockPos> dummyPositions = new ArrayList<BlockPos>();
        dummyPositions.add(dummyPos1);
        dummyPositions.add(dummyPos2);
        dummyPositions.add(dummyPos3);
        dummyPositions.add(dummyPos4);
        dummyPositions.add(dummyPos5);
        dummyPositions.add(dummyPos6);
        dummyPositions.add(dummyPos7);
        dummyPositions.add(dummyPos8);
        for (BlockPos dummyPos : dummyPositions) {
            BlockState blockState = pLevel.m_8055_(dummyPos);
            if (!(blockState.m_60734_() instanceof TriceratopsSkullDummyBlock)) continue;
            pLevel.m_46961_(dummyPos, false);
        }
    }

    private static void PlaceDummyBlocksWall(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction facing = (Direction)pState.m_61143_(FACING);
        BlockPos dummyPos1 = pPos.m_121945_(facing);
        BlockPos dummyPos2 = pPos.m_7494_();
        BlockPos dummyPos3 = pPos.m_7495_();
        BlockPos dummyPos4 = dummyPos3.m_121945_(facing);
        BlockPos dummyPos5 = pPos.m_121945_(facing.m_122427_());
        BlockPos dummyPos6 = pPos.m_121945_(facing.m_122428_());
        BlockPos dummyPos7 = dummyPos5.m_7494_();
        BlockPos dummyPos8 = dummyPos6.m_7494_();
        BlockPos dummyPos9 = dummyPos7.m_7494_();
        BlockPos dummyPos10 = dummyPos8.m_7494_();
        BlockPos dummyPos11 = dummyPos2.m_7494_();
        ArrayList<BlockPos> dummyPositions = new ArrayList<BlockPos>();
        dummyPositions.add(dummyPos1);
        dummyPositions.add(dummyPos2);
        dummyPositions.add(dummyPos3);
        dummyPositions.add(dummyPos4);
        dummyPositions.add(dummyPos5);
        dummyPositions.add(dummyPos6);
        dummyPositions.add(dummyPos7);
        dummyPositions.add(dummyPos8);
        dummyPositions.add(dummyPos9);
        dummyPositions.add(dummyPos10);
        dummyPositions.add(dummyPos11);
        for (BlockPos dummyPos : dummyPositions) {
            pLevel.m_7731_(dummyPos, ((Block)ANBlocks.TRICERATOPS_SKULL_DUMMY.get()).m_49966_(), 3);
            BlockEntity blockEntity = pLevel.m_7702_(dummyPos);
            if (!(blockEntity instanceof TriceratopsSkullDummyBlockEntity)) continue;
            ((TriceratopsSkullDummyBlockEntity)blockEntity).setControllerPos(pPos);
        }
    }

    private static void DestroyDummyBlocksWall(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction facing = (Direction)pState.m_61143_(FACING);
        BlockPos dummyPos1 = pPos.m_121945_(facing);
        BlockPos dummyPos2 = pPos.m_7494_();
        BlockPos dummyPos3 = pPos.m_7495_();
        BlockPos dummyPos4 = dummyPos3.m_121945_(facing);
        BlockPos dummyPos5 = pPos.m_121945_(facing.m_122427_());
        BlockPos dummyPos6 = pPos.m_121945_(facing.m_122428_());
        BlockPos dummyPos7 = dummyPos5.m_7494_();
        BlockPos dummyPos8 = dummyPos6.m_7494_();
        BlockPos dummyPos9 = dummyPos7.m_7494_();
        BlockPos dummyPos10 = dummyPos8.m_7494_();
        BlockPos dummyPos11 = dummyPos2.m_7494_();
        ArrayList<BlockPos> dummyPositions = new ArrayList<BlockPos>();
        dummyPositions.add(dummyPos1);
        dummyPositions.add(dummyPos2);
        dummyPositions.add(dummyPos3);
        dummyPositions.add(dummyPos4);
        dummyPositions.add(dummyPos5);
        dummyPositions.add(dummyPos6);
        dummyPositions.add(dummyPos7);
        dummyPositions.add(dummyPos8);
        dummyPositions.add(dummyPos9);
        dummyPositions.add(dummyPos10);
        dummyPositions.add(dummyPos11);
        for (BlockPos dummyPos : dummyPositions) {
            BlockState blockState = pLevel.m_8055_(dummyPos);
            if (!(blockState.m_60734_() instanceof TriceratopsSkullDummyBlock)) continue;
            pLevel.m_46961_(dummyPos, false);
        }
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }
}

