/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.block.blockentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.extensions.IForgeBlockEntity;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.reaper.ancientnature.common.block.RevivalStandBlock;
import net.reaper.ancientnature.common.menu.RevivalStandMenu;
import net.reaper.ancientnature.common.menu.UtilMenu;
import net.reaper.ancientnature.common.recipe.RevivalStandRecipe;
import net.reaper.ancientnature.common.util.BurnTimeUtils;
import net.reaper.ancientnature.core.config.AncientNatureConfig;
import net.reaper.ancientnature.core.registry.ANBlockEntities;
import net.reaper.ancientnature.core.registry.ANRecipes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevivalStandBlockEntity
extends BlockEntity
implements Container,
MenuProvider {
    protected List<ItemStack> fossilsUsed = new ArrayList<ItemStack>();
    protected final ItemStackHandler inv = this.createInventory();
    protected int fuel;
    protected int itemFuel;
    protected int amberProgress;
    protected int maxAmberProgress = 1;
    protected int fossilProgress;
    protected int maxFossilProgress = 1;
    public ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> RevivalStandBlockEntity.this.fuel;
                case 1 -> RevivalStandBlockEntity.this.amberProgress;
                case 2 -> RevivalStandBlockEntity.this.maxAmberProgress;
                case 3 -> RevivalStandBlockEntity.this.fossilProgress;
                case 4 -> RevivalStandBlockEntity.this.maxFossilProgress;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    RevivalStandBlockEntity.this.fuel = pValue;
                    break;
                }
                case 1: {
                    RevivalStandBlockEntity.this.amberProgress = pValue;
                    break;
                }
                case 2: {
                    RevivalStandBlockEntity.this.maxAmberProgress = pValue;
                    break;
                }
                case 3: {
                    RevivalStandBlockEntity.this.fossilProgress = pValue;
                    break;
                }
                case 4: {
                    RevivalStandBlockEntity.this.maxFossilProgress = pValue;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };

    public RevivalStandBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ANBlockEntities.REVIVAL_STAND_ENTITY.get(), pPos, pBlockState);
    }

    protected ItemStackHandler createInventory() {
        return new ItemStackHandler(6){

            protected int getStackLimit(int slot, @NotNull ItemStack stack) {
                if (slot > 2) {
                    return 1;
                }
                return super.getStackLimit(slot, stack);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return BurnTimeUtils.getBurnTime(stack, (RecipeType)ANRecipes.REVIVAL_STAND_RECIPE.get()) > 0;
                }
                return super.isItemValid(slot, stack);
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                RevivalStandBlockEntity.this.m_6596_();
                RevivalStandBlockEntity.this.blockUpdate();
            }
        };
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RevivalStandBlockEntity te) {
        te.fuelTick();
        Optional<RevivalStandRecipe> potentialRecipe = te.getMatchingRecipe();
        if (potentialRecipe.isPresent() && te.isHeated()) {
            RevivalStandRecipe recipe = potentialRecipe.get();
            if (te.amberProgress == 0) {
                te.startProcessing(recipe);
                te.process(recipe);
            } else if (te.fossilProgress < te.maxFossilProgress) {
                te.process(recipe);
            } else {
                te.finishProcessing(recipe);
                te.reset();
            }
        } else {
            te.reset();
        }
    }

    protected void fuelTick() {
        this.fuel = Math.max(0, this.fuel - 1);
        int maxFuelAddition = Math.min(this.getMaxHeatingPerTick(), this.getMaxFuel() - this.fuel);
        if (this.itemFuel < maxFuelAddition && !this.m_8020_(0).m_41619_()) {
            this.itemFuel += BurnTimeUtils.getBurnTime(this.m_8020_(0), (RecipeType)ANRecipes.REVIVAL_STAND_RECIPE.get());
            this.m_8020_(0).m_41774_(1);
        }
        maxFuelAddition = Math.min(maxFuelAddition, this.itemFuel);
        this.itemFuel -= maxFuelAddition;
        this.fuel += maxFuelAddition;
        if (this.isHeated() != ((Boolean)this.m_58900_().m_61143_((Property)RevivalStandBlock.ACTIVE)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)RevivalStandBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isHeated())), 3);
        }
    }

    public void blockUpdate() {
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    protected void startProcessing(RevivalStandRecipe recipe) {
        this.maxFossilProgress = recipe.getFossilInfusionTime();
        this.maxAmberProgress = recipe.getAmberInfusionTime();
    }

    protected void process(RevivalStandRecipe recipe) {
        if (this.amberProgress < this.maxAmberProgress) {
            ++this.amberProgress;
        } else {
            ++this.fossilProgress;
        }
        this.fuel -= 3;
    }

    protected void finishProcessing(RevivalStandRecipe recipe) {
        ItemStack eggs = recipe.assemble(this, this.f_58857_.m_9598_());
        for (int i = 0; i < eggs.m_41613_(); ++i) {
            if (this.m_8020_(3 + i).m_41619_()) continue;
            ItemStack eggCopy = eggs.m_41777_();
            eggCopy.m_41764_(1);
            this.m_6836_(3 + i, eggCopy);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, IForgeBlockEntity::serializeNBT);
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    protected void reset() {
        this.amberProgress = 0;
        this.fossilProgress = 0;
    }

    public Optional<RevivalStandRecipe> getMatchingRecipe() {
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ANRecipes.REVIVAL_STAND_RECIPE.get(), (Container)this, this.f_58857_);
    }

    protected boolean isHeated() {
        return this.fuel == this.getMaxFuel();
    }

    public int getMaxFuel() {
        return (Integer)AncientNatureConfig.MAXFUEL.get();
    }

    public int getMaxHeatingPerTick() {
        return (Integer)AncientNatureConfig.MAXHEATING.get();
    }

    public void shrinkAndAddOneFossil(ItemStack fossil) {
        ItemStack copy = fossil.m_41777_();
        copy.m_41764_(1);
        fossil.m_41774_(1);
        this.addUsedFossil(copy);
    }

    public void addUsedFossil(ItemStack fossil) {
        for (ItemStack existingFossil : this.fossilsUsed) {
            if (existingFossil.m_41720_() != fossil.m_41720_()) continue;
            existingFossil.m_41769_(fossil.m_41613_());
            return;
        }
        this.fossilsUsed.add(fossil);
    }

    public List<ItemStack> getFossilsUsed() {
        return this.fossilsUsed;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.inv.serializeNBT());
        pTag.m_128405_("fuel", this.fuel);
        pTag.m_128405_("itemFuel", this.itemFuel);
        pTag.m_128405_("amberProgress", this.amberProgress);
        pTag.m_128405_("maxAmberProgress", this.maxAmberProgress);
        pTag.m_128405_("fossilProgress", this.fossilProgress);
        pTag.m_128405_("maxFossilProgress", this.maxAmberProgress);
        for (int i = 0; i < this.fossilsUsed.size(); ++i) {
            pTag.m_128365_("usedFossil" + i, (Tag)this.fossilsUsed.get(i).serializeNBT());
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inv.deserializeNBT(pTag.m_128469_("inventory"));
        this.fuel = pTag.m_128451_("fuel");
        this.itemFuel = pTag.m_128451_("itemFuel");
        this.amberProgress = pTag.m_128451_("amberProgress");
        this.maxAmberProgress = pTag.m_128451_("maxAmberProgress");
        this.fossilProgress = pTag.m_128451_("fossilProgress");
        this.maxFossilProgress = pTag.m_128451_("maxFossilProgress");
        int i = 0;
        while (pTag.m_128441_("usedFossil" + i)) {
            this.fossilsUsed.add(ItemStack.m_41712_((CompoundTag)pTag.m_128469_("usedFossil" + i)));
            ++i;
        }
    }

    public int m_6643_() {
        return this.inv.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return this.inv.getStackInSlot(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return this.inv.extractItem(pSlot, pAmount, false);
    }

    public ItemStack m_8016_(int pSlot) {
        return this.inv.extractItem(pSlot, Integer.MAX_VALUE, false);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.inv.setStackInSlot(pSlot, pStack);
    }

    public boolean m_6542_(Player pPlayer) {
        return true;
    }

    public void m_6211_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.inv.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)UtilMenu.makeTranslationKey(ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()).m_135815_()));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new RevivalStandMenu(pContainerId, pPlayerInventory, this);
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getAmberProgress() {
        return this.amberProgress;
    }

    public int getMaxAmberProgress() {
        return this.maxAmberProgress;
    }

    public int getFossilProgress() {
        return this.fossilProgress;
    }

    public int getMaxFossilProgress() {
        return this.maxFossilProgress;
    }
}

