/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.reaper.ancientnature.common.entity.ANBoatEntity;
import net.reaper.ancientnature.core.registry.ANBlocks;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANItems;

public class ANChestBoatEntity
extends ChestBoat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.m_135353_(ANChestBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ANChestBoatEntity(EntityType<? extends ANChestBoatEntity> type, Level level) {
        super(type, level);
    }

    public ANChestBoatEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends ANChestBoatEntity>)((EntityType)ANEntities.CHEST_BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public ANBoatEntity.Type getANBoatType() {
        return ANBoatEntity.Type.byId((Integer)this.m_20088_().m_135370_(BOAT_TYPE));
    }

    public Item m_38369_() {
        return switch (this.getANBoatType()) {
            default -> throw new IncompatibleClassChangeError();
            case ANBoatEntity.Type.GINKGO -> (Item)ANItems.GINKGO_CHEST_BOAT.get();
            case ANBoatEntity.Type.LEPIDODENDRON -> (Item)ANItems.LEPIDODENDRON_CHEST_BOAT.get();
        };
    }

    public void setANBoatType(ANBoatEntity.Type boatType) {
        this.m_20088_().m_135381_(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(BOAT_TYPE, (Object)ANBoatEntity.Type.GINKGO.ordinal());
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("Type", this.getANBoatType().getName());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("Type", 8)) {
            this.setANBoatType(ANBoatEntity.Type.getTypeFromString(tag.m_128461_("Type")));
        }
    }

    public static enum Type {
        GINKGO((Block)ANBlocks.GINKGO_PLANKS.get(), "ginkgo"),
        LEPIDODENDRON((Block)ANBlocks.LEPIDODENDRON_PLANKS.get(), "lepidodendron");

        private final String name;
        private final Block block;

        private Type(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] types = Type.values();
            if (id < 0 || id >= types.length) {
                id = 0;
            }
            return types[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return types[0];
        }
    }
}

