/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.client.entity.animation.adult.AnomalocarisAdultAnimation;
import net.reaper.ancientnature.client.entity.animation.baby.AnomalocarisBabyAnimation;
import net.reaper.ancientnature.common.base.BaseWaterAnimal;
import net.reaper.ancientnature.common.entity.WormEntity;
import net.reaper.ancientnature.common.entity.ai.goal.base.movement.SwimNearSeaFloorGoal;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.entity.ai.pathing.water.ObstacleNodeEvaluator;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.goals.ConsumeItemFromGroundGoal;
import net.reaper.ancientnature.common.goals.EggBreedGoal;
import net.reaper.ancientnature.common.goals.SmallerEntityTargetGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.common.goals.water.WaterLayEggGoal;
import net.reaper.ancientnature.common.goals.water.WaterSmartAnimalTemptGoal;
import net.reaper.ancientnature.common.goals.water.anomalocaris.DigestGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANBlocks;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.core.registry.ANSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnomalocarisEntity
extends BaseWaterAnimal<AnomalocarisEntity>
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(AnomalocarisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIGESTING_ID = SynchedEntityData.m_135353_(AnomalocarisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_HOLDING_FOOD = SynchedEntityData.m_135353_(AnomalocarisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(AnomalocarisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final int TICKS_TO_DIGEST = 200;
    public float currentRoll = 0.0f;
    public float tailRot;
    public float prevTailRot;
    public int ticksEnsnaring;
    public int ticksDigesting = -1;
    private float damageDealt = 0.0f;
    public final AnimData flopData = new AnimData(this.m_6162_() ? AnomalocarisBabyAnimation.FLOP : AnomalocarisAdultAnimation.FLOP);
    public BaseAnimation flopAnim = new SimpleAnimation("flop", this.flopData, Loop.CYCLE, 2, 0.4977f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return !AnomalocarisEntity.this.m_20072_();
        }
    });
    public final AnimData eatData = new AnimData(AnomalocarisAdultAnimation.EAT);
    public BaseAnimation eatAnim = new SimpleAnimation("eat", this.eatData, Loop.ONCE, 0, 2.0f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            if (AnomalocarisEntity.this.f_19797_ % 10 == 0) {
                AnomalocarisEntity.this.playMunchSound();
                Vec3 vec3 = new Vec3(0.0, 0.35, (double)0.7f).m_82524_(-AnomalocarisEntity.this.f_20883_ * ((float)Math.PI / 180));
                for (int i = 0; i < 5; ++i) {
                    AnomalocarisEntity.this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42579_)), AnomalocarisEntity.this.m_20185_() + vec3.f_82479_ * (double)1.3f + (double)AnomalocarisEntity.this.f_19796_.m_188501_() - 0.5, AnomalocarisEntity.this.m_20186_() - 0.5 + (double)AnomalocarisEntity.this.f_19796_.m_188501_() - 0.5, AnomalocarisEntity.this.m_20189_() + vec3.f_82481_ * (double)1.3f + (double)AnomalocarisEntity.this.f_19796_.m_188501_() - 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    });
    public final AnimData attackData = new AnimData(this.m_6162_() ? AnomalocarisBabyAnimation.ATTACK : AnomalocarisAdultAnimation.ATTACK);
    public BaseAnimation attackAnim = new SimpleAnimation("attack", this.attackData, Loop.ONCE, 0, this.m_6162_() ? 4025.0f : 0.514f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            LivingEntity target;
            if (tick == 3 && !AnomalocarisEntity.this.m_9236_().f_46443_ && (target = AnomalocarisEntity.this.m_5448_()) != null && AnomalocarisEntity.this.m_20270_((Entity)target) <= 3.0f) {
                AnomalocarisEntity.this.m_7327_((Entity)target);
            }
        }
    });

    public AnomalocarisEntity(EntityType<? extends BaseWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 1.0f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 75);
        this.f_21344_ = new WaterBoundPathNavigation((Mob)this, pLevel){

            @NotNull
            protected PathFinder m_5532_(int max) {
                this.f_26508_ = new ObstacleNodeEvaluator(7, true);
                return new PathFinder(this.f_26508_, max);
            }
        };
    }

    @Override
    public void initAnimations() {
        this.getAnimator().register(this.attackAnim, this.eatAnim, this.flopAnim);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.6f, (float)0.2f);
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.ANOMALOCARIS_DIET_ITEMS);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new SwimNearSeaFloorGoal((PathfinderMob)this, 1.0, 2, 4));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, Entity::m_20069_, 300));
        this.f_21345_.m_25352_(2, (Goal)new EggBreedGoal(this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new WaterLayEggGoal(this, 1.0, 10, 16, (Block)ANBlocks.ANOMALOCARIS_EGGS.get(), pPos -> !this.m_9236_().m_46861_(pPos)));
        this.f_21345_.m_25352_(3, (Goal)new ConsumeItemFromGroundGoal(this, 1.2, true, this.getEatAnimationConsumeDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.EAT)));
        this.f_21345_.m_25352_(4, (Goal)new WaterSmartAnimalTemptGoal(this, 1.2, false));
        this.f_21345_.m_25352_(2, (Goal)new MeleeGoal(this, 1.0, true));
        if (!this.m_6162_()) {
            this.f_21345_.m_25352_(5, (Goal)new DashToEnsnareGoal(this));
            this.f_21345_.m_25352_(6, (Goal)new DigestGoal(this));
        }
        this.f_21346_.m_25352_(2, new SmallerEntityTargetGoal<WaterAnimal>((Mob)this, WaterAnimal.class, false, p -> p.m_20069_() && !(p instanceof Dolphin) && !this.m_6162_()));
        this.f_21346_.m_25352_(2, new SmallerEntityTargetGoal<BaseWaterAnimal>((Mob)this, BaseWaterAnimal.class, false, p -> p.m_20069_() && !(p instanceof AnomalocarisEntity) && !this.m_6162_()));
        this.f_21346_.m_25352_(2, new SmallerEntityTargetGoal<WormEntity>((Mob)this, WormEntity.class, false, p -> p.m_20069_() && !(p instanceof AnomalocarisEntity) && !this.m_6162_()));
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    @Override
    public boolean m_5957_() {
        return super.m_5957_() && !this.isHungry() && !this.isHoldingFood() && !this.m_6162_();
    }

    protected float m_6431_(@Nonnull Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.9f;
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
        if (this.isHoldingFood() && this.m_20072_()) {
            this.m_20334_(0.0, -0.001, 0.0);
        }
        if (this.m_20096_()) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.m_9236_().m_46471_()) {
            this.m_20301_(1000);
        }
        if (this.m_6162_() || !this.isHungry()) {
            this.setDigesting(false);
            this.setHoldingFood(false);
        }
        if (this.m_5448_() != null && !this.isHoldingFood() && this.isHungry()) {
            this.m_21563_().m_24946_(this.m_5448_().m_20185_(), this.m_5448_().m_20188_(), this.m_5448_().m_20189_());
        }
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.1f), 0.2, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.1f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
        }
        if (this.m_6084_() && !this.m_21525_()) {
            if (this.m_9236_().m_5776_()) {
                this.setupAnimationStates();
            } else if (!this.isHoldingFood()) {
                this.ticksEnsnaring = -1;
                this.ticksDigesting = -1;
                this.setDigesting(false);
            }
            this.prevTailRot = this.tailRot;
            this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
        }
        super.m_8119_();
    }

    @Override
    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    @Override
    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    @Override
    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.1f), (double)0.2f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.1f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    @Override
    protected void m_267689_(float pPartialTick) {
        if (this.m_20069_()) {
            super.m_267689_(pPartialTick);
        }
        if (this.isHoldingFood()) {
            super.m_267689_(pPartialTick);
        }
    }

    protected void m_19956_(@Nonnull Entity pPassenger, @Nonnull Entity.MoveFunction pCallback) {
        int i;
        if (!this.m_6162_() && (i = this.m_20197_().indexOf(pPassenger)) >= 0) {
            boolean flag = i == 0;
            float f = 0.5f;
            if (this.m_20197_().size() > 1 && !(pPassenger instanceof Player)) {
                if (!flag) {
                    f = -0.7f;
                }
                if (pPassenger instanceof Animal) {
                    f += 0.2f;
                }
            }
            Vec3 vec3 = new Vec3(0.0, 0.0, (double)f).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            pCallback.m_20372_(pPassenger, this.m_20185_() + vec3.f_82479_ * 1.0, this.m_20186_() - (double)0.3f, this.m_20189_() + vec3.f_82481_ * (double)1.3f);
        }
    }

    public boolean isDigesting() {
        return (Boolean)this.m_20088_().m_135370_(DIGESTING_ID);
    }

    public void setDigesting(boolean isDigesting) {
        this.f_19804_.m_135381_(DIGESTING_ID, (Object)isDigesting);
    }

    @Override
    public boolean isAttacking() {
        return (Boolean)this.m_20088_().m_135370_(IS_ATTACKING);
    }

    @Override
    public void setAttacking(boolean isAttacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)isAttacking);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DIGESTING_ID, (Object)false);
        this.m_20088_().m_135372_(IS_ATTACKING, (Object)false);
        this.m_20088_().m_135372_(IS_HOLDING_FOOD, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
        pCompound.m_128379_("isHoldingFood", this.isHoldingFood());
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
        this.setHoldingFood(pCompound.m_128471_("isHoldingFood"));
    }

    public void startDigesting(int digestionTime) {
        if (this.m_6162_()) {
            this.setDigesting(false);
        } else {
            this.ticksDigesting = digestionTime;
        }
        this.setDigesting(true);
    }

    public float getDamageDealt() {
        return this.damageDealt;
    }

    public void setDamageDealt(float damageDealt) {
        this.damageDealt = damageDealt;
    }

    public void digest() {
        if (this.m_146895_() != null) {
            this.m_146895_().m_146870_();
        }
        if (!this.m_20067_()) {
            this.playMunchSound();
        }
        this.m_7822_((byte)7);
        this.setHoldingFood(false);
        this.setAttacking(false);
        this.m_6710_(null);
        this.ticksDigesting = 0;
        this.ticksEnsnaring = 0;
        this.setDamageDealt(0.0f);
    }

    public boolean isHoldingFood() {
        return (Boolean)this.m_20088_().m_135370_(IS_HOLDING_FOOD);
    }

    public void setHoldingFood(boolean holdingFood) {
        this.m_20088_().m_135381_(IS_HOLDING_FOOD, (Object)holdingFood);
    }

    @Override
    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player pPlayer, @Nonnull InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    public void m_6872_(@Nonnull ItemStack pStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)pStack);
        CompoundTag compoundtag = pStack.m_41784_();
        compoundtag.m_128405_("Age", this.m_146764_());
    }

    public void m_142278_(@Nonnull CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        if (pTag.m_128441_("Age")) {
            this.m_146762_(pTag.m_128451_("Age"));
        }
        if (pTag.m_128441_("ticksUntilHungry")) {
            this.setTicksUntilHungry(pTag.m_128451_("ticksUntilHungry"));
        }
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ANItems.ANOMALOCARIS_BUCKET.get());
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public AnomalocarisEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AnomalocarisEntity)((EntityType)ANEntities.ANOMALOCARIS.get()).m_20615_((Level)pLevel);
    }

    @Override
    public int getAnimationLengthInTicks(BaseAnimalPose smartPose) {
        return 0;
    }

    @Override
    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(ItemTags.f_13156_);
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource pDamageSource) {
        return (SoundEvent)ANSounds.ANOMALOCARIS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ANSounds.ANOMALOCARIS_DEATH.get();
    }

    public void playMunchSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.ANOMALOCARIS_EAT.get(), SoundSource.NEUTRAL, this.m_6121_(), 1.0f);
    }

    protected float m_6121_() {
        return 0.5f;
    }

    @Override
    @Nonnull
    protected SoundEvent getFlopSound() {
        return (SoundEvent)ANSounds.ANOMALOCARIS_DEATH.get();
    }

    static class MeleeGoal
    extends MeleeAttackGoal {
        private final AnomalocarisEntity mob;
        LivingEntity target;
        boolean pFollowingTargetEvenIfNotSeen;

        public MeleeGoal(AnomalocarisEntity pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.mob = pMob;
            this.pFollowingTargetEvenIfNotSeen = pFollowingTargetEvenIfNotSeen;
            this.target = this.mob.m_5448_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.mob.m_6162_()) {
                return false;
            }
            LivingEntity livingentity = this.mob.m_5448_();
            return super.m_8036_() && this.mob.isHungry() && !this.mob.isHoldingFood() && livingentity.m_20191_().m_82309_() > this.mob.m_20191_().m_82309_();
        }

        public void m_8041_() {
            this.mob.setAttacking(false);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            this.mob.setAttacking(true);
            super.m_6739_(pEnemy, pDistToEnemySqr);
        }
    }

    static class DashToEnsnareGoal
    extends Goal {
        private final AnomalocarisEntity entity;
        private LivingEntity target;

        public DashToEnsnareGoal(AnomalocarisEntity entity) {
            this.entity = entity;
        }

        public boolean m_8036_() {
            if (this.entity.m_6162_()) {
                return false;
            }
            this.target = this.entity.m_5448_();
            if (this.target == null || this.target.m_20159_() || !this.entity.isHungry()) {
                return false;
            }
            if (this.target.m_20191_().m_82309_() > this.entity.m_20191_().m_82309_()) {
                return false;
            }
            double range = this.entity.m_20280_((Entity)this.target);
            if (!(range < 1.0) && !(range > 16.0)) {
                return this.entity.m_217043_().m_188503_(DashToEnsnareGoal.m_186073_((int)5)) == 0;
            }
            return false;
        }

        public void m_8041_() {
            this.entity.setAttacking(false);
        }

        public void m_8056_() {
            Vec3 vector = this.entity.m_20184_();
            Vec3 ray = new Vec3(this.target.m_20185_() - this.entity.m_20185_(), this.target.m_20186_() - this.entity.m_20186_(), this.target.m_20189_() - this.entity.m_20189_());
            if (ray.m_82556_() > 1.0E-7) {
                ray = ray.m_82541_().m_82490_(0.4).m_82549_(vector.m_82490_(0.2));
            }
            this.entity.f_21365_.m_148051_((Entity)this.target);
            this.entity.m_20334_(ray.f_82479_, ray.f_82480_, ray.f_82481_);
            if (this.entity.m_142593_(this.target) >= this.entity.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_()) && this.target.m_20191_().m_82309_() < this.entity.m_20191_().m_82309_() && this.entity.isHungry() && !this.entity.isHoldingFood() && !(this.target instanceof ServerPlayer) && !(this.target instanceof Player)) {
                this.target.m_146926_(this.entity.m_146909_());
                this.target.m_146922_(this.entity.m_146908_());
                this.target.m_7998_((Entity)this.entity, true);
                this.entity.setHoldingFood(true);
                this.entity.setAttacking(true);
            }
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final PathfinderMob entity;

        public SwimGoal(PathfinderMob mob, double speedModifier) {
            super(mob, speedModifier, 10);
            this.entity = mob;
        }

        public boolean m_8036_() {
            return this.entity.m_5448_() == null && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.entity.m_5448_() == null && super.m_8045_();
        }
    }
}

