/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.client.entity.animation.adult.ArandaspisAdultAnimation;
import net.reaper.ancientnature.client.entity.animation.baby.ArandaspisBabyAnimation;
import net.reaper.ancientnature.common.base.BaseWaterAnimal;
import net.reaper.ancientnature.common.entity.ai.goal.base.movement.SwimNearCoralGoal;
import net.reaper.ancientnature.common.entity.ai.goal.base.movement.SwimNearSeaFloorGoal;
import net.reaper.ancientnature.common.entity.ai.pathing.water.BoidMoveControl;
import net.reaper.ancientnature.common.entity.ai.pathing.water.ObstacleNodeEvaluator;
import net.reaper.ancientnature.common.enums.Gender;
import net.reaper.ancientnature.common.goals.AvoidEntitySprinting;
import net.reaper.ancientnature.common.goals.EggBreedGoal;
import net.reaper.ancientnature.common.goals.PanicSprintingGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.common.goals.water.WaterLayEggGoal;
import net.reaper.ancientnature.common.goals.water.WaterSmartAnimalTemptGoal;
import net.reaper.ancientnature.core.registry.ANBlocks;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArandaspisEntity
extends BaseWaterAnimal<ArandaspisEntity>
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(ArandaspisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> FOLLOW_DURATION = SynchedEntityData.m_135353_(ArandaspisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float currentRoll = 0.0f;
    public float tailRot;
    public float prevTailRot;
    boolean hasEggs;
    public final AnimData swimData = new AnimData(this.m_6162_() ? ArandaspisBabyAnimation.SWIM : ArandaspisAdultAnimation.SWIM);
    public BaseAnimation swimAnim = new SimpleAnimation("swim", this.swimData, Loop.CYCLE, 2, 2.0f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return ArandaspisEntity.this.m_6069_() && ArandaspisEntity.this.m_20072_();
        }
    });
    public final AnimData flopData = new AnimData(this.m_6162_() ? ArandaspisBabyAnimation.FLOP : ArandaspisAdultAnimation.FLOP);
    public BaseAnimation flopAnim = new SimpleAnimation("swim", this.flopData, Loop.CYCLE, 2, this.m_6162_() ? 0.5f : 0.9693f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return !ArandaspisEntity.this.m_20072_();
        }
    });

    @Override
    public void initAnimations() {
        this.getAnimator().register(this.swimAnim, this.flopAnim);
    }

    public ArandaspisEntity(EntityType<? extends BaseWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21344_ = new WaterBoundPathNavigation((Mob)this, pLevel){

            @NotNull
            protected PathFinder m_5532_(int max) {
                this.f_26508_ = new ObstacleNodeEvaluator(7, true);
                return new PathFinder(this.f_26508_, max);
            }
        };
        this.f_21342_ = new BoidMoveControl((Mob)this, 85, 0.2f, 0.1f, false);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.3f, (float)0.25f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicSprintingGoal((PathfinderMob)this, 1.2f));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new SwimNearCoralGoal((PathfinderMob)this, 1.0, 30, 10));
        this.f_21345_.m_25352_(0, (Goal)new WildBreedGoal((Animal)this, entity -> this.m_20072_() && !this.m_6162_() && this.m_9236_().m_46462_(), 300));
        if (this.m_9236_().m_46461_()) {
            this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 30));
        }
        if (this.m_9236_().m_46462_()) {
            this.f_21345_.m_25352_(1, (Goal)new SwimNearSeaFloorGoal((PathfinderMob)this, 0.7, 2, 1));
            this.f_21345_.m_25352_(0, (Goal)new SwimNearCoralGoal((PathfinderMob)this, 1.0, 30, 5));
        }
        this.f_21345_.m_25352_(1, new AvoidEntitySprinting<Player>((PathfinderMob)this, Player.class, 8.0f, 1.0, 1.5, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(2, (Goal)new WaterLayEggGoal(this, 1.0, 10, 16, (Block)ANBlocks.ARANDASPIS_ROE.get(), pPos -> !this.m_9236_().m_46861_(pPos) && this.m_9236_().m_46462_()));
        this.f_21345_.m_25352_(2, (Goal)new EggBreedGoal(this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new WaterSmartAnimalTemptGoal(this, 1.2, false));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(FOLLOW_DURATION, (Object)1200);
    }

    @Override
    public boolean m_5957_() {
        return super.m_5957_() && !this.m_20159_() && this.m_20072_() && this.m_9236_().m_46462_() && !this.m_6162_();
    }

    @Override
    @Nonnull
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12329_;
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)ANEntities.ARANDASPIS.get()).m_20615_((Level)pLevel);
    }

    @Override
    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    @Override
    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.canFlop()) {
            if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
                this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
                this.m_6853_(false);
                this.f_19812_ = true;
                this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
                FLOP_TICKS.set((Entity)this, 20);
            }
            if ((Integer)FLOP_TICKS.get((Entity)this) > 0) {
                FLOP_TICKS.set((Entity)this, (Integer)FLOP_TICKS.get((Entity)this) - 1);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
        if (this.f_19797_ % 10 == 0) {
            this.followDolphin();
        }
    }

    public boolean m_7998_(Entity entity, boolean force) {
        boolean result = super.m_7998_(entity, force);
        if (result && !(this.f_21342_ instanceof BoidMoveControl)) {
            this.f_21342_ = new BoidMoveControl((Mob)this, 85, 0.2f, 0.1f, false);
        }
        return result;
    }

    public void m_8127_() {
        super.m_8127_();
        if (!(this.f_21342_ instanceof BoidMoveControl)) {
            this.f_21342_ = new BoidMoveControl((Mob)this, 85, 0.2f, 0.1f, false);
        }
    }

    public BoidMoveControl getBoidControl() {
        if (!(this.f_21342_ instanceof BoidMoveControl)) {
            this.f_21342_ = new BoidMoveControl((Mob)this, 85, 0.2f, 0.1f, false);
        }
        return (BoidMoveControl)this.f_21342_;
    }

    public void followDolphin() {
        if (this.m_20159_()) {
            MoveControl moveControl = this.m_21566_();
            if (moveControl instanceof BoidMoveControl) {
                BoidMoveControl boid = (BoidMoveControl)moveControl;
                boid.setForceTarget(false);
            }
            return;
        }
        List list = this.m_9236_().m_45976_(Dolphin.class, this.m_20191_().m_82400_(10.0));
        if (!list.isEmpty()) {
            if (this.getFollowDuration() > 0) {
                int size = 8;
                Vec3 targetPos = ((Dolphin)list.get(0)).m_20182_().m_82520_(Math.random() * (double)size, Math.random() * (double)size, Math.random() * (double)size);
                this.getBoidControl().setForceTarget(targetPos);
                this.setFollowDuration(this.getFollowDuration() - 1);
            } else {
                this.getBoidControl().setForceTarget(false);
            }
        } else {
            this.getBoidControl().setForceTarget(false);
            this.setFollowDuration(1200);
        }
    }

    protected void m_7324_(Entity p_20971_) {
        if (!(p_20971_ instanceof Dolphin)) {
            super.m_7324_(p_20971_);
        }
    }

    protected float m_6108_() {
        return 1.0f;
    }

    protected float m_6431_(@Nonnull Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.5f;
    }

    public void m_7822_(byte pId) {
        if (pId == 7) {
            this.spawnBubbles();
        } else {
            super.m_7822_(pId);
        }
    }

    protected void spawnBubbles() {
        for (int i = 0; i < 3; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * 0.4f) - (double)0.2f, this.m_20186_() + (double)0.3f, this.m_20189_() + (double)(this.f_19796_.m_188501_() * 0.4f) - (double)0.2f, 0.0, 0.01, -0.3);
        }
    }

    public void m_6858_(boolean pSprinting) {
        this.m_20115_(3, pSprinting);
    }

    @Override
    protected void m_267689_(float pPartialTick) {
        if (this.m_20069_()) {
            super.m_267689_(pPartialTick);
        }
    }

    @Override
    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player pPlayer, @Nonnull InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        if (!this.m_27487_() && p_21436_ != MobSpawnType.BUCKET) {
            int n = this.f_19796_.m_216339_(5, 8);
        }
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("FollowDuration", this.getFollowDuration());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("FollowDuration")) {
            this.setFollowDuration(tag.m_128451_("FollowDuration"));
        }
    }

    public void setFollowDuration(int value) {
        this.f_19804_.m_135381_(FOLLOW_DURATION, (Object)value);
    }

    public int getFollowDuration() {
        return (Integer)this.f_19804_.m_135370_(FOLLOW_DURATION);
    }

    public void m_6872_(@Nonnull ItemStack pStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)pStack);
        CompoundTag compoundtag = pStack.m_41784_();
        compoundtag.m_128405_("Age", this.m_146764_());
        compoundtag.m_128405_("isGestating", this.getGestationTicks());
    }

    public void m_142278_(@Nonnull CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        if (pTag.m_128441_("Age")) {
            this.m_146762_(pTag.m_128451_("Age"));
        }
        if (pTag.m_128441_("isGestating")) {
            this.setGestationTicks(pTag.m_128451_("isGestating"));
        }
        if (pTag.m_128441_("Gender")) {
            this.setGender(Gender.valueOf(pTag.m_128461_("Gender").toUpperCase()));
        }
    }

    @Nonnull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ANItems.ARANDASPIS_BUCKET.get());
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Override
    public boolean doesHaveEggs() {
        return this.hasEggs;
    }

    @Override
    public void setHasEggs(boolean hasEggs) {
        this.hasEggs = hasEggs;
    }
}

