/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.reaper.ancientnature.client.entity.animation.SmoothAnimationState;
import net.reaper.ancientnature.common.base.BaseWaterAnimal;
import net.reaper.ancientnature.common.entity.ai.goal.base.movement.SwimNearSeaFloorGoal;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.entity.ai.pathing.water.ObstacleNodeEvaluator;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.goals.AttackGoal;
import net.reaper.ancientnature.common.goals.ConsumeItemFromGroundGoal;
import net.reaper.ancientnature.common.goals.water.WaterLayEggGoal;
import net.reaper.ancientnature.common.goals.water.WaterSmartAnimalTemptGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANBlocks;
import org.jetbrains.annotations.NotNull;

public class CoelacanthEntity
extends BaseWaterAnimal<CoelacanthEntity> {
    public final SmoothAnimationState floppingAnimationState = new SmoothAnimationState();
    public float tailRot;
    public float prevTailRot;

    public CoelacanthEntity(EntityType<? extends BaseWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 1;
        this.m_7105_(false);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.3f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 75);
        this.f_21344_ = new WaterBoundPathNavigation((Mob)this, pLevel){

            @NotNull
            protected PathFinder m_5532_(int max) {
                this.f_26508_ = new ObstacleNodeEvaluator(7, true);
                return new PathFinder(this.f_26508_, max);
            }
        };
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WaterAnimal.m_21183_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.5f, (float)0.4f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
    }

    @Override
    public void setupAnimationStates() {
        if (!this.m_20072_()) {
            this.floppingAnimationState.m_216982_(this.f_19797_);
        } else {
            this.floppingAnimationState.m_216973_();
        }
    }

    @Override
    public int getAnimationLengthInTicks(BaseAnimalPose pose) {
        return 0;
    }

    @Override
    public boolean canFlop() {
        return true;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this, 1.75, true, this.getAttackAnimationDamageDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.ATTACK)));
        this.f_21345_.m_25352_(4, (Goal)new WaterSmartAnimalTemptGoal(this, 1.2, false));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SwimNearSeaFloorGoal((PathfinderMob)this, 1.0, 2, 4));
        this.f_21345_.m_25352_(2, (Goal)new WaterLayEggGoal(this, 1.0, 10, 16, (Block)ANBlocks.ANOMALOCARIS_EGGS.get(), pPos -> !this.m_9236_().m_46861_(pPos)));
        this.f_21345_.m_25352_(3, (Goal)new ConsumeItemFromGroundGoal(this, 1.2, true, this.getEatAnimationConsumeDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.EAT)));
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.COELACANTH_DIET_ITEMS);
    }

    @Override
    public int getAttackAnimationDamageDelay() {
        return 9;
    }

    @Override
    public int getEatAnimationConsumeDelay() {
        return 9;
    }

    @Override
    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    @Override
    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }
}

