/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.HoldableAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.MobAnimator;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.api.common.tag.EntityTag;
import net.reaper.ancientnature.api.common.tag.TagBuilder;
import net.reaper.ancientnature.api.common.tag.TagType;
import net.reaper.ancientnature.client.entity.animation.adult.DodoAdultAnimation;
import net.reaper.ancientnature.client.entity.animation.baby.DodoBabyAnimation;
import net.reaper.ancientnature.client.particle.DodoFeatherParticle;
import net.reaper.ancientnature.client.particle.option.DodoFeatherData;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.WormEntity;
import net.reaper.ancientnature.common.entity.ai.dance.DanceController;
import net.reaper.ancientnature.common.entity.ai.dance.IDanceable;
import net.reaper.ancientnature.common.entity.ai.dance.RecordFilter;
import net.reaper.ancientnature.common.entity.ai.goal.base.hunt.HuntRules;
import net.reaper.ancientnature.common.entity.ai.goal.base.hunt.HuntTargetGoal;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.entity.ai.hunger.EatBlockGoal;
import net.reaper.ancientnature.common.entity.ai.hunger.EatDroppedItemGoal;
import net.reaper.ancientnature.common.entity.ai.hunger.IEatable;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepAnims;
import net.reaper.ancientnature.common.enums.Gender;
import net.reaper.ancientnature.common.goals.ANFollowOwnerGoal;
import net.reaper.ancientnature.common.goals.DifferentGenderBreedGoal;
import net.reaper.ancientnature.common.goals.GroundLayEggGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANBlocks;
import net.reaper.ancientnature.core.registry.ANSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DodoEntity
extends BaseSleepingAnimal<DodoEntity>
implements IEatable,
IDanceable<DodoEntity> {
    public static final EntityTag<Integer> FALLED_TICKS = new EntityTag(DodoEntity.class, "FalledTicks", TagType.INTEGER);
    private static final EntityDataAccessor<Boolean> DANCE = SynchedEntityData.m_135353_(DodoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final DanceController<DodoEntity> dance;
    public static final EntityDimensions FALL_DIMENSION = EntityDimensions.m_20398_((float)0.9f, (float)0.6f);
    public int rideCooldown = 0;
    public static final byte HIT_PARTICLES_EVENT = 69;
    public final AnimData idleData = new AnimData(this.m_6162_() ? DodoBabyAnimation.IDLE : DodoAdultAnimation.IDLE);
    public BaseAnimation idleAnim = new SimpleAnimation("idle", this.idleData, Loop.CYCLE, 5, 2.88f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return !DodoEntity.this.isRest() && !DodoEntity.this.isSleep();
        }
    });
    public final AnimData sitData = new AnimData(this.m_6162_() ? DodoBabyAnimation.DOWN : DodoAdultAnimation.DOWN);
    public BaseAnimation sitAnim = new SimpleAnimation("sit", this.sitData, Loop.ONCE, 0, 0.64f);
    public final AnimData restData = new AnimData(this.m_6162_() ? DodoBabyAnimation.REST : DodoAdultAnimation.REST);
    public BaseAnimation restAnim = new SimpleAnimation("rest", this.restData, Loop.CYCLE, 1, 2.88f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return DodoEntity.this.isRest() && !DodoEntity.this.isSleep();
        }
    });
    public final AnimData upData = new AnimData(this.m_6162_() ? DodoBabyAnimation.UP : DodoAdultAnimation.UP);
    public BaseAnimation upAnim = new SimpleAnimation("up", this.upData, Loop.ONCE, 0, 0.64f);
    public final AnimData wakeUpData = new AnimData(this.m_6162_() ? DodoBabyAnimation.WAKE_UP : DodoAdultAnimation.WAKE_UP);
    public BaseAnimation wakeUpAnim = new SimpleAnimation("wakeUp", this.wakeUpData, Loop.ONCE, 0, 0.72f);
    public final AnimData asleepData = new AnimData(this.m_6162_() ? DodoBabyAnimation.FALL_SLEEP : DodoAdultAnimation.ASLEEP);
    public BaseAnimation asleepAnim = new SimpleAnimation("asleep", this.asleepData, Loop.ONCE, 0, 0.68f);
    public final AnimData sleepData = new AnimData(this.m_6162_() ? DodoBabyAnimation.SLEEP : DodoAdultAnimation.SLEEP);
    public BaseAnimation sleepAnim = new SimpleAnimation("sleep", this.sleepData, Loop.CYCLE, 1, 2.88f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return DodoEntity.this.isSleep();
        }
    });
    public final AnimData eatData = new AnimData(this.m_6162_() ? DodoBabyAnimation.EAT : DodoAdultAnimation.EAT);
    public BaseAnimation eatAnim = this.createEatAnim(this, this.eatData, 2.12f, 18);
    public final AnimData screamData = new AnimData(this.m_6162_() ? DodoBabyAnimation.SCREAM : DodoAdultAnimation.SCREAM);
    public BaseAnimation screamAnim = new SimpleAnimation("scream", this.screamData, Loop.ONCE, 0, 1.68f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            if (!DodoEntity.this.m_9236_().f_46443_ && DodoEntity.this.m_6084_() && tick == 10) {
                DodoEntity.this.m_9236_().m_5594_(null, DodoEntity.this.m_20183_(), (SoundEvent)ANSounds.DODO_HURT.get(), SoundSource.HOSTILE, 1.0f, 0.7f);
            }
        }
    });
    public final AnimData fallStartData = new AnimData(this.m_6162_() ? DodoBabyAnimation.FALLING : DodoAdultAnimation.FALLING);
    public final AnimData fallLoopData = new AnimData(this.m_6162_() ? DodoBabyAnimation.FALL : DodoAdultAnimation.FALL);
    public final AnimData fallEndData = new AnimData(this.m_6162_() ? DodoBabyAnimation.STANDING : DodoAdultAnimation.STANDING);
    public HoldableAnimation fallAnim = new HoldableAnimation(new SimpleAnimation("fallStart", this.fallStartData, Loop.ONCE, 0, 0.5f), new SimpleAnimation("fallLoop", this.fallLoopData, Loop.CYCLE, 1, 0.5f).setCanInterrupt(true).setPlayCondition(anim -> FALLED_TICKS.get((Entity)this) > 0), new SimpleAnimation("fallEnd", this.fallEndData, Loop.ONCE, 0, 0.75f));
    public final AnimData danceData = new AnimData(DodoAdultAnimation.DANCING);
    public BaseAnimation danceAnim = this.createDanceAnim(this.danceData, 1.0f, MobAnimator.EMPTY_DATA, 0.0f).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return DodoEntity.this.dance.isDance() && !DodoEntity.this.fallAnim.isActive();
        }
    }).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            if (!(DodoEntity.this.m_9236_().f_46443_ || tick != 19 && tick != 9)) {
                DodoEntity.this.m_9236_().m_247517_(null, DodoEntity.this.m_20183_(), DodoEntity.this.m_9236_().m_8055_(DodoEntity.this.m_20097_()).getSoundType((LevelReader)DodoEntity.this.m_9236_(), DodoEntity.this.m_20097_(), (Entity)DodoEntity.this).m_56776_(), SoundSource.NEUTRAL);
            }
        }
    });
    public final AnimData attackData = new AnimData(DodoAdultAnimation.ATTACK);
    public BaseAnimation attackAnim = new SimpleAnimation("attack", this.attackData, Loop.ONCE, 0, 0.5848f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            LivingEntity target;
            if (tick == 3 && !DodoEntity.this.m_9236_().f_46443_ && (target = DodoEntity.this.m_5448_()) != null && DodoEntity.this.m_20270_((Entity)target) <= 2.0f) {
                DodoEntity.this.m_7327_((Entity)target);
            }
        }
    });
    public final AnimData breakData = new AnimData(DodoAdultAnimation.BREAK);
    public BaseAnimation breakAnim = this.createBreakAnim(this, this.breakData, 33, new int[]{17, 25});
    public final AnimData gatherData = new AnimData(this.m_6162_() ? DodoBabyAnimation.GATHER : DodoAdultAnimation.GATHER);
    public BaseAnimation gatherAnim = this.createGatherAnim(this, this.gatherData, 10);

    public DodoEntity(@NotNull EntityType<? extends TamableAnimal> type, @NotNull Level level) {
        super(type, level);
        this.sleepAnims = this.getSleepAnimations();
        this.sleep = this.createSleep();
        this.hunger = this.createHunger();
        this.dance = new DanceController<DodoEntity>(this, RecordFilter.create().allowAll().deny(new ItemLike[]{Items.f_42710_}).deny(new ItemLike[]{Items.f_220217_})){

            @Override
            public boolean isDance() {
                return (Boolean)DodoEntity.this.f_19804_.m_135370_(DANCE);
            }

            @Override
            public void setDance(boolean value) {
                DodoEntity.this.f_19804_.m_135381_(DANCE, (Object)value);
            }
        };
    }

    @Override
    @Nullable
    public SleepAnims getSleepAnimations() {
        return new SleepAnims(this.sitAnim, this.restAnim, this.sleepAnim, this.asleepAnim, this.wakeUpAnim, this.upAnim);
    }

    @Override
    public void initAnimations() {
        this.getAnimator().register(this.idleAnim, this.sitAnim, this.restAnim, this.upAnim, this.wakeUpAnim, this.asleepAnim, this.sleepAnim, this.attackAnim, this.breakAnim, this.gatherAnim, this.eatAnim, this.fallAnim.getStartAnim(), this.fallAnim.getLoopAnim(), this.fallAnim.getEndAnim(), this.screamAnim, this.danceAnim);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268534_) || source.m_276093_(DamageTypes.f_268464_))) {
            LivingEntity attacker;
            Entity entity;
            this.m_9236_().m_7605_((Entity)this, (byte)69);
            if (this.dance.isDance()) {
                FALLED_TICKS.set((Entity)this, 300);
                if (!this.fallAnim.isActive()) {
                    this.fallAnim.start();
                }
            } else if (!this.fallAnim.isActive() && (entity = source.m_7640_()) instanceof LivingEntity && !this.m_7307_((Entity)(attacker = (LivingEntity)entity))) {
                AABB area = new AABB(this.m_20183_()).m_82377_(15.0, 15.0, 15.0);
                this.m_9236_().m_6443_(DodoEntity.class, area, dodo -> dodo.m_6084_() && !dodo.m_5833_()).forEach(dodo -> {
                    Vec3 pos;
                    PathNavigation path = dodo.m_21573_();
                    if (!path.m_26571_()) {
                        path.m_26573_();
                    }
                    if ((pos = LandRandomPos.m_148521_((PathfinderMob)this, (int)15, (int)8, (Vec3)attacker.m_20182_())) != null) {
                        path.m_26519_(pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)1.3f);
                    }
                });
                this.getAnimator().play(this.screamAnim);
            }
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean canDance() {
        return FALLED_TICKS.get((Entity)this) <= 0;
    }

    @Override
    public void addTags(@NotNull TagBuilder builder) {
        super.addTags(builder);
        builder.add(FALLED_TICKS);
    }

    @Override
    @NotNull
    public DanceController<DodoEntity> getDanceController() {
        return this.dance;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DANCE, (Object)false);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.dance.update();
    }

    public void m_213651_(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer) {
        this.dance.updateListener(consumer);
    }

    @Override
    public void onItemEat(@NotNull ItemEntity item, @NotNull ItemStack eatedStack) {
        this.getAnimator().play(this.eatAnim);
    }

    @Override
    @Nullable
    public BaseAnimation getBreakAnim() {
        return this.breakAnim;
    }

    @Override
    @Nullable
    public BaseAnimation getGatherAnim() {
        return this.gatherAnim;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimator().isAnyPlaying(this.eatAnim, this.restAnim, this.sleepAnim, this.danceAnim);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.16).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public static boolean canSpawn(EntityType<? extends Animal> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int chunkX = pPos.m_123341_() >> 4;
        int chunkZ = pPos.m_123343_() >> 4;
        AncientNature.LOGGER.info("Trying dodo spawn");
        Optional closestMelon = BlockPos.m_121930_((BlockPos)pPos, (int)16, (int)16, blockPos -> {
            int blockChunkX = blockPos.m_123341_() >> 4;
            int blockChunkZ = blockPos.m_123343_() >> 4;
            if (blockChunkX != chunkX || blockChunkZ != chunkZ) {
                return false;
            }
            return pLevel.m_8055_(blockPos).m_60713_(Blocks.f_50186_);
        });
        if (closestMelon.isPresent()) {
            AncientNature.LOGGER.info("Found melon block at: " + closestMelon);
            if (pPos.m_123331_((Vec3i)closestMelon.get()) <= 100.0) {
                boolean canSpawn = DodoEntity.m_218104_(pAnimal, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
                AncientNature.LOGGER.info("SPAWNED DODO AT: " + pPos);
                return canSpawn;
            }
        }
        AncientNature.LOGGER.info("NO MELON FOUND IN RADIUS");
        return false;
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.DODO_DIET_ITEMS).addBlocks(Blocks.f_50186_).addBlocks(Blocks.f_50685_);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new EatBlockGoal((Mob)this, 1.0f, 10));
        this.f_21345_.m_25352_(1, (Goal)new EatDroppedItemGoal(this, 1.0f, true, 0.5f));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, entity -> !this.m_20072_() && !this.m_6162_() && this.m_5803_(), 300));
        this.f_21345_.m_25352_(2, (Goal)new DifferentGenderBreedGoal((Animal)this, 1.5, DodoEntity.class, true));
        this.f_21345_.m_25352_(2, (Goal)new GroundLayEggGoal(this, 1.5, 10, 2, (Block)ANBlocks.DODO_EGG.get()));
        this.f_21345_.m_25352_(3, (Goal)new ANFollowOwnerGoal(this, 1.3f, 1.6f, 10.0f, 15.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HuntTargetGoal((Mob)this, HuntRules.ofType(WormEntity.class), null).withRange(10.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true){

            protected void m_6739_(@NotNull LivingEntity enemy, double dist) {
                if (dist <= this.m_6639_(enemy) && !DodoEntity.this.getAnimator().isPlaying(DodoEntity.this.attackAnim.getName())) {
                    DodoEntity.this.getAnimator().play(DodoEntity.this.attackAnim);
                }
            }
        });
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_6144_() && player.m_20197_().isEmpty() && this.m_21830_((LivingEntity)player)) {
            this.m_20329_((Entity)player);
            this.rideCooldown = 20;
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            FALLED_TICKS.set((Entity)this, Math.max(FALLED_TICKS.get((Entity)this) - 1, 0));
            this.m_6858_(this.m_5448_() != null || this.isSprintingToOwner);
        }
        if (this.rideCooldown > 0) {
            --this.rideCooldown;
        }
    }

    @Override
    public void tickDance() {
        if (!this.fallAnim.isActive() && this.f_19796_.m_188503_(400) == 0) {
            FALLED_TICKS.set((Entity)this, 100);
            this.fallAnim.start();
        }
    }

    public void m_7822_(byte id) {
        if (id == 69) {
            String name = this.m_7770_() != null ? this.m_7770_().getString() : "";
            List<String> willNames = List.of("will", "william", "axtrough", "axtroana");
            List<String> fazNames = List.of("dinofaz", "faz", "dinofazyt", "fazyt", "dinofazbear", "dinofazbearyt");
            DodoFeatherParticle.Type type = this.m_6162_() ? (name.equals("doydoy") ? DodoFeatherParticle.Type.DOYDOY_BABY : (willNames.contains(name) && this.getGender() == Gender.MALE ? DodoFeatherParticle.Type.WILL_BABY : (fazNames.contains(name) && this.getGender() == Gender.MALE ? DodoFeatherParticle.Type.FAZ_BABY : (this.getGender() == Gender.MALE ? DodoFeatherParticle.Type.MALE_BABY : DodoFeatherParticle.Type.FEMALE_BABY)))) : (willNames.contains(name) && this.getGender() == Gender.MALE ? DodoFeatherParticle.Type.WILL : (fazNames.contains(name) && this.getGender() == Gender.MALE ? DodoFeatherParticle.Type.FAZ : (name.equals("doydoy") ? DodoFeatherParticle.Type.DOYDOY : (this.getGender() == Gender.MALE ? DodoFeatherParticle.Type.MALE : DodoFeatherParticle.Type.FEMALE))));
            for (int i = 0; i < 16; ++i) {
                double px = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                double py = this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_();
                double pz = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_();
                double vx = (this.f_19796_.m_188500_() - 0.5) * (double)0.2f;
                double vy = (this.f_19796_.m_188500_() - (double)0.3f) * (double)0.2f + (double)0.1f;
                double vz = (this.f_19796_.m_188500_() - 0.5) * (double)0.2f;
                this.m_9236_().m_7106_((ParticleOptions)new DodoFeatherData(type.m_7912_()), px, py, pz, vx, vy, vz);
            }
        } else {
            super.m_7822_(id);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6083_() {
        Entity mount = this.m_20202_();
        if (this.m_20159_() && !mount.m_6084_()) {
            this.m_8127_();
            return;
        }
        if (this.m_20159_() && mount instanceof Player) {
            Player player = (Player)mount;
            if (this.m_21830_((LivingEntity)mount)) {
                this.m_8119_();
                this.m_6034_(player.m_20185_(), player.m_20186_() + 1.8, player.m_20189_());
                this.m_20334_(0.0, 0.0, 0.0);
                if (this.m_9236_().f_46443_) {
                    this.f_20883_ = player.f_20883_;
                    this.m_146922_(player.m_146908_());
                    this.f_20885_ = player.f_20883_;
                    this.f_19859_ = player.f_20884_;
                }
                if (player.m_6144_()) {
                    this.m_6034_(player.m_20185_(), player.m_20186_() + 1.45, player.m_20189_());
                }
                if (this.m_6162_()) {
                    this.m_6034_(player.m_20185_(), player.m_20186_() + 1.85, player.m_20189_());
                    if (player.m_6144_()) {
                        this.m_6034_(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_());
                    }
                }
                if (player.m_204029_(FluidTags.f_13131_) || player.m_204029_(FluidTags.f_13132_) || player.f_146808_) {
                    this.m_8127_();
                }
                float yaw = player.m_146908_();
                double radian = Math.toRadians(yaw);
                double dx = -Math.sin(radian);
                double dz = Math.cos(radian);
                if (player.m_146909_() < -55.0f && this.rideCooldown == 0) {
                    this.m_8127_();
                    this.m_20334_(dx * -0.2, 0.0, dz * -0.2);
                    return;
                }
                if (!(player.m_146909_() > 55.0f)) return;
                if (this.rideCooldown != 0) return;
                this.m_8127_();
                this.m_20334_(dx * 0.2, 0.0, dz * 0.2);
                return;
            }
        }
        super.m_6083_();
    }

    @Override
    protected EntityDimensions getSitBox() {
        return EntityDimensions.m_20395_((float)0.9f, (float)0.8f);
    }

    @Override
    protected EntityDimensions getBabySitBox() {
        return EntityDimensions.m_20395_((float)0.55f, (float)0.45f);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.55f, (float)0.55f);
    }

    @Override
    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        if (!this.m_6162_() && this.getAnimator().isPlaying(this.fallAnim.getLoopAnim().getName())) {
            return FALL_DIMENSION;
        }
        return super.m_6972_(pose);
    }

    public void m_7023_(@NotNull Vec3 travelVec) {
        if (this.getAnimator().isAnyPlaying(this.danceAnim, this.fallAnim.getLoopAnim())) {
            this.m_21573_().m_26573_();
            travelVec = Vec3.f_82478_;
            this.m_20256_(travelVec);
        }
        super.m_7023_(travelVec);
    }

    public boolean m_6094_() {
        return !this.isSleep() && !this.isRest() && !this.getAnimator().isPlaying(this.eatAnim.getName()) && super.m_6094_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ANSounds.DODO_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ANSounds.DODO_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource source) {
        return (SoundEvent)ANSounds.DODO_HURT.get();
    }

    protected float m_6121_() {
        return 0.5f;
    }
}

