/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.client.entity.animation.adult.EstemmenosuchusAdultAnimation;
import net.reaper.ancientnature.client.entity.animation.baby.EstemmenosuchusBabyAnimation;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.ai.goal.base.hunt.HuntTargetUntamedGoal;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.entity.ai.hunger.EatDroppedItemGoal;
import net.reaper.ancientnature.common.entity.ai.hunger.IEatable;
import net.reaper.ancientnature.common.entity.ai.roar.RoarController;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepAnims;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.goals.DifferentGenderBreedGoal;
import net.reaper.ancientnature.common.goals.GroundLayEggGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANBlocks;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANSounds;
import net.reaper.ancientnature.core.registry.ANTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EstemmenosuchusEntity
extends BaseSleepingAnimal<EstemmenosuchusEntity>
implements IEatable {
    public float tailRot;
    public float prevTailRot;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 mouthPos = Vec3.f_82478_;
    @Nullable
    public ItemEntity targetItem = null;
    private static final Predicate<LivingEntity> ESTEMMENOSUCHUS_TARGETS = living -> living.m_6095_().m_204039_(ANTags.Entities.ESTEMMENOSUCHUS_TARGETS);
    public final AnimData idleData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.IDLE : EstemmenosuchusAdultAnimation.IDLE);
    public BaseAnimation idleAnim = new SimpleAnimation("idle", this.idleData, Loop.CYCLE, 2, 4.0f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return !EstemmenosuchusEntity.this.isRest() && !EstemmenosuchusEntity.this.isSleep() && !EstemmenosuchusEntity.this.isRoaring();
        }
    });
    public final AnimData sitData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.SIT : EstemmenosuchusAdultAnimation.SIT);
    public BaseAnimation sitAnim = new SimpleAnimation("sit", this.sitData, Loop.ONCE, 0, 0.7368f);
    public final AnimData restData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.REST : EstemmenosuchusAdultAnimation.REST);
    public BaseAnimation restAnim = new SimpleAnimation("rest", this.restData, Loop.CYCLE, 1, 3.2787f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return EstemmenosuchusEntity.this.isRest() && !EstemmenosuchusEntity.this.isSleep() && !EstemmenosuchusEntity.this.isRoaring();
        }
    });
    public final AnimData roarData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.ROAR : EstemmenosuchusAdultAnimation.ROAR);
    public BaseAnimation roarAnim = this.createRoarAnim(this, this.roarData, 2.25f, 3);
    public final AnimData upData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.UP : EstemmenosuchusAdultAnimation.UP);
    public BaseAnimation upAnim = new SimpleAnimation("up", this.upData, Loop.ONCE, 0, 1.1074f);
    public final AnimData wakeUpData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.WAKE_UP : EstemmenosuchusAdultAnimation.WAKE_UP);
    public BaseAnimation wakeUpAnim = new SimpleAnimation("wakeUp", this.wakeUpData, Loop.ONCE, 0, 1.0f);
    public final AnimData asleepData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.ASLEEP : EstemmenosuchusAdultAnimation.ASLEEP);
    public BaseAnimation asleepAnim = new SimpleAnimation("asleep", this.asleepData, Loop.ONCE, 0, 1.6393f);
    public final AnimData sleepData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.SLEEPING : EstemmenosuchusAdultAnimation.SLEEPING);
    public BaseAnimation sleepAnim = new SimpleAnimation("sleep", this.sleepData, Loop.CYCLE, 1, 2.2153f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return EstemmenosuchusEntity.this.isSleep();
        }
    });
    public final AnimData eatData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.EAT : EstemmenosuchusAdultAnimation.EAT_DROPPED_ITEM);
    public BaseAnimation eatAnim = new SimpleAnimation("eat", this.eatData, Loop.ONCE, 0, 2.875f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            ItemEntity item;
            if (tick == 18 && !EstemmenosuchusEntity.this.m_9236_().f_46443_ && (item = EstemmenosuchusEntity.this.getTargetItem()) != null && !item.m_213877_()) {
                EstemmenosuchusEntity.this.m_21008_(InteractionHand.MAIN_HAND, item.m_32055_().m_41777_());
                if (EstemmenosuchusEntity.this.hunger != null) {
                    EstemmenosuchusEntity.this.hunger.tryEatItem(item.m_32055_());
                }
                EstemmenosuchusEntity.this.m_9236_().m_247517_(null, EstemmenosuchusEntity.this.m_20183_(), SoundEvents.f_11912_, SoundSource.MASTER);
                EstemmenosuchusEntity.this.setTargetItem(null);
            }
            if (tick >= 8 && tick <= 20 && EstemmenosuchusEntity.this.m_9236_().f_46443_) {
                float dx = (EstemmenosuchusEntity.this.m_217043_().m_188501_() - 0.5f) * 0.06f;
                float dz = (EstemmenosuchusEntity.this.m_217043_().m_188501_() - 0.5f) * 0.06f;
                EstemmenosuchusEntity.this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42579_)), EstemmenosuchusEntity.this.mouthPos.f_82479_, EstemmenosuchusEntity.this.mouthPos.f_82480_ + (double)0.1f, EstemmenosuchusEntity.this.mouthPos.f_82481_, (double)dx, 0.0, (double)dz);
            }
        }
    });
    public final AnimData attackData = new AnimData(this.m_6162_() ? EstemmenosuchusBabyAnimation.ATTACK : EstemmenosuchusAdultAnimation.ATTACK);
    public BaseAnimation attackAnim = new SimpleAnimation("attack", this.attackData, Loop.ONCE, 0, 0.5959f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            LivingEntity target;
            if (tick == 3 && !EstemmenosuchusEntity.this.m_9236_().f_46443_ && (target = EstemmenosuchusEntity.this.m_5448_()) != null && EstemmenosuchusEntity.this.m_20270_((Entity)target) <= 3.0f) {
                EstemmenosuchusEntity.this.m_7327_((Entity)target);
            }
        }
    });

    public EstemmenosuchusEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 4;
        this.sleepAnims = this.getSleepAnimations();
        this.sleep = this.createSleep();
        this.hunger = this.createHunger();
        this.roar = new RoarController<EstemmenosuchusEntity>(this, this.roarAnim);
        this.f_21344_ = new GroundPathNavigation((Mob)this, pLevel);
        this.f_21342_ = new MoveControl((Mob)this);
        this.m_7105_(true);
        this.m_274367_(1.0f);
    }

    @Override
    public void onItemEat(@NotNull ItemEntity item, @NotNull ItemStack stolenStack) {
        this.getAnimator().play(this.eatAnim);
    }

    @Override
    @Nullable
    public ItemEntity getTargetItem() {
        return this.targetItem;
    }

    @Override
    public void setTargetItem(@Nullable ItemEntity item) {
        this.targetItem = item;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimator().isAnyPlaying(this.eatAnim, this.restAnim, this.sleepAnim, this.attackAnim, this.wakeUpAnim, this.upAnim, this.roarAnim);
    }

    @Override
    @Nullable
    public SleepAnims getSleepAnimations() {
        return new SleepAnims(this.sitAnim, this.asleepAnim, this.restAnim, this.sleepAnim, this.wakeUpAnim, this.upAnim);
    }

    @Override
    public void initAnimations() {
        this.getAnimator().register(this.idleAnim, this.sitAnim, this.restAnim, this.upAnim, this.wakeUpAnim, this.asleepAnim, this.sleepAnim, this.eatAnim, this.attackAnim, this.roarAnim);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)1.0f, (float)0.8f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_6858_(this.m_5448_() != null);
            this.setupAnimationStates();
        }
        if (this.isEating() && this.m_217043_().m_188503_(10) == 0) {
            this.playEatSound();
        }
        if (this.isAttacking() && this.m_217043_().m_188503_(10) == 0) {
            this.playAttackSound();
        }
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.isEating() && this.m_217043_().m_188503_(10) == 0) {
            this.playEatSound();
        }
        if (this.isAttacking() && this.m_217043_().m_188503_(10) == 0) {
            this.playAttackSound();
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EatDroppedItemGoal(this, 1.0f, true, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true){

            protected void m_6739_(@NotNull LivingEntity enemy, double dist) {
                if (dist <= this.m_6639_(enemy) && !EstemmenosuchusEntity.this.getAnimator().isAnyPlaying(EstemmenosuchusEntity.this.attackAnim)) {
                    EstemmenosuchusEntity.this.getAnimator().play(EstemmenosuchusEntity.this.attackAnim);
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new DifferentGenderBreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, entity -> !this.m_20072_() && !this.m_6162_() && !this.m_5803_() && !this.m_5912_(), 300));
        this.f_21345_.m_25352_(2, (Goal)new GroundLayEggGoal(this, 1.0, 300, 1, (Block)ANBlocks.ESTEMMENOSUCHUS_EGG.get()));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(6, new HuntTargetUntamedGoal<Mob>(this, Mob.class, 100, true, false, ESTEMMENOSUCHUS_TARGETS));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.ESTEMMENOSUCHUS_DIET_ITEMS).addBlocks(Blocks.f_50186_).addBlocks(Blocks.f_50685_);
    }

    @Override
    public int getAttackAnimationDamageDelay() {
        return 9;
    }

    @Override
    public int getEatAnimationConsumeDelay() {
        return 9;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ANSounds.LIZAMBER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ANSounds.LIZAMBER_DEATH.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource pDamageSource) {
        return (SoundEvent)ANSounds.LIZAMBER_HURT.get();
    }

    protected void playEatSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.LIZAMBER_EAT.get(), SoundSource.NEUTRAL, this.m_6121_(), 0.4f);
    }

    @Override
    public void playRoarSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.LIZAMBER_ROAR.get(), SoundSource.NEUTRAL, this.m_6121_(), 0.4f);
    }

    protected void playAttackSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.LIZAMBER_ATTACK.get(), SoundSource.HOSTILE, this.m_6121_(), 0.4f);
    }

    protected float m_6121_() {
        return 0.3f;
    }

    public EstemmenosuchusEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (EstemmenosuchusEntity)((EntityType)ANEntities.ESTEMMENOSUCHUS.get()).m_20615_((Level)pLevel);
    }

    @Override
    public int getAnimationLengthInTicks(BaseAnimalPose sleepPose) {
        return 0;
    }
}

