/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.client.entity.animation.adult.HorseshoeCrabAdultAnimation;
import net.reaper.ancientnature.client.entity.animation.baby.HorseshoeCrabBabyAnimation;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.ai.control.SmoothBodyRotationControl;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.goals.ConsumeItemFromGroundGoal;
import net.reaper.ancientnature.common.goals.EggBreedGoal;
import net.reaper.ancientnature.common.goals.SearchAndDigForWormGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.common.goals.water.WaterLayEggGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANBlocks;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.core.registry.ANSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HorseshoeCrabEntity
extends BaseAnimal<HorseshoeCrabEntity>
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(HorseshoeCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_MANGROVE_VARIANT = SynchedEntityData.m_135353_(HorseshoeCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_UPSIDE_DOWN = SynchedEntityData.m_135353_(HorseshoeCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> isDigging = SynchedEntityData.m_135353_(HorseshoeCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final int EGG_LAYING_COOLDOWN = 6000;
    public float tailRot;
    public float prevTailRot;
    private int airSupply = 12000;
    public final AnimData digData = new AnimData(this.m_6162_() ? HorseshoeCrabBabyAnimation.DIG : HorseshoeCrabAdultAnimation.DIG);
    public BaseAnimation digAnim = new SimpleAnimation("dig", this.digData, Loop.CYCLE, 2, 1.0f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return HorseshoeCrabEntity.this.isDigging();
        }
    });

    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimator().isAnyPlaying(this.digAnim);
    }

    @Override
    public void initAnimations() {
        this.getAnimator().register(this.digAnim);
    }

    public HorseshoeCrabEntity(EntityType<? extends HorseshoeCrabEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.f_21342_ = new MoveControl((Mob)this);
    }

    public static boolean canSpawn(EntityType<HorseshoeCrabEntity> tEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return HorseshoeCrabEntity.m_218104_(tEntityType, (LevelAccessor)serverLevelAccessor, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    @Override
    @NotNull
    protected BodyRotationControl m_7560_() {
        SmoothBodyRotationControl<HorseshoeCrabEntity> control = new SmoothBodyRotationControl<HorseshoeCrabEntity>(this);
        control.bodyMax = 3.0f;
        return control;
    }

    public int m_8085_() {
        return 0;
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.HORSESHOECRAB_DIET_ITEMS);
    }

    public boolean m_7337_(Entity pEntity) {
        return pEntity.m_6084_();
    }

    public boolean m_6094_() {
        return true;
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.4f, (float)0.15f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
        if (!this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
        this.m_146926_(0.0f);
    }

    @Override
    protected void m_267689_(float pPartialTick) {
        this.f_267362_.m_267566_(1.0f, 1.0f);
    }

    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(this.airSupply);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.2f));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, false));
        this.f_21345_.m_25352_(2, (Goal)new EggBreedGoal(this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new WaterLayEggGoal(this, 1.0, 10, 16, (Block)ANBlocks.HORSESHOE_CRAB_EGGS.get()));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, e -> true, 300));
        this.f_21345_.m_25352_(4, (Goal)new ConsumeItemFromGroundGoal(this, 1.2, true, this.getEatAnimationConsumeDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.EAT)));
        this.f_21345_.m_25352_(5, (Goal)new SearchAndDigForWormGoal(this, 1.2f, 5, 5));
        this.f_21345_.m_25352_(6, (Goal)new GoToWaterGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    @Nullable
    public HorseshoeCrabEntity getBreedOffspring(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        HorseshoeCrabEntity baby = (HorseshoeCrabEntity)((EntityType)ANEntities.HORSESHOE_CRAB.get()).m_20615_((Level)pLevel);
        if (((HorseshoeCrabEntity)pOtherParent).isMangroveVariant()) {
            baby = (HorseshoeCrabEntity)((EntityType)ANEntities.HORSESHOE_CRAB.get()).m_20615_((Level)pLevel);
        }
        assert (baby != null);
        baby.setMangroveVariant(this.isMangroveVariant());
        baby.m_21530_();
        return baby;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20071_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)0.2f);
        } else if (this.isUpsideDown()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)0.1f);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        BlockPos position = this.m_20183_();
        ResourceKey biomeKey = this.m_9236_().m_204166_(position).m_203543_().orElse(null);
        AncientNature.LOGGER.info("Spawning horseshe at " + position);
        if (biomeKey != null && biomeKey.m_135782_().m_135815_().contains("mangrove")) {
            this.setMangroveVariant(true);
        } else {
            this.setMangroveVariant(false);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public int m_20146_() {
        return this.airSupply;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12420_;
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return (SoundEvent)ANSounds.TRILOBITES_HURT.get();
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12335_, 0.15f, 1.0f);
    }

    @Override
    public boolean m_5957_() {
        return super.m_5957_() && !this.doesHaveEggs() && !this.isHungry();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public void m_6872_(@Nonnull ItemStack pStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)pStack);
        CompoundTag compoundtag = pStack.m_41784_();
        compoundtag.m_128405_("Air", this.m_20146_());
        compoundtag.m_128405_("Age", this.m_146764_());
        compoundtag.m_128379_("IsMangrove", this.isMangroveVariant());
        compoundtag.m_128350_("Health", this.m_21223_());
        compoundtag.m_128359_("Gender", this.getGender().toString());
        compoundtag.m_128379_("isBaby", this.m_6162_());
        compoundtag.m_128405_("hunger", this.getTicksUntilHungry());
        compoundtag.m_128350_("stamina", this.getStamina());
        compoundtag.m_128379_("hasEggs", this.doesHaveEggs());
    }

    public void m_142278_(@Nonnull CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        if (pTag.m_128441_("isMangroveVariant")) {
            pTag.m_128379_("isMangroveVariant", this.isMangroveVariant());
        }
        if (pTag.m_128441_("Air")) {
            pTag.m_128350_("Air", (float)this.m_20146_());
        }
        if (pTag.m_128441_("isUpsideDown")) {
            pTag.m_128379_("isUpsideDown", this.isUpsideDown());
        }
        if (pTag.m_128441_("Health")) {
            pTag.m_128350_("Health", this.m_21223_());
        }
        if (pTag.m_128441_("Gender")) {
            pTag.m_128359_("Gender", this.getGender().toString());
        }
        if (pTag.m_128441_("isBaby")) {
            pTag.m_128379_("isBaby", this.m_6162_());
        }
        if (pTag.m_128441_("hunger")) {
            pTag.m_128405_("hunger", this.getTicksUntilHungry());
        }
        if (pTag.m_128441_("stamina")) {
            pTag.m_128350_("stamina", this.getStamina());
        }
        if (pTag.m_128441_("hasEggs")) {
            pTag.m_128379_("hasEggs", this.doesHaveEggs());
        }
        if (pTag.m_128441_("Age")) {
            this.m_146762_(pTag.m_128451_("Age"));
        }
        if (pTag.m_128441_("ticksUntilHungry")) {
            this.setTicksUntilHungry(pTag.m_128451_("ticksUntilHungry"));
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ANItems.HORSESHOE_CRAB_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_MANGROVE_VARIANT, (Object)false);
        this.f_19804_.m_135372_(isDigging, (Object)false);
        this.f_19804_.m_135372_(IS_UPSIDE_DOWN, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("isMangroveVariant", this.isMangroveVariant());
        pCompound.m_128379_("isUpsideDown", this.isUpsideDown());
        pCompound.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setMangroveVariant(pCompound.m_128471_("isMangroveVariant"));
        this.setUpsideDown(pCompound.m_128471_("isUpsideDown"));
        this.m_27497_(pCompound.m_128471_("FromBucket"));
    }

    public boolean isMangroveVariant() {
        return (Boolean)this.f_19804_.m_135370_(IS_MANGROVE_VARIANT);
    }

    public void setMangroveVariant(boolean mangroveVariant) {
        this.f_19804_.m_135381_(IS_MANGROVE_VARIANT, (Object)mangroveVariant);
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(isDigging);
    }

    public void setisDigging(boolean mangroveVariant) {
        this.f_19804_.m_135381_(isDigging, (Object)mangroveVariant);
    }

    public boolean isUpsideDown() {
        return (Boolean)this.f_19804_.m_135370_(IS_UPSIDE_DOWN);
    }

    public void setUpsideDown(boolean upsideDown) {
        this.f_19804_.m_135381_(IS_UPSIDE_DOWN, (Object)upsideDown);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
        if (itemInHand.m_204117_(ItemTags.f_271138_)) {
            if (!this.m_9236_().m_5776_()) {
                this.setUpsideDown(!this.isUpsideDown());
                this.m_5496_(SoundEvents.f_12473_, 0.5f, 0.5f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    static class GoToWaterGoal
    extends Goal {
        private final PathfinderMob mob;
        private final double speedModifier;
        private final Level level;
        private double wantedX;
        private double wantedY;
        private double wantedZ;

        public GoToWaterGoal(PathfinderMob pMob, double pSpeedModifier) {
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.level = pMob.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20069_()) {
                return false;
            }
            Vec3 vec3 = this.getWaterPos();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @javax.annotation.Nullable
        private Vec3 getWaterPos() {
            RandomSource randomsource = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(randomsource.m_188503_(20) - 10, 2 - randomsource.m_188503_(8), randomsource.m_188503_(20) - 10);
                if (!this.level.m_8055_(blockpos1).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }
}

