/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.api.common.tag.EntityTag;
import net.reaper.ancientnature.api.common.tag.IEntityData;
import net.reaper.ancientnature.api.common.tag.IHasEntityTags;
import net.reaper.ancientnature.api.common.tag.TagBuilder;
import net.reaper.ancientnature.api.common.tag.TagType;
import net.reaper.ancientnature.client.entity.animation.adult.JakapilAdultAnimation;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.entity.ai.hunger.EatDroppedItemGoal;
import net.reaper.ancientnature.common.entity.ai.hunger.IEatable;
import net.reaper.ancientnature.common.entity.ai.roar.RoarController;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepAnims;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JakapilEntity
extends BaseSleepingAnimal<JakapilEntity>
implements IEatable,
IHasEntityTags {
    public static final EntityTag<Boolean> THREATING = new EntityTag(JakapilEntity.class, "Threating", TagType.BOOLEAN);
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 mouthPos = Vec3.f_82478_;
    @Nullable
    public ItemEntity targetItem = null;
    public final AnimData idleData = new AnimData(JakapilAdultAnimation.IDLE);
    public BaseAnimation idleAnim = new SimpleAnimation("idle", this.idleData, Loop.CYCLE, 2, 2.8169f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return !JakapilEntity.this.isRest() && !JakapilEntity.this.isSleep();
        }
    });
    public final AnimData sitData = new AnimData(JakapilAdultAnimation.SIT);
    public BaseAnimation sitAnim = new SimpleAnimation("sit", this.sitData, Loop.ONCE, 0, 1.0417f);
    public final AnimData restData = new AnimData(JakapilAdultAnimation.REST);
    public BaseAnimation restAnim = new SimpleAnimation("rest", this.restData, Loop.CYCLE, 1, 3.0303f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return JakapilEntity.this.isRest() && !JakapilEntity.this.isSleep();
        }
    });
    public final AnimData upData = new AnimData(JakapilAdultAnimation.UP);
    public BaseAnimation upAnim = new SimpleAnimation("up", this.upData, Loop.ONCE, 0, 1.0f);
    public final AnimData wakeUpData = new AnimData(JakapilAdultAnimation.WAKE_UP);
    public BaseAnimation wakeUpAnim = new SimpleAnimation("wakeUp", this.wakeUpData, Loop.ONCE, 0, 1.0f);
    public final AnimData asleepData = new AnimData(JakapilAdultAnimation.ASLEEP);
    public BaseAnimation asleepAnim = new SimpleAnimation("asleep", this.asleepData, Loop.ONCE, 0, 1.0f);
    public final AnimData sleepData = new AnimData(JakapilAdultAnimation.SLEEP);
    public BaseAnimation sleepAnim = new SimpleAnimation("sleep", this.sleepData, Loop.CYCLE, 1, 1.5f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return JakapilEntity.this.isSleep();
        }
    });
    public final AnimData eatData = new AnimData(JakapilAdultAnimation.EAT);
    public BaseAnimation eatAnim = new SimpleAnimation("eat", this.eatData, Loop.ONCE, 0, 1.2324f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            ItemEntity item;
            if (tick == 18 && !JakapilEntity.this.m_9236_().f_46443_ && (item = JakapilEntity.this.getTargetItem()) != null && !item.m_213877_()) {
                JakapilEntity.this.m_21008_(InteractionHand.MAIN_HAND, item.m_32055_().m_41777_());
                if (JakapilEntity.this.hunger != null) {
                    JakapilEntity.this.hunger.tryEatItem(item.m_32055_());
                }
                JakapilEntity.this.m_9236_().m_247517_(null, JakapilEntity.this.m_20183_(), SoundEvents.f_11912_, SoundSource.MASTER);
                JakapilEntity.this.setTargetItem(null);
            }
            if (tick >= 8 && tick <= 20 && JakapilEntity.this.m_9236_().f_46443_) {
                float dx = (JakapilEntity.this.m_217043_().m_188501_() - 0.5f) * 0.06f;
                float dz = (JakapilEntity.this.m_217043_().m_188501_() - 0.5f) * 0.06f;
                JakapilEntity.this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42579_)), JakapilEntity.this.mouthPos.f_82479_, JakapilEntity.this.mouthPos.f_82480_ + (double)0.1f, JakapilEntity.this.mouthPos.f_82481_, (double)dx, 0.0, (double)dz);
            }
        }
    });
    public final AnimData attackData = new AnimData(JakapilAdultAnimation.ATTACK);
    public BaseAnimation attackAnim = new SimpleAnimation("attack", this.attackData, Loop.ONCE, 0, 0.4326f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            LivingEntity target;
            if (tick == 3 && !JakapilEntity.this.m_9236_().f_46443_ && (target = JakapilEntity.this.m_5448_()) != null && JakapilEntity.this.m_20270_((Entity)target) <= 2.0f) {
                JakapilEntity.this.m_7327_((Entity)target);
            }
        }
    });
    public final AnimData tailAttackData = new AnimData(JakapilAdultAnimation.TAIL_ATTACK);
    public BaseAnimation tailAttackAnim = new SimpleAnimation("tailAttack", this.tailAttackData, Loop.ONCE, 0, 0.5f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            float spin = -360.0f * ((float)tick / (float)anim.getDuration());
            float angle = (float)Math.toRadians(JakapilEntity.this.m_146908_() + spin);
            Vec3 tailPos = JakapilEntity.this.m_20182_().m_82520_(Math.cos(angle) * 1.0, 0.5, Math.sin(angle) * 1.0);
            if (!JakapilEntity.this.m_9236_().f_46443_) {
                Vec3 forward = new Vec3((double)Mth.m_14089_((float)angle), 0.0, (double)Mth.m_14031_((float)angle));
                AABB area = new AABB(tailPos, tailPos).m_82369_(forward.m_82490_(1.0)).m_82377_(0.5, 0.5, 0.5);
                JakapilEntity.this.m_9236_().m_6443_(LivingEntity.class, area, target -> target != JakapilEntity.this && target.getClass() != JakapilEntity.class && target.m_6084_() && !target.m_5833_() && JakapilEntity.this.m_6779_((LivingEntity)target) && !target.m_20147_()).forEach(target -> JakapilEntity.this.m_7327_((Entity)target));
            }
        }
    });
    public final AnimData threatData = new AnimData(JakapilAdultAnimation.THREAT);
    public BaseAnimation threatAnim = new SimpleAnimation("threat", this.threatData, Loop.ONCE, 0, 0.5f).addListener(new AnimationListener(){

        @Override
        public void onStart(@NotNull BaseAnimation anim) {
            THREATING.set((Entity)JakapilEntity.this, true);
        }

        @Override
        public void onEnd(@NotNull BaseAnimation anim) {
            if (!JakapilEntity.this.canThreat()) {
                JakapilEntity.this.getAnimator().play(JakapilEntity.this.unthreatAnim);
            }
        }
    });
    public final AnimData threatingData = new AnimData(JakapilAdultAnimation.THREATING);
    public BaseAnimation threatingAnim = new SimpleAnimation("threating", this.threatingData, Loop.CYCLE, 1, 0.5f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return THREATING.get((Entity)JakapilEntity.this) != false && JakapilEntity.this.canThreat();
        }
    }).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            if (JakapilEntity.this.f_19797_ % 10 == 0 && !JakapilEntity.this.m_9236_().f_46443_) {
                AABB area = JakapilEntity.this.m_20191_().m_82400_(20.0);
                JakapilEntity.this.m_9236_().m_6443_(Mob.class, area, mob -> mob.getClass() != JakapilEntity.class && mob.m_6084_()).forEach(mob -> {
                    mob.m_6710_(null);
                    mob.m_6703_(null);
                    IEntityData.get((Entity)mob).m_128405_("JakapilFear", 100);
                });
            }
        }

        @Override
        public void onEnd(@NotNull BaseAnimation anim) {
            JakapilEntity.this.getAnimator().play(JakapilEntity.this.unthreatAnim);
        }
    });
    public final AnimData unthreatData = new AnimData(JakapilAdultAnimation.UNTHREAT);
    public BaseAnimation unthreatAnim = new SimpleAnimation("unthreat", this.unthreatData, Loop.ONCE, 0, 0.5f).addListener(new AnimationListener(){

        @Override
        public void onEnd(@NotNull BaseAnimation anim) {
            THREATING.set((Entity)JakapilEntity.this, false);
        }
    });

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new EatDroppedItemGoal(this, 1.0f, true, 0.5f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, true){

            protected void m_6739_(@NotNull LivingEntity enemy, double dist) {
                if (dist <= this.m_6639_(enemy) && !JakapilEntity.this.getAnimator().isAnyPlaying(JakapilEntity.this.attackAnim)) {
                    JakapilEntity.this.getAnimator().play(JakapilEntity.this.attackAnim);
                }
            }
        });
    }

    public JakapilEntity(@NotNull EntityType<? extends TamableAnimal> type, @NotNull Level level) {
        super(type, level);
        this.f_21364_ = 1;
        this.m_7105_(false);
        this.m_274367_(1.0f);
        this.roar = new RoarController<JakapilEntity>(this, null);
        this.sleepAnims = this.getSleepAnimations();
        this.sleep = this.createSleep();
        this.hunger = this.createHunger();
        this.f_21365_ = new LookControl((Mob)this){

            public void m_8128_() {
                if (!JakapilEntity.this.getAnimator().isPlaying(JakapilEntity.this.tailAttackAnim.getName())) {
                    super.m_8128_();
                }
            }
        };
    }

    @Override
    public void addTags(@NotNull TagBuilder builder) {
        builder.add(THREATING);
    }

    @Override
    @Nullable
    public SleepAnims getSleepAnimations() {
        return new SleepAnims(this.sitAnim, this.restAnim, this.sleepAnim, this.asleepAnim, this.wakeUpAnim, this.upAnim);
    }

    @Override
    public void initAnimations() {
        this.getAnimator().register(this.idleAnim, this.sitAnim, this.restAnim, this.upAnim, this.wakeUpAnim, this.asleepAnim, this.sleepAnim, this.eatAnim, this.attackAnim, this.tailAttackAnim, this.threatAnim, this.threatingAnim, this.unthreatAnim);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return WaterAnimal.m_21183_().m_22268_(Attributes.f_22276_, 17.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.5f, (float)0.4f);
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setHunger(100);
            this.setupAnimationStates();
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_20069_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.3f);
        } else if (this.m_20069_() && this.m_20142_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.5);
        } else if (this.m_20142_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.4f);
        } else if (this.m_6162_()) {
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.3f);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.2f);
        }
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.AMBER_MONSTROSITIES_DIET_ITEMS);
    }

    public boolean canThreat() {
        AABB area = this.m_20191_().m_82400_(20.0);
        return !this.m_9236_().m_6443_(Mob.class, area, mob -> !(mob instanceof JakapilEntity) && mob.m_6084_()).isEmpty();
    }

    @Override
    public int getAnimationLengthInTicks(BaseAnimalPose sleepPose) {
        return 0;
    }

    @Override
    public void onItemEat(@NotNull ItemEntity item, @NotNull ItemStack eatedStack) {
        this.getAnimator().play(this.eatAnim);
    }

    @Override
    @Nullable
    public ItemEntity getTargetItem() {
        return this.targetItem;
    }

    @Override
    public void setTargetItem(@Nullable ItemEntity item) {
        this.targetItem = item;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimator().isAnyPlaying(this.eatAnim, this.restAnim, this.sleepAnim, this.attackAnim);
    }
}

