/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.client.entity.animation.adult.LizamberAdultAnimations;
import net.reaper.ancientnature.client.entity.animation.baby.LizamberBabyAnimations;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.DodoEntity;
import net.reaper.ancientnature.common.entity.ThylacineEntity;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.entity.ai.hunger.IEatable;
import net.reaper.ancientnature.common.entity.ai.roar.RoarController;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepAnims;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.goals.ConsumeItemFromGroundGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LizamberEntity
extends BaseSleepingAnimal<LizamberEntity>
implements IEatable {
    public float tailRot;
    public float prevTailRot;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 mouthPos = Vec3.f_82478_;
    @Nullable
    public ItemEntity targetItem = null;
    public final AnimData idleData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.IDLE : LizamberAdultAnimations.IDLE);
    public BaseAnimation idleAnim = new SimpleAnimation("idle", this.idleData, Loop.CYCLE, 2, 4.6512f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return !LizamberEntity.this.isRest() && !LizamberEntity.this.isSleep() && !LizamberEntity.this.isRoaring();
        }
    });
    public final AnimData sitData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.DOWN : LizamberAdultAnimations.DOWN);
    public BaseAnimation sitAnim = new SimpleAnimation("sit", this.sitData, Loop.ONCE, 0, 1.0f);
    public final AnimData restData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.REST : LizamberAdultAnimations.REST);
    public BaseAnimation restAnim = new SimpleAnimation("rest", this.restData, Loop.CYCLE, 1, 2.0f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return LizamberEntity.this.isRest() && !LizamberEntity.this.isSleep() && !LizamberEntity.this.isRoaring();
        }
    });
    public final AnimData roarData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.ROAR : LizamberAdultAnimations.ROAR);
    public BaseAnimation roarAnim = new SimpleAnimation("roar", this.roarData, Loop.ONCE, 1, 1.25f).setCanInterrupt(false).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return LizamberEntity.this.isRoaring();
        }
    });
    public final AnimData upData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.UP : LizamberAdultAnimations.UP);
    public BaseAnimation upAnim = new SimpleAnimation("up", this.upData, Loop.ONCE, 0, 1.0f);
    public final AnimData wakeUpData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.WAKE_UP : LizamberAdultAnimations.WAKE_UP);
    public BaseAnimation wakeUpAnim = new SimpleAnimation("wakeUp", this.wakeUpData, Loop.ONCE, 0, 1.0f);
    public final AnimData asleepData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.ASLEEP : LizamberAdultAnimations.ASLEEP);
    public BaseAnimation asleepAnim = new SimpleAnimation("asleep", this.asleepData, Loop.ONCE, 0, 1.0f);
    public final AnimData sleepData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.SLEEPING : LizamberAdultAnimations.SLEEPING);
    public BaseAnimation sleepAnim = new SimpleAnimation("sleep", this.sleepData, Loop.CYCLE, 1, 2.0f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return LizamberEntity.this.isSleep();
        }
    });
    public final AnimData eatData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.EAT : LizamberAdultAnimations.EAT);
    public BaseAnimation eatAnim = new SimpleAnimation("eat", this.eatData, Loop.ONCE, 0, 1.75f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            ItemEntity item;
            if (tick == 18 && !LizamberEntity.this.m_9236_().f_46443_ && (item = LizamberEntity.this.getTargetItem()) != null && !item.m_213877_()) {
                LizamberEntity.this.m_21008_(InteractionHand.MAIN_HAND, item.m_32055_().m_41777_());
                if (LizamberEntity.this.hunger != null) {
                    LizamberEntity.this.hunger.tryEatItem(item.m_32055_());
                }
                LizamberEntity.this.m_9236_().m_247517_(null, LizamberEntity.this.m_20183_(), SoundEvents.f_11912_, SoundSource.MASTER);
                LizamberEntity.this.setTargetItem(null);
            }
            if (tick >= 8 && tick <= 20 && LizamberEntity.this.m_9236_().f_46443_) {
                float dx = (LizamberEntity.this.m_217043_().m_188501_() - 0.5f) * 0.06f;
                float dz = (LizamberEntity.this.m_217043_().m_188501_() - 0.5f) * 0.06f;
                LizamberEntity.this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42579_)), LizamberEntity.this.mouthPos.f_82479_, LizamberEntity.this.mouthPos.f_82480_ + (double)0.1f, LizamberEntity.this.mouthPos.f_82481_, (double)dx, 0.0, (double)dz);
            }
        }
    });
    public final AnimData attackData = new AnimData(this.m_6162_() ? LizamberBabyAnimations.ATTACK : LizamberAdultAnimations.ATTACK);
    public BaseAnimation attackAnim = new SimpleAnimation("attack", this.attackData, Loop.ONCE, 0, 0.4975f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            LivingEntity target;
            if (tick == 3 && !LizamberEntity.this.m_9236_().f_46443_ && (target = LizamberEntity.this.m_5448_()) != null && LizamberEntity.this.m_20270_((Entity)target) <= 2.0f) {
                LizamberEntity.this.m_7327_((Entity)target);
            }
        }
    });

    public LizamberEntity(EntityType<? extends BaseSleepingAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 4;
        this.sleepAnims = this.getSleepAnimations();
        this.sleep = this.createSleep();
        this.hunger = this.createHunger();
        this.roar = new RoarController<LizamberEntity>(this, this.roarAnim);
        this.f_21344_ = new GroundPathNavigation((Mob)this, pLevel);
        this.f_21342_ = new MoveControl((Mob)this);
        this.m_7105_(false);
        this.m_274367_(1.0f);
    }

    @Override
    public void onItemEat(@NotNull ItemEntity item, @NotNull ItemStack stolenStack) {
        this.getAnimator().play(this.eatAnim);
    }

    @Override
    @Nullable
    public ItemEntity getTargetItem() {
        return this.targetItem;
    }

    @Override
    public void setTargetItem(@Nullable ItemEntity item) {
        this.targetItem = item;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimator().isAnyPlaying(this.eatAnim, this.restAnim, this.sleepAnim, this.attackAnim, this.wakeUpAnim, this.roarAnim);
    }

    @Override
    @Nullable
    public SleepAnims getSleepAnimations() {
        return new SleepAnims(this.sitAnim, this.asleepAnim, this.restAnim, this.sleepAnim, this.wakeUpAnim, this.upAnim);
    }

    @Override
    public void initAnimations() {
        this.getAnimator().register(this.idleAnim, this.sitAnim, this.restAnim, this.upAnim, this.wakeUpAnim, this.asleepAnim, this.sleepAnim, this.eatAnim, this.attackAnim, this.roarAnim);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.5f, (float)0.4f);
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_6858_(this.m_5448_() != null);
            this.setupAnimationStates();
            this.setHunger(100);
        }
        if (this.isEating() && this.m_217043_().m_188503_(10) == 0) {
            this.playEatSound();
        }
        if (this.isAttacking() && this.m_217043_().m_188503_(10) == 0) {
            this.playAttackSound();
        }
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_20069_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)0.2f);
        } else if (this.m_20069_() && this.m_20142_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)0.4f);
        } else if (this.m_20142_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.25);
        } else if (this.m_6162_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)0.2f);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.2);
        }
        if (this.isEating() && this.m_217043_().m_188503_(10) == 0) {
            this.playEatSound();
        }
        if (this.isAttacking() && this.m_217043_().m_188503_(10) == 0) {
            this.playAttackSound();
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true){

            protected void m_6739_(@NotNull LivingEntity enemy, double dist) {
                if (dist <= this.m_6639_(enemy) && !LizamberEntity.this.getAnimator().isAnyPlaying(LizamberEntity.this.attackAnim)) {
                    LizamberEntity.this.getAnimator().play(LizamberEntity.this.attackAnim);
                }
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new ConsumeItemFromGroundGoal(this, 1.0, true, this.getEatAnimationConsumeDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.EAT)));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<Sheep>((Mob)this, Sheep.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(20.0, 6.0, 20.0);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<Cow>((Mob)this, Cow.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(20.0, 6.0, 20.0);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<DodoEntity>((Mob)this, DodoEntity.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(20.0, 6.0, 20.0);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<ThylacineEntity>((Mob)this, ThylacineEntity.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(20.0, 6.0, 20.0);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(20.0, 6.0, 20.0);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<Chicken>((Mob)this, Chicken.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(20.0, 6.0, 20.0);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<Wolf>((Mob)this, Wolf.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(20.0, 6.0, 20.0);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<Villager>((Mob)this, Villager.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(20.0, 6.0, 20.0);
            }
        });
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.AMBER_MONSTROSITIES_DIET_ITEMS);
    }

    @Override
    public int getAttackAnimationDamageDelay() {
        return 9;
    }

    @Override
    public int getEatAnimationConsumeDelay() {
        return 9;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ANSounds.LIZAMBER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ANSounds.LIZAMBER_DEATH.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource pDamageSource) {
        return (SoundEvent)ANSounds.LIZAMBER_HURT.get();
    }

    protected void playEatSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.LIZAMBER_EAT.get(), SoundSource.NEUTRAL, this.m_6121_(), 0.4f);
    }

    @Override
    public void playRoarSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.LIZAMBER_ROAR.get(), SoundSource.NEUTRAL, this.m_6121_(), 0.4f);
    }

    protected void playAttackSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.LIZAMBER_ATTACK.get(), SoundSource.HOSTILE, this.m_6121_(), 0.4f);
    }

    protected float m_6121_() {
        return 0.3f;
    }

    public LizamberEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (LizamberEntity)((EntityType)ANEntities.LIZAMBER.get()).m_20615_((Level)pLevel);
    }

    @Override
    public int getAnimationLengthInTicks(BaseAnimalPose sleepPose) {
        return 0;
    }
}

