/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.api.common.tag.EntityTag;
import net.reaper.ancientnature.api.common.tag.TagBuilder;
import net.reaper.ancientnature.api.common.tag.TagType;
import net.reaper.ancientnature.api.io.input.ActionType;
import net.reaper.ancientnature.api.io.input.InputKey;
import net.reaper.ancientnature.api.io.input.InputableEntity;
import net.reaper.ancientnature.api.io.input.KeyPressType;
import net.reaper.ancientnature.client.entity.animation.adult.ParanogmiusAnimation;
import net.reaper.ancientnature.common.base.BucketableWaterAnimal;
import net.reaper.ancientnature.common.entity.ai.properties.SpeedHandler;
import net.reaper.ancientnature.common.util.EntityUtils;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.core.util.ANUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParanogmiusEntity
extends BucketableWaterAnimal<ParanogmiusEntity>
implements InputableEntity,
Bucketable {
    public static final EntityTag<Integer> RIDEABLE_TICKS = new EntityTag(ParanogmiusEntity.class, "RideableTicks", TagType.INTEGER);
    public static final EntityDataAccessor<Optional<UUID>> TRUSTED_ENTITY_UUID = SynchedEntityData.m_135353_(ParanogmiusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public int speedBoost;
    private int exitWaterTicks;
    private int postOutWaterTicks;
    private float jumpStrength = 0.0f;
    private float motionScale = 0.0f;
    public final SpeedHandler<ParanogmiusEntity> speed = new SpeedHandler<ParanogmiusEntity>().add(0.05f, Entity::m_20142_).add(0.025f, new Predicate<ParanogmiusEntity>(){

        @Override
        public boolean test(ParanogmiusEntity entity) {
            return entity.speedBoost > 0;
        }
    });
    private final AnimData flopData = new AnimData(ParanogmiusAnimation.LAND);
    public BaseAnimation flopAnim = this.createFlopAnim(this.flopData, 0.4f);
    private final AnimData attackData = new AnimData(ParanogmiusAnimation.ATTACK);
    public BaseAnimation attackAnim = new SimpleAnimation("attack", this.attackData, Loop.ONCE, 0, 0.48f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            if (!ParanogmiusEntity.this.m_9236_().f_46443_ && tick == 4) {
                if (ParanogmiusEntity.this.m_146895_() != null) {
                    Vec3 origin = ParanogmiusEntity.this.m_20182_().m_82520_(0.0, (double)ParanogmiusEntity.this.m_20206_() * 0.5, 0.0);
                    AABB area = new AABB(origin, origin).m_82369_(ParanogmiusEntity.this.m_20154_().m_82490_((double)1.7f)).m_82377_(1.0, 0.5, 1.0);
                    ParanogmiusEntity.this.m_9236_().m_6443_(LivingEntity.class, area, target -> target != ParanogmiusEntity.this && target.getClass() != ParanogmiusEntity.class && target.m_6084_() && !target.m_5833_() && ParanogmiusEntity.this.m_6779_((LivingEntity)target)).forEach(target -> ParanogmiusEntity.this.m_7327_((Entity)target));
                } else {
                    LivingEntity target2 = ParanogmiusEntity.this.m_5448_();
                    if (target2 != null && ParanogmiusEntity.this.m_20270_((Entity)target2) <= 2.0f) {
                        ParanogmiusEntity.this.m_7327_((Entity)target2);
                    }
                }
            }
        }
    });

    public ParanogmiusEntity(@NotNull EntityType<? extends TamableAnimal> type, @NotNull Level level) {
        super(type, level, new ItemStack((ItemLike)ANItems.PARANOGMIUS_BUCKET.get()));
    }

    @Override
    public void addTags(@NotNull TagBuilder builder) {
        super.addTags(builder);
        builder.add(RIDEABLE_TICKS);
    }

    @Override
    protected void handleAirSupply(int pAirSupply) {
    }

    @Override
    public void initAnimations() {
        this.getAnimator().register(this.flopAnim, this.attackAnim);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRUSTED_ENTITY_UUID, Optional.empty());
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        try {
            Entity trusted = this.getTrustedEntity();
            if (trusted != null) {
                tag.m_128362_("TrustedEntity", trusted.m_20148_());
            }
        }
        catch (Exception e) {
            this.setTrustedEntity((Entity)null);
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("TrustedEntity")) {
            this.setTrustedEntity(tag.m_128342_("TrustedEntity"));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            int ticks = RIDEABLE_TICKS.get((Entity)this);
            if (ticks > 0) {
                RIDEABLE_TICKS.set((Entity)this, ticks - 1);
            }
            if (ticks == 0) {
                this.m_19877_();
            }
        }
        if (this.m_20142_()) {
            this.setStamina(Math.max(0.0f, this.getStamina() - 0.25f));
        } else {
            this.setStamina(Math.min(100.0f, this.getStamina() + 0.125f));
        }
        if (this.m_20142_() && this.getStamina() <= 0.0f) {
            this.m_6858_(false);
        }
        if (this.m_20069_()) {
            this.motionScale = this.m_20142_() ? 0.73f : 0.33f;
            this.jumpStrength = this.m_20142_() ? 0.43f : 0.2f;
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        boolean isClient = this.m_9236_().f_46443_;
        if (!this.m_6162_()) {
            if (stack.m_150930_(Items.f_42527_) && this.getTrustedEntity() == null) {
                if (!isClient) {
                    this.m_142075_(player, hand, stack);
                    this.setTrustedEntity((Entity)player);
                    RIDEABLE_TICKS.set((Entity)this, 1200);
                }
                return InteractionResult.m_19078_((boolean)isClient);
            }
            Entity trusted = this.getTrustedEntity();
            if (trusted != null && trusted.m_20148_().equals(player.m_20148_()) && this.m_7310_((Entity)this)) {
                if (!isClient) {
                    ANUtils.Entities.trySit((Entity)this, player);
                    this.setTrustedEntity((Entity)null);
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean isActionDenied(@NotNull ActionType type) {
        return type == ActionType.ATTACK || type == ActionType.USE_ITEM;
    }

    @Override
    public void handleInput(@NotNull InputKey key, @NotNull KeyPressType type) {
        if (type == KeyPressType.RELEASED && key == InputKey.MOUSE_LEFT) {
            this.getAnimator().play(this.attackAnim);
        }
        if (key == InputKey.CTRL) {
            switch (type) {
                case HOLD: {
                    if (this.m_20142_() || !(this.getStamina() >= 10.0f)) break;
                    this.m_6858_(true);
                    break;
                }
                case RELEASED: {
                    this.m_6858_(false);
                }
            }
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        Player player;
        Entity entity = this.m_146895_();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player rider, @NotNull Vec3 travelVec) {
        return this.m_20069_() ? new Vec3((double)(rider.f_20900_ * 0.35f), 0.0, (double)(rider.f_20902_ * 0.8f * (rider.f_20902_ < 0.0f ? 0.0f : 1.0f))) : Vec3.f_82478_;
    }

    protected float m_245547_(@NotNull Player rider) {
        return this.speed.getTotal(this, 0.05f);
    }

    @Override
    protected void onEnterWater() {
    }

    @Override
    protected void onExitWater() {
    }

    protected void m_274498_(@NotNull Player rider, @NotNull Vec3 pVec3) {
        super.m_274498_(rider, pVec3);
        boolean isMovingByRider = rider.f_20900_ != 0.0f || rider.f_20902_ != 0.0f;
        Vec3 delta = this.m_20184_();
        float targetPitch = Mth.m_14189_((float)0.25f, (float)this.m_146909_(), (float)rider.m_146909_());
        double yDirection = Vec3.m_82498_((float)(targetPitch / 1.7f), (float)this.m_146909_()).f_82480_;
        if (isMovingByRider) {
            EntityUtils.smoothVehicleYawToRider(rider, (LivingEntity)this, 0.17f, 0.13f);
        }
        this.m_146926_(this.exitWaterTicks < 25 ? Mth.m_14189_((float)0.09f, (float)this.m_146909_(), (float)90.0f) : this.m_146909_());
        if (this.m_20069_()) {
            this.postOutWaterTicks = Math.max(--this.postOutWaterTicks, 0);
            this.exitWaterTicks = 25;
            if (this.getStamina() <= 10.0f) {
                BlockPos abovePlayerPos = new BlockPos((int)this.m_20185_(), (int)(this.m_20186_() + 1.0), (int)this.m_20189_());
                if (this.m_9236_().m_8055_(abovePlayerPos).m_60795_()) {
                    if (targetPitch < this.m_146909_()) {
                        targetPitch = this.m_146909_();
                    }
                    if (yDirection > 0.0) {
                        yDirection = 0.0;
                    }
                }
            }
            if (Mth.m_14045_((int)this.postOutWaterTicks, (int)1, (int)8) == this.postOutWaterTicks) {
                this.m_146926_(Mth.m_14189_((float)0.16f, (float)this.m_146909_(), (float)rider.m_146909_()));
            }
            if (isMovingByRider) {
                this.m_146926_(targetPitch);
                if (this.postOutWaterTicks <= 0) {
                    this.m_20334_(delta.f_82479_, yDirection, delta.f_82481_);
                }
            }
        } else {
            this.postOutWaterTicks = 10;
            if (this.exitWaterTicks > 16) {
                Vec3 delta2 = this.m_20184_().m_82490_((double)0.1f);
                --this.exitWaterTicks;
                Vec3 viewVector = this.m_20252_(0.0f).m_82490_((double)this.motionScale);
                this.m_20334_(viewVector.f_82479_ + delta2.f_82479_, this.jumpStrength, viewVector.f_82481_ + delta2.f_82481_);
            }
            if (this.m_20096_() || this.f_19863_) {
                EntityUtils.removeRider(this, rider);
            }
        }
    }

    @Nullable
    public Entity getTrustedEntity() {
        Entity entity;
        UUID uuid;
        if (!this.m_9236_().f_46443_ && (uuid = (UUID)((Optional)this.f_19804_.m_135370_(TRUSTED_ENTITY_UUID)).orElse(null)) != null && (entity = ((ServerLevel)this.m_9236_()).m_8791_(uuid)) != null && !entity.m_213877_()) {
            return entity;
        }
        return null;
    }

    public void setTrustedEntity(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(TRUSTED_ENTITY_UUID, Optional.ofNullable(uuid));
    }

    public void setTrustedEntity(@Nullable Entity entity) {
        if (entity != null) {
            this.setTrustedEntity(entity.m_20148_());
        } else {
            this.setTrustedEntity((UUID)null);
        }
    }
}

