/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IPlayCondition;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.api.common.tag.IHasEntityTags;
import net.reaper.ancientnature.api.common.tag.TagBuilder;
import net.reaper.ancientnature.client.entity.animation.adult.ThylacineAdultAnimation;
import net.reaper.ancientnature.client.entity.animation.baby.ThylacineBabyAnimation;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.DodoEntity;
import net.reaper.ancientnature.common.entity.WormEntity;
import net.reaper.ancientnature.common.entity.ai.control.SmoothBodyRotationControl;
import net.reaper.ancientnature.common.entity.ai.hunger.IEatable;
import net.reaper.ancientnature.common.entity.ai.sleep.SleepAnims;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.goals.ANFollowOwnerGoal;
import net.reaper.ancientnature.common.goals.ConsumeItemFromGroundGoal;
import net.reaper.ancientnature.common.goals.DifferentGenderBreedGoal;
import net.reaper.ancientnature.common.goals.GroupHuntingGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.core.registry.ANSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThylacineEntity
extends BaseSleepingAnimal<ThylacineEntity>
implements IEatable,
IHasEntityTags {
    private static final EntityDataAccessor<ItemStack> IS_SEARCHING_FOR = SynchedEntityData.m_135353_(ThylacineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public float tailRot;
    public float prevTailRot;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 mouthPos = Vec3.f_82478_;
    @Nullable
    public ItemEntity targetItem = null;
    public final AnimData idleData = new AnimData(this.m_6162_() ? ThylacineBabyAnimation.IDLE : ThylacineAdultAnimation.IDLE);
    public BaseAnimation idleAnim = new SimpleAnimation("idle", this.idleData, Loop.CYCLE, 2, 3.0f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return !ThylacineEntity.this.isRest() && !ThylacineEntity.this.isSleep();
        }
    });
    public final AnimData sitData = new AnimData(this.m_6162_() ? ThylacineBabyAnimation.SIT : ThylacineAdultAnimation.SIT);
    public BaseAnimation sitAnim = new SimpleAnimation("sit", this.sitData, Loop.ONCE, 0, 1.0f);
    public final AnimData restData = new AnimData(this.m_6162_() ? ThylacineBabyAnimation.REST : ThylacineAdultAnimation.REST);
    public BaseAnimation restAnim = new SimpleAnimation("rest", this.restData, Loop.CYCLE, 1, 2.0f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return ThylacineEntity.this.isRest() && !ThylacineEntity.this.isSleep();
        }
    });
    public final AnimData upData = new AnimData(this.m_6162_() ? ThylacineBabyAnimation.UP : ThylacineAdultAnimation.UP);
    public BaseAnimation upAnim = new SimpleAnimation("up", this.upData, Loop.ONCE, 0, 1.0f);
    public final AnimData wakeUpData = new AnimData(this.m_6162_() ? ThylacineBabyAnimation.WAKE_UP : ThylacineAdultAnimation.WAKE_UP);
    public BaseAnimation wakeUpAnim = new SimpleAnimation("wakeUp", this.wakeUpData, Loop.ONCE, 0, 1.0f);
    public final AnimData asleepData = new AnimData(this.m_6162_() ? ThylacineBabyAnimation.FALL_ASLEEP : ThylacineAdultAnimation.FALL_ASLEEP);
    public BaseAnimation asleepAnim = new SimpleAnimation("asleep", this.asleepData, Loop.ONCE, 0, 1.0f);
    public final AnimData sleepData = new AnimData(this.m_6162_() ? ThylacineBabyAnimation.SLEEP : ThylacineAdultAnimation.SLEEP);
    public BaseAnimation sleepAnim = new SimpleAnimation("sleep", this.sleepData, Loop.CYCLE, 1, 2.0f).setCanInterrupt(true).setPlayCondition(new IPlayCondition(){

        @Override
        public boolean canPlay(@NotNull BaseAnimation anim) {
            return ThylacineEntity.this.isSleep();
        }
    });
    public final AnimData eatData = new AnimData(this.m_6162_() ? ThylacineBabyAnimation.EAT : ThylacineAdultAnimation.EAT);
    public BaseAnimation eatAnim = new SimpleAnimation("eat", this.eatData, Loop.ONCE, 0, 1.75f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            ItemEntity item;
            if (tick == 18 && !ThylacineEntity.this.m_9236_().f_46443_ && (item = ThylacineEntity.this.getTargetItem()) != null && !item.m_213877_()) {
                ThylacineEntity.this.m_21008_(InteractionHand.MAIN_HAND, item.m_32055_().m_41777_());
                if (ThylacineEntity.this.hunger != null) {
                    ThylacineEntity.this.hunger.tryEatItem(item.m_32055_());
                }
                ThylacineEntity.this.m_9236_().m_247517_(null, ThylacineEntity.this.m_20183_(), SoundEvents.f_11912_, SoundSource.MASTER);
                ThylacineEntity.this.setTargetItem(null);
            }
            if (tick >= 8 && tick <= 20 && ThylacineEntity.this.m_9236_().f_46443_) {
                float dx = (ThylacineEntity.this.m_217043_().m_188501_() - 0.5f) * 0.06f;
                float dz = (ThylacineEntity.this.m_217043_().m_188501_() - 0.5f) * 0.06f;
                ThylacineEntity.this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42579_)), ThylacineEntity.this.mouthPos.f_82479_, ThylacineEntity.this.mouthPos.f_82480_ + (double)0.1f, ThylacineEntity.this.mouthPos.f_82481_, (double)dx, 0.0, (double)dz);
            }
        }
    });
    public final AnimData attackData = new AnimData(this.m_6162_() ? ThylacineBabyAnimation.ATTACK : ThylacineAdultAnimation.ATTACK);
    public BaseAnimation attackAnim = new SimpleAnimation("attack", this.attackData, Loop.ONCE, 0, 0.4975f).addListener(new AnimationListener(){

        @Override
        public void onTick(@NotNull BaseAnimation anim, int tick) {
            LivingEntity target;
            if (tick == 3 && !ThylacineEntity.this.m_9236_().f_46443_ && (target = ThylacineEntity.this.m_5448_()) != null && ThylacineEntity.this.m_20270_((Entity)target) <= 2.0f) {
                ThylacineEntity.this.m_7327_((Entity)target);
            }
        }
    });

    public ThylacineEntity(EntityType<? extends BaseSleepingAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 2;
        this.sleepAnims = this.getSleepAnimations();
        this.sleep = this.createSleep();
        this.hunger = this.createHunger();
        this.f_21344_ = new GroundPathNavigation((Mob)this, pLevel);
        this.f_21342_ = new MoveControl((Mob)this);
        this.m_7105_(true);
        this.m_274367_(1.0f);
    }

    @Override
    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmoothBodyRotationControl<ThylacineEntity>(this);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.6f, (float)0.5f);
    }

    @Override
    public void onItemEat(@NotNull ItemEntity item, @NotNull ItemStack stolenStack) {
        this.getAnimator().play(this.eatAnim);
    }

    @Override
    @Nullable
    public ItemEntity getTargetItem() {
        return this.targetItem;
    }

    @Override
    public void setTargetItem(@Nullable ItemEntity item) {
        this.targetItem = item;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getAnimator().isAnyPlaying(this.eatAnim, this.restAnim, this.sleepAnim, this.attackAnim, this.wakeUpAnim);
    }

    @Override
    @Nullable
    public SleepAnims getSleepAnimations() {
        return new SleepAnims(this.sitAnim, this.restAnim, this.sleepAnim, this.asleepAnim, this.wakeUpAnim, this.upAnim);
    }

    @Override
    public void initAnimations() {
        this.getAnimator().register(this.idleAnim, this.sitAnim, this.restAnim, this.upAnim, this.wakeUpAnim, this.asleepAnim, this.sleepAnim, this.eatAnim, this.attackAnim);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true){

            protected void m_6739_(@NotNull LivingEntity enemy, double dist) {
                if (dist <= this.m_6639_(enemy) && !ThylacineEntity.this.getAnimator().isAnyPlaying(ThylacineEntity.this.attackAnim)) {
                    ThylacineEntity.this.getAnimator().play(ThylacineEntity.this.attackAnim);
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 14.0f, 1.6, 2.0, this::shouldAvoidPlayer));
        this.f_21345_.m_25352_(2, (Goal)new DifferentGenderBreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, entity -> !this.m_20072_() && !this.m_6162_() && this.m_5803_(), 300));
        this.f_21345_.m_25352_(3, (Goal)new ConsumeItemFromGroundGoal(this, 1.0, true, this.getEatAnimationConsumeDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.EAT)));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(4, new GroupHuntingGoal<Chicken>((Mob)this, Chicken.class, true, 1, 10.0, 10));
        this.f_21346_.m_25352_(4, new GroupHuntingGoal<Rabbit>((Mob)this, Rabbit.class, true, 1, 10.0, 10));
        this.f_21346_.m_25352_(4, new GroupHuntingGoal<DodoEntity>((Mob)this, DodoEntity.class, true, 1, 10.0, 10));
        this.f_21346_.m_25352_(4, new GroupHuntingGoal<Sheep>((Mob)this, Sheep.class, true, 2, 13.0, 10));
        this.f_21346_.m_25352_(4, new GroupHuntingGoal<Cow>((Mob)this, Cow.class, true, 3, 18.0, 18));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<WormEntity>((Mob)this, WormEntity.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(10.0, 4.0, 10.0);
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new ANFollowOwnerGoal(this, 1.0, 1.75, 10.0f, 15.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    private boolean shouldAvoidPlayer(LivingEntity player) {
        Vec3 mobToPlayer;
        if (this.m_21824_()) {
            return false;
        }
        if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ANItems.TAMERS_HAT.get()) {
            return false;
        }
        Vec3 mobForward = this.m_20252_(1.0f).m_82541_();
        double dotProduct = mobForward.m_82526_(mobToPlayer = player.m_20182_().m_82546_(this.m_20182_()).m_82541_());
        return dotProduct >= 0.0;
    }

    private boolean isFoodItem(Item item) {
        return item == Items.f_42698_ || item == ANItems.COOKED_DODO.get() || item == Items.f_42580_;
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        if (heldItem.m_150930_(Items.f_42574_) && !this.m_6162_() && !this.m_5912_()) {
            ItemEntity itementity = this.m_20000_((ItemLike)ANItems.THYLACINE_FUR.get(), 1);
            pPlayer.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            if (itementity != null) {
                itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
                if (!this.m_5803_() || pPlayer.m_6844_(EquipmentSlot.HEAD).m_41720_() != ANItems.TAMERS_HAT.get()) {
                    this.m_21561_(true);
                    this.m_6710_((LivingEntity)pPlayer);
                } else if (this.m_5803_() || pPlayer.m_6844_(EquipmentSlot.HEAD).m_41720_() == ANItems.TAMERS_HAT.get()) {
                    this.m_21561_(false);
                }
            }
        }
        if (!this.m_9236_().m_5776_() && pHand == InteractionHand.MAIN_HAND && this.m_21824_() && !heldItem.m_41619_() && !this.isFoodItem(heldItem.m_41720_())) {
            Item item = heldItem.m_41720_();
            Holder biomeHolder = this.m_9236_().m_204166_(this.m_20183_());
            if (item.equals(this.getIsSearchingFor())) {
                this.f_19804_.m_135381_(IS_SEARCHING_FOR, (Object)ItemStack.f_41583_);
                pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.thylacine.stop_search")).m_7220_(item.m_41466_()), true);
                return InteractionResult.SUCCESS;
            }
            boolean canSearchItemInGeneral = this.canSearchForItemInGeneral(item);
            boolean canSearchInBiome = this.canSearchForItem(item, (Holder<Biome>)biomeHolder);
            if (canSearchInBiome) {
                this.setIsSearchingFor(item);
                pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.thylacine.search")).m_7220_(item.m_41466_()), true);
                return InteractionResult.SUCCESS;
            }
            if (canSearchItemInGeneral) {
                pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.thylacine.cant_search_biome")), true);
                return InteractionResult.FAIL;
            }
            pPlayer.m_5661_((Component)Component.m_237113_((String)this.m_5446_().getString()).m_7220_((Component)Component.m_237115_((String)"entity.thylacine.cant_search")), true);
            return InteractionResult.FAIL;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private boolean canSearchForItemInGeneral(Item item) {
        return item == Items.f_42417_ || item == Items.f_42413_ || item == Items.f_42451_ || item == Items.f_42780_ || item == Items.f_42398_ || item == Items.f_41870_ || item == Items.f_42403_ || item == Items.f_41909_ || item == Items.f_41982_ || item == Items.f_42401_ || item == Items.f_42500_;
    }

    private boolean canSearchForItem(Item item, Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_207609_)) {
            return item == Items.f_42780_ || item == Items.f_42398_;
        }
        if (biome.m_203656_(BiomeTags.f_207611_)) {
            return item == Items.f_41870_ || item == Items.f_42403_;
        }
        if (biome.m_203656_(Tags.Biomes.IS_DESERT)) {
            return item == Items.f_42403_ || item == Items.f_41909_ || item == Items.f_41982_;
        }
        return item == Items.f_42401_ || item == Items.f_42500_ || item == Items.f_42398_ || item == Items.f_42417_ || item == Items.f_42413_ || item == Items.f_42451_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ANSounds.THYLACINE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource pDamageSource) {
        return (SoundEvent)ANSounds.THYLACINE_HURT.get();
    }

    protected void playAwakeSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.THYLACINE_WAKE_UP.get(), SoundSource.NEUTRAL, this.m_6121_(), 1.0f);
    }

    protected void playEatSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.THYLACINE_EAT.get(), SoundSource.NEUTRAL, this.m_6121_(), 1.0f);
    }

    protected void playAttackSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.THYLACINE_ATTACK.get(), SoundSource.HOSTILE, this.m_6121_(), 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (!this.m_21824_()) {
                this.shouldAvoidPlayer((LivingEntity)this);
            }
            if (this.m_6162_()) {
                this.m_21561_(false);
                this.m_142391_();
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.m_6858_(this.m_5448_() != null);
            this.setHunger(100);
            this.setupAnimationStates();
        }
        if (this.isEating() && this.m_217043_().m_188503_(10) == 0) {
            this.playEatSound();
        }
        if (this.wakeUpAnimation.m_216984_()) {
            this.playAwakeSound();
        }
        if (this.isAttacking()) {
            this.playAttackSound();
        }
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pDimensions) {
        return this.m_6162_() ? pDimensions.f_20378_ * 0.5f : 0.4f;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ItemStack stack = new ItemStack((ItemLike)this.getIsSearchingFor());
        pCompound.m_128365_("isSearchingFor", (Tag)stack.m_41739_(new CompoundTag()));
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        CompoundTag itemStackTag = pCompound.m_128469_("isSearchingFor");
        ItemStack stack = ItemStack.m_41712_((CompoundTag)itemStackTag);
        if (!stack.m_41619_()) {
            this.setIsSearchingFor(stack.m_41720_());
        } else {
            this.f_19804_.m_135381_(IS_SEARCHING_FOR, (Object)ItemStack.f_41583_);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SEARCHING_FOR, (Object)ItemStack.f_41583_);
    }

    public Item getIsSearchingFor() {
        ItemStack stack = (ItemStack)this.f_19804_.m_135370_(IS_SEARCHING_FOR);
        return stack.m_41720_();
    }

    public void setIsSearchingFor(Item item) {
        this.f_19804_.m_135381_(IS_SEARCHING_FOR, (Object)new ItemStack((ItemLike)item));
    }

    @Override
    public int getEatAnimationConsumeDelay() {
        return 40;
    }

    @Override
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)ANEntities.THYLACINE.get()).m_20615_((Level)serverLevel);
    }

    @Override
    public int getAnimationLengthInTicks(BaseAnimalPose sleepPose) {
        return 0;
    }

    @Override
    public boolean canBeTamed() {
        Object player = null;
        TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26883_(12.0);
        List nearbyParents = this.m_9236_().m_45971_(ThylacineEntity.class, targetingConditions, (LivingEntity)this, this.m_20191_().m_82400_(12.0));
        AncientNature.LOGGER.info("list size: " + nearbyParents.size());
        for (ThylacineEntity parent : nearbyParents) {
            AncientNature.LOGGER.info("parent in range");
            if (parent.m_146764_() < 0) continue;
            return false;
        }
        AncientNature.LOGGER.info("can be tamed: " + this.m_6162_());
        return super.canBeTamed() && this.m_6162_() && player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ANItems.TAMERS_HAT.get();
    }

    @Override
    public int getGestationTime() {
        return 7200;
    }

    @Override
    public void addTags(@NotNull TagBuilder builder) {
    }
}

