/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.common.base.BaseRideableAnimal;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.ai.control.SmoothBodyRotationControl;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.entity.ai.roar.RoarController;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.goals.ANFollowOwnerGoal;
import net.reaper.ancientnature.common.goals.AttackGoal;
import net.reaper.ancientnature.common.goals.ConsumeItemFromGroundGoal;
import net.reaper.ancientnature.common.goals.DifferentGenderBreedGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.common.util.EntityUtils;
import net.reaper.ancientnature.common.util.misc.IShakeScreenOnStep;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TriceratopsEntity
extends BaseRideableAnimal<TriceratopsEntity>
implements IShakeScreenOnStep,
Saddleable {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(TriceratopsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(TriceratopsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float tailRot;
    public float prevTailRot;

    public TriceratopsEntity(EntityType<? extends BaseRideableAnimal> pEntityType, Level pLevel) {
        super((EntityType<? extends BaseSleepingAnimal>)pEntityType, pLevel);
        this.f_21364_ = 6;
        this.m_274367_(1.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (!TriceratopsEntity.this.m_5803_()) {
                    super.m_8126_();
                }
            }
        };
        this.roar = new RoarController<TriceratopsEntity>(this, null);
    }

    @Override
    @NotNull
    protected BodyRotationControl m_7560_() {
        SmoothBodyRotationControl<TriceratopsEntity> control = new SmoothBodyRotationControl<TriceratopsEntity>(this);
        control.bodyMax = 2.0f;
        return control;
    }

    public boolean m_7337_(Entity pEntity) {
        return pEntity.m_6084_();
    }

    public boolean m_5829_() {
        return !this.m_6162_() || !this.isRideable();
    }

    @Override
    public boolean m_6094_() {
        return this.m_6162_() || this.isRideable();
    }

    @Override
    protected EntityDimensions getSitBox() {
        return EntityDimensions.m_20395_((float)2.8f, (float)1.9f);
    }

    @Override
    protected EntityDimensions getBabySitBox() {
        return EntityDimensions.m_20395_((float)1.2f, (float)0.9f);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)1.2f, (float)1.2f);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this, 1.75, true, this.getAttackAnimationDamageDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.ATTACK)));
        this.f_21345_.m_25352_(2, (Goal)new DifferentGenderBreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, entity -> !this.m_20072_() && !this.m_6162_() && this.m_5803_(), 300));
        this.f_21345_.m_25352_(3, (Goal)new ConsumeItemFromGroundGoal(this, 1.0, true, this.getEatAnimationConsumeDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.EAT)));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new ANFollowOwnerGoal(this, 1.0, 1.75, 10.0f, 15.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (EntityUtils.isEntityMoving((Entity)this, 0.1f)) {
            if (this.m_20160_()) {
                this.m_6858_(EntityUtils.canSprintByPlayer((LivingEntity)this) && this.getStamina() > 0.0f);
            }
        } else {
            this.m_6858_(false);
        }
        if (this.m_20142_()) {
            if (this.f_19797_ % 3 == 0) {
                this.setStamina(this.getStamina() - 1.0f);
            }
        } else if (this.getStamina() < 100.0f && !this.isHungry() && this.f_19797_ % 5 == 0) {
            this.setTicksUntilHungry(this.getTicksUntilHungry() - 1);
            this.setStamina(Math.min(this.getStamina() + 0.5f, 100.0f));
        }
        if (this.getSmartPose() == BaseAnimalPose.ATTACK) {
            this.setAttacking(this.getPoseTicks() > 0);
        }
        this.tickControlled = this.m_20160_() ? ++this.tickControlled : 0;
        if (this.isAttacking()) {
            this.playAttackSound();
        }
        if (!this.m_9236_().f_46443_) {
            this.m_6858_(this.m_5448_() != null || this.isSprintingToOwner);
        }
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("Saddled", this.m_6254_());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.f_19804_.m_135381_(SADDLED, (Object)compound.m_128471_("Saddled"));
    }

    public boolean m_6741_() {
        return this.m_21824_() && !this.m_6162_();
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.f_19804_.m_135381_(SADDLED, (Object)true);
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12034_, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.PLANTIVORE_DIET_ITEMS);
    }

    public boolean attackEntitiesInFront(float pDistance, float pRadius, Consumer<LivingEntity> pTarget) {
        Vec3 lookAngle = this.m_20154_().m_82541_();
        Vec3 start = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
        List entities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(start.m_82520_((double)(-pRadius), (double)(-pRadius), (double)(-pRadius)), start.m_82520_((double)pRadius, (double)pDistance, (double)pRadius)));
        for (LivingEntity entity : entities) {
            Vec3 directionToEntity;
            double dotProduct;
            double angle;
            if (entity == this || !entity.m_6084_() || !((angle = Math.acos(dotProduct = lookAngle.m_82526_(directionToEntity = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0).m_82546_(start).m_82541_()))) <= 1.5707963267948966)) continue;
            pTarget.accept(entity);
            this.m_7327_((Entity)entity);
            return true;
        }
        return false;
    }

    public void knockBack(@Nullable Entity pEntity) {
        if (pEntity == null) {
            return;
        }
        double yRot = Math.toRadians(this.m_146908_());
        double dirX = -Math.sin(yRot);
        double dirZ = Math.cos(yRot);
        Vec3 vec3 = new Vec3(dirX, 0.0, dirZ).m_82541_().m_82490_((double)2.1f);
        pEntity.m_20334_(vec3.f_82479_, (double)0.9f, vec3.f_82481_);
    }

    @Override
    public int getAnimationLengthInTicks(@NotNull BaseAnimalPose pose) {
        return switch (pose) {
            default -> throw new IncompatibleClassChangeError();
            case BaseAnimalPose.IDLE -> 57;
            case BaseAnimalPose.WALK -> 38;
            case BaseAnimalPose.RUN -> 12;
            case BaseAnimalPose.SWIM -> 40;
            case BaseAnimalPose.COMMUNICATE -> 0;
            case BaseAnimalPose.EAT -> 111;
            case BaseAnimalPose.HIDE -> 0;
            case BaseAnimalPose.HIDING -> 0;
            case BaseAnimalPose.UNHIDE -> 0;
            case BaseAnimalPose.ATTACK -> 16;
            case BaseAnimalPose.ATTACK2 -> 0;
            case BaseAnimalPose.ATTACK3 -> 0;
            case BaseAnimalPose.ROAR -> 55;
            case BaseAnimalPose.DANCE -> 0;
            case BaseAnimalPose.DOWN -> 20;
            case BaseAnimalPose.FALL_ASLEEP -> 27;
            case BaseAnimalPose.WAKE_UP -> 26;
            case BaseAnimalPose.SNIFF -> 0;
            case BaseAnimalPose.INTIMATED -> 0;
            case BaseAnimalPose.UP -> 30;
            case BaseAnimalPose.SIT -> 57;
            case BaseAnimalPose.SLEEP -> 57;
            case BaseAnimalPose.FLOP -> 0;
        };
    }

    @Override
    public int getEatAnimationConsumeDelay() {
        return 100;
    }

    @Override
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)ANEntities.TRICERATOPS.get()).m_20615_((Level)serverLevel);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.m_21824_() && pHand == InteractionHand.MAIN_HAND && !this.m_6898_(itemstack) && !pPlayer.m_6047_() && itemstack.m_150930_(Items.f_42450_) && !this.m_6254_() && this.m_21824_() && !this.m_6162_()) {
            if (!this.m_9236_().m_5776_()) {
                this.f_19804_.m_135381_(SADDLED, (Object)true);
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.m_6071_(pPlayer, pHand);
        if (!interactionResult.m_19077_()) {
            return itemstack.m_150930_(Items.f_42450_) ? itemstack.m_41647_(pPlayer, (LivingEntity)this, pHand) : InteractionResult.PASS;
        }
        return interactionResult;
    }

    @Override
    protected void m_274498_(@NotNull Player pRider, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pRider, pTravelVector);
        this.m_6710_(null);
        if (pRider.f_20900_ != 0.0f || pRider.f_20902_ != 0.0f) {
            EntityUtils.smoothVehicleYawToRider(pRider, (LivingEntity)this, 0.1f, 0.14f);
        }
    }

    @Nullable
    public LivingEntity m_269323_() {
        return super.m_269323_();
    }

    @Override
    public float getMaxScreenShake() {
        return this.m_20142_() ? 0.6f : 0.3f;
    }

    @Override
    public float getShakePower() {
        return this.m_20142_() ? 0.5f : 0.2f;
    }

    @Override
    public float getShakeFrequency() {
        return this.m_20142_() ? 1.39f : 0.35f;
    }

    @Override
    public float getShakeDistance() {
        return 10.0f;
    }

    @Override
    public boolean canEntityShake(@NotNull LivingEntity pEntity) {
        return IShakeScreenOnStep.super.canEntityShake((LivingEntity)this) && EntityUtils.isEntityMoving((Entity)this, 0.1f) && !this.m_6162_();
    }

    @Override
    public float calculateShakeIntensity(float pAnimationSpeed) {
        float animationFactor = 1.0f + pAnimationSpeed * 0.3f;
        return 0.2f * animationFactor;
    }

    protected float m_6121_() {
        return 1.4f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ANSounds.TRICERATOPS_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ANSounds.TRICERATOPS_DEATH.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource pDamageSource) {
        return (SoundEvent)ANSounds.TRICERATOPS_HURT.get();
    }

    protected void playAttackSound() {
        this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ANSounds.TRICERATOPS_ATTACK.get(), SoundSource.HOSTILE, this.m_6121_(), 1.0f);
    }
}

