/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RemoveBlockGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.reaper.ancientnature.client.entity.animation.SmoothAnimationState;
import net.reaper.ancientnature.common.base.BaseWaterAnimal;
import net.reaper.ancientnature.common.entity.AnomalocarisEntity;
import net.reaper.ancientnature.common.entity.ai.control.SmoothBodyRotationControl;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.enums.Gender;
import net.reaper.ancientnature.common.goals.ConsumeItemFromGroundGoal;
import net.reaper.ancientnature.common.goals.EggBreedGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.common.goals.water.WaterLayEggGoal;
import net.reaper.ancientnature.common.goals.water.WaterSmartAnimalTemptGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANBlocks;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.core.registry.ANSounds;
import net.reaper.ancientnature.core.registry.ANTags;
import org.jetbrains.annotations.NotNull;

public class TrilobiteEntity
extends BaseWaterAnimal<TrilobiteEntity>
implements Bucketable {
    public static final int HIDE_ANIM_TICKS = 11;
    public static final int UNHIDE_ANIM_TICKS = 13;
    private static final UUID SPEED_PENALTY_UUID = UUID.fromString("5CD17A52-AB9A-42D3-A629-90FDE04B281E");
    private static final AttributeModifier SPEED_PENALTY = new AttributeModifier(SPEED_PENALTY_UUID, "no moving while hiding", -100.0, AttributeModifier.Operation.ADDITION);
    private static final Predicate<LivingEntity> SCARY_MOB = entity -> {
        if (entity instanceof Player && ((Player)entity).m_7500_() || entity instanceof AnomalocarisEntity && !((AnomalocarisEntity)entity).isHungry()) {
            return false;
        }
        return entity.m_6095_().m_204039_(ANTags.Entities.TRILOBITE_PREDATORS) || entity.m_6336_() != MobType.f_21644_ && entity.m_6069_() || entity instanceof AnomalocarisEntity && ((AnomalocarisEntity)entity).isHungry();
    };
    static final TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(SCARY_MOB);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(TrilobiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_HIDING = SynchedEntityData.m_135353_(TrilobiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(TrilobiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HIDE_ANIM_COUNTER = SynchedEntityData.m_135353_(TrilobiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> UNHIDE_ANIM_COUNTER = SynchedEntityData.m_135353_(TrilobiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public SmoothAnimationState idleAnimation = new SmoothAnimationState();
    public SmoothAnimationState hidingAnimation = new SmoothAnimationState();
    public SmoothAnimationState hideAnimation = new SmoothAnimationState();
    public SmoothAnimationState unhideAnimation = new SmoothAnimationState();
    public BaseAnimalPose currentPose = BaseAnimalPose.IDLE;
    public int ballTime = 500;
    int hideCounter;
    int unhideCounter;
    int unhideLag;
    private int idleAnimationTimeout = 0;
    private int hidingAnimationTimeout = 0;
    private int hideAnimationTimeout = 0;
    private int unhideAnimationTimeout = 0;
    private int airSupply = 6000;
    private int ballCooldown = 500;

    public TrilobiteEntity(EntityType<? extends BaseWaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_274367_(1.0f);
        this.f_21342_ = new TriloMoveControl();
        this.f_21365_ = new TriloLookControl();
        this.f_21343_ = new TriloJumpControl();
    }

    @Override
    @NotNull
    protected BodyRotationControl m_7560_() {
        SmoothBodyRotationControl<TrilobiteEntity> control = new SmoothBodyRotationControl<TrilobiteEntity>(this);
        control.bodyMax = 2.0f;
        return control;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(IS_HIDING, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(HIDE_ANIM_COUNTER, (Object)0);
        this.f_19804_.m_135372_(UNHIDE_ANIM_COUNTER, (Object)0);
    }

    @Override
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    @Override
    public boolean canFlop() {
        return false;
    }

    public boolean m_5829_() {
        return this.isHiding();
    }

    public boolean m_6094_() {
        return true;
    }

    @NotNull
    protected AABB m_142242_() {
        EntityDimensions dimensions = this.isHiding() ? this.getHidingSize() : this.m_6972_(this.m_20089_());
        return dimensions.m_20393_(this.m_20182_());
    }

    protected EntityDimensions getHidingSize() {
        return EntityDimensions.m_20395_((float)0.5f, (float)0.25f);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.4f, (float)0.1f);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public void m_142278_(@NotNull CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        pTag.m_128350_("Health", this.m_21223_());
        pTag.m_128405_("Variant", this.getVariant());
        pTag.m_128405_("age", this.m_146764_());
        pTag.m_128379_("IsHiding", this.isHiding());
        pTag.m_128359_("Gender", this.getGender().toString());
        pTag.m_128379_("isBaby", this.m_6162_());
        pTag.m_128405_("poseTicks", this.getPoseTicks());
        pTag.m_128405_("hunger", this.getTicksUntilHungry());
        pTag.m_128350_("stamina", this.getStamina());
        pTag.m_128379_("hasEggs", this.doesHaveEggs());
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ANItems.TRILOBITE_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TrilobiteHideGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.2f));
        this.f_21345_.m_25352_(2, (Goal)new TrilobiteDestroyEggsGoal((PathfinderMob)this, 1.0, 3));
        this.f_21345_.m_25352_(2, (Goal)new EggBreedGoal(this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new WaterLayEggGoal(this, 1.0, 10, 16, (Block)ANBlocks.TRILOBITE_EGGS.get()));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, e -> true, 300));
        this.f_21345_.m_25352_(3, (Goal)new ConsumeItemFromGroundGoal(this, 1.2, true, this.getEatAnimationConsumeDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.EAT)));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterSmartAnimalTemptGoal(this, 1.2, false));
        this.f_21345_.m_25352_(5, (Goal)new GoToWaterGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getHideAnimCounter() {
        return (Integer)this.f_19804_.m_135370_(HIDE_ANIM_COUNTER);
    }

    public void setHideAnimCounter(int hideAnimCounter) {
        this.f_19804_.m_135381_(HIDE_ANIM_COUNTER, (Object)hideAnimCounter);
    }

    public int getUnhideAnimCounter() {
        return (Integer)this.f_19804_.m_135370_(UNHIDE_ANIM_COUNTER);
    }

    public void setUnhideAnimCounter(int unhideAnimCounter) {
        this.f_19804_.m_135381_(UNHIDE_ANIM_COUNTER, (Object)unhideAnimCounter);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setHiding(compound.m_128471_("IsHiding"));
        if (compound.m_128441_("BallCooldown")) {
            this.ballCooldown = compound.m_128451_("BallCooldown");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BallCooldown", this.ballCooldown);
        compound.m_128379_("IsHiding", this.isHiding());
        compound.m_128405_("Variant", this.getVariant());
    }

    public boolean isHiding() {
        return (Boolean)this.f_19804_.m_135370_(IS_HIDING);
    }

    public void setHiding(boolean hiding) {
        this.f_19804_.m_135381_(IS_HIDING, (Object)hiding);
    }

    public void m_6872_(ItemStack bucket) {
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag compoundnbt = bucket.m_41784_();
        compoundnbt.m_128350_("Health", this.m_21223_());
        compoundnbt.m_128405_("Variant", this.getVariant());
        compoundnbt.m_128405_("age", this.m_146764_());
        compoundnbt.m_128379_("IsHiding", this.isHiding());
        compoundnbt.m_128359_("Gender", this.getGender().toString());
        compoundnbt.m_128379_("isBaby", this.m_6162_());
        compoundnbt.m_128405_("poseTicks", this.getPoseTicks());
        compoundnbt.m_128405_("hunger", this.getTicksUntilHungry());
        compoundnbt.m_128350_("stamina", this.getStamina());
        compoundnbt.m_128379_("hasEggs", this.doesHaveEggs());
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128425_("Variant", 3)) {
            this.setVariant(dataTag.m_128451_("Variant"));
            this.setGender(Gender.valueOf(dataTag.m_128461_("Gender").toUpperCase()));
            this.m_6863_(dataTag.m_128471_("isBaby"));
            this.setTicksUntilHungry(dataTag.m_128451_("hunger"));
            this.setHasEggs(dataTag.m_128471_("hasEggs"));
            this.m_146762_(dataTag.m_128451_("age"));
            this.setHiding(dataTag.m_128471_("IsHiding"));
            this.setStamina(dataTag.m_128451_("stamina"));
            this.setPoseTicks(dataTag.m_128451_("poseTicks"));
            this.m_27497_(true);
        } else {
            int variant = this.f_19796_.m_188503_(100);
            if (variant < 75) {
                this.setVariant(0);
            } else if (variant < 90) {
                this.setVariant(1);
            } else if (variant < 95) {
                this.setVariant(2);
            } else {
                this.setVariant(3);
            }
            this.setGender(this.f_19796_.m_188499_() ? Gender.MALE : Gender.FEMALE);
        }
        return spawnDataIn;
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.TRILOBITE_DIET_ITEMS);
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            if (this.isHiding()) {
                AttributeInstance speedAttribute = this.m_21051_(Attributes.f_22279_);
                assert (speedAttribute != null);
                speedAttribute.m_22130_(SPEED_PENALTY);
                speedAttribute.m_22118_(SPEED_PENALTY);
            } else {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(SPEED_PENALTY);
            }
        }
        if (this.hideCounter > 0) {
            if (!this.isHiding()) {
                this.setHideAnimCounter(11);
            }
        } else if (this.isHiding() && this.unhideLag <= 0 && this.unhideCounter > 0) {
            this.setUnhideAnimCounter(13);
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            if (this.unhideLag == 1) {
                this.ballCooldown = 0;
            }
            if (this.unhideLag > 0) {
                --this.unhideLag;
            }
            if (this.hideCounter > 0) {
                if (!this.isHiding()) {
                    this.m_5496_((SoundEvent)ANSounds.TRILOBITES_HIDE.get(), this.m_6121_(), this.m_6100_());
                    this.setHiding(true);
                    this.m_21573_().m_26573_();
                    this.m_20334_(0.0, -1.0, 0.0);
                }
                ++this.hideCounter;
            } else if (this.isHiding() && this.unhideLag <= 0) {
                if (this.unhideCounter > 0) {
                    this.m_5496_((SoundEvent)ANSounds.TRILOBITES_UNHIDE.get(), this.m_6121_(), this.m_6100_());
                    this.setHiding(false);
                }
                ++this.unhideCounter;
            }
        }
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
                this.idleAnimation.m_216977_(this.f_19797_);
            } else {
                --this.idleAnimationTimeout;
            }
            this.hideAnimation.m_246184_(this.getHideAnimCounter() > 0, this.f_19797_);
            this.unhideAnimation.m_246184_(this.getUnhideAnimCounter() > 0, this.f_19797_);
            if (this.getHideAnimCounter() > 0) {
                this.setHideAnimCounter(this.getHideAnimCounter() - 1);
            }
            if (this.getUnhideAnimCounter() > 0) {
                this.setUnhideAnimCounter(this.getUnhideAnimCounter() - 1);
            }
        }
        if (this.m_6084_() && !this.m_6162_() && this.ballCooldown < this.ballTime) {
            ++this.ballCooldown;
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_20071_()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)0.17f);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_((double)0.1f);
        }
        if (this.m_269291_().equals(DamageTypes.f_268433_)) {
            this.setHiding(true);
            this.getHidingPose();
        }
    }

    @Override
    protected void m_267689_(float pPartialTick) {
        if (this.m_20089_() == Pose.STANDING) {
            float f = Math.min(pPartialTick * 6.0f, 1.0f);
        } else {
            float f = 0.0f;
        }
        this.f_267362_.m_267566_(1.0f, 1.0f);
    }

    @Override
    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(this.airSupply);
        }
    }

    @Override
    public boolean canDrownInFluidType(@NotNull FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    @org.jetbrains.annotations.Nullable
    public TrilobiteEntity getBreedOffspring(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        TrilobiteEntity baby = (TrilobiteEntity)((EntityType)ANEntities.TRILOBITE.get()).m_20615_((Level)pLevel);
        assert (baby != null);
        baby.setVariant(this.f_19796_.m_188502_());
        baby.m_21530_();
        return baby;
    }

    public BaseAnimalPose getHidingPose() {
        return BaseAnimalPose.values()[this.currentPose.ordinal()];
    }

    @Override
    public void setSmartPose(BaseAnimalPose pPose) {
        this.currentPose = pPose;
    }

    public boolean isHidingPose() {
        return this.getHidingPose() == BaseAnimalPose.HIDING;
    }

    @Override
    protected void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && BaseAnimalPose.IDLE == this.getHidingPose() && !this.f_267362_.m_267780_()) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimation.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.getHidingPose() != BaseAnimalPose.HIDE && this.getHideAnimCounter() > 0) {
            if (this.getHidingPose() == BaseAnimalPose.IDLE) {
                this.hideAnimation.m_216982_(this.f_19797_);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.HIDE));
                this.setSmartPose(BaseAnimalPose.HIDE);
            }
            if (this.getHidingPose() == BaseAnimalPose.HIDE && this.getPoseTicks() == 0) {
                this.hideAnimation.m_216973_();
                this.idleAnimation.m_216973_();
                this.hidingAnimation.m_216977_(this.f_19797_);
                this.setPoseTicks(this.getAnimationLengthInTicks(BaseAnimalPose.HIDING));
                this.setSmartPose(BaseAnimalPose.HIDING);
            }
        }
    }

    @Override
    public int getAnimationLengthInTicks(@NotNull BaseAnimalPose pose) {
        return switch (pose) {
            default -> throw new IncompatibleClassChangeError();
            case BaseAnimalPose.IDLE -> 0;
            case BaseAnimalPose.WALK -> 20;
            case BaseAnimalPose.SWIM -> 0;
            case BaseAnimalPose.EAT -> 0;
            case BaseAnimalPose.ATTACK -> 0;
            case BaseAnimalPose.ATTACK2 -> 0;
            case BaseAnimalPose.HIDE -> 10;
            case BaseAnimalPose.HIDING -> 20;
            case BaseAnimalPose.UNHIDE -> 11;
            case BaseAnimalPose.ATTACK3 -> 0;
            case BaseAnimalPose.RUN -> 0;
            case BaseAnimalPose.COMMUNICATE -> 0;
            case BaseAnimalPose.DOWN -> 0;
            case BaseAnimalPose.SIT -> 0;
            case BaseAnimalPose.DANCE -> 0;
            case BaseAnimalPose.FALL_ASLEEP -> 0;
            case BaseAnimalPose.SLEEP -> 0;
            case BaseAnimalPose.WAKE_UP -> 0;
            case BaseAnimalPose.ROAR -> 0;
            case BaseAnimalPose.SNIFF -> 0;
            case BaseAnimalPose.INTIMATED -> 0;
            case BaseAnimalPose.UP -> 0;
            case BaseAnimalPose.FLOP -> 0;
        };
    }

    @Override
    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public int m_20146_() {
        return this.airSupply;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ANSounds.TRILOBITES_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_28281_) {
        return (SoundEvent)ANSounds.TRILOBITES_HURT.get();
    }

    protected void m_7355_(BlockPos p_33804_, BlockState p_33805_) {
        this.m_5496_(SoundEvents.f_12435_, 0.05f, 1.0f);
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    @Override
    public boolean m_5957_() {
        return super.m_5957_() && !this.doesHaveEggs() && !this.isHiding();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.isHiding() && !pSource.m_276093_(DamageTypes.f_286979_) && !pSource.m_276093_(DamageTypes.f_268724_)) {
            Player player;
            Entity entity = pSource.m_7639_();
            if (entity instanceof Player && (player = (Player)entity).m_21205_().m_41720_() instanceof AxeItem) {
                this.setHiding(false);
                this.setUnhideAnimCounter(13);
                this.setHideAnimCounter(0);
                this.unhideCounter = 0;
                this.hideCounter = 0;
                this.ballCooldown = 0;
                return super.m_6469_(pSource, 0.0f);
            }
            if (pSource.m_7639_() instanceof AnomalocarisEntity) {
                this.setHiding(false);
                this.setUnhideAnimCounter(13);
                this.setHideAnimCounter(0);
                this.unhideCounter = 0;
                this.hideCounter = 0;
                this.ballCooldown = 0;
                return super.m_6469_(pSource, 0.0f);
            }
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    class TriloMoveControl
    extends MoveControl {
        private final int maxTurnX;
        private final int maxTurnY;
        private final float inWaterSpeedModifier;
        private final float outsideWaterSpeedModifier;
        private final boolean applyGravity;

        public TriloMoveControl() {
            super((Mob)TrilobiteEntity.this);
            this.maxTurnX = 1;
            this.maxTurnY = 1;
            this.inWaterSpeedModifier = 0.17f;
            this.outsideWaterSpeedModifier = 0.1f;
            this.applyGravity = true;
        }

        private static float getTurningSpeedFactor(float p_249853_) {
            return 1.0f - Mth.m_14036_((float)((p_249853_ - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
        }

        public void m_8126_() {
            if (!TrilobiteEntity.this.isHiding()) {
                if (TrilobiteEntity.this.m_20069_()) {
                    if (this.applyGravity && this.f_24974_.m_20069_()) {
                        this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, -0.05, 0.0));
                    }
                    if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.f_24974_.m_21573_().m_26571_()) {
                        double d2;
                        double d1;
                        double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                        double d3 = d0 * d0 + (d1 = this.f_24976_ - this.f_24974_.m_20186_()) * d1 + (d2 = this.f_24977_ - this.f_24974_.m_20189_()) * d2;
                        if (d3 < 2.500000277905201E-7) {
                            this.f_24974_.m_21564_(0.0f);
                        } else {
                            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), f, this.maxTurnY));
                            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
                            float f1 = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                            if (this.f_24974_.m_20069_()) {
                                this.f_24974_.m_7910_(f1 * this.inWaterSpeedModifier);
                                double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                                if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                                    float f3 = -((float)(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                                    f3 = Mth.m_14036_((float)Mth.m_14177_((float)f3), (float)(-this.maxTurnX), (float)this.maxTurnX);
                                    this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), f3, 5.0f));
                                }
                                float f6 = Mth.m_14089_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                                float f4 = Mth.m_14031_((float)(this.f_24974_.m_146909_() * ((float)Math.PI / 180)));
                                this.f_24974_.f_20902_ = f6 * f1;
                                this.f_24974_.f_20901_ = -f4 * f1;
                            } else {
                                float f5 = Math.abs(Mth.m_14177_((float)(this.f_24974_.m_146908_() - f)));
                                float f2 = TriloMoveControl.getTurningSpeedFactor(f5);
                                this.f_24974_.m_7910_(f1 * this.outsideWaterSpeedModifier * f2);
                            }
                        }
                    } else if (TrilobiteEntity.this.isHiding()) {
                        this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82520_(0.0, 0.0, 0.0));
                        this.f_24974_.m_7910_(0.0f);
                        this.f_24974_.m_21570_(0.0f);
                        this.f_24974_.m_21567_(0.0f);
                        this.f_24974_.m_21564_(0.0f);
                    }
                } else {
                    super.m_8126_();
                }
            } else {
                this.f_24974_.m_21573_().m_26573_();
            }
        }
    }

    public class TriloLookControl
    extends LookControl {
        public TriloLookControl() {
            super((Mob)TrilobiteEntity.this);
        }

        public void m_8128_() {
            if (!TrilobiteEntity.this.isHiding()) {
                super.m_8128_();
            }
        }
    }

    class TriloJumpControl
    extends JumpControl {
        public TriloJumpControl() {
            super((Mob)TrilobiteEntity.this);
        }

        public void m_24901_() {
        }
    }

    static class TrilobiteHideGoal
    extends Goal {
        private final TrilobiteEntity trilobite;

        public TrilobiteHideGoal(TrilobiteEntity pTrilobite) {
            this.trilobite = pTrilobite;
        }

        public boolean m_8036_() {
            if (this.trilobite.ballCooldown < this.trilobite.ballTime || this.trilobite.m_6162_()) {
                return false;
            }
            List list = this.trilobite.m_9236_().m_6443_(LivingEntity.class, this.trilobite.m_20191_().m_82400_(20.0), entity -> targetingConditions.m_26885_((LivingEntity)this.trilobite, entity));
            return !list.isEmpty();
        }

        public void m_8056_() {
            this.trilobite.hideCounter = 1;
            this.trilobite.unhideCounter = 0;
        }

        public void m_8041_() {
            this.trilobite.hideCounter = 0;
            this.trilobite.unhideLag = 50 + this.trilobite.f_19796_.m_188503_(20);
            this.trilobite.unhideCounter = 1;
        }
    }

    class TrilobiteDestroyEggsGoal
    extends RemoveBlockGoal {
        private int ticksSinceReachedGoal;
        private static final int WAIT_AFTER_BLOCK_FOUND = 20;

        TrilobiteDestroyEggsGoal(PathfinderMob pMob, double pSpeedModifier, int pVerticalSearchRange) {
            super((Block)ANBlocks.ANOMALOCARIS_EGGS.get(), pMob, pSpeedModifier, pVerticalSearchRange);
        }

        public boolean m_8036_() {
            if (TrilobiteEntity.this.isHungry()) {
                return true;
            }
            return this.m_8036_();
        }

        public void m_8041_() {
            if (!TrilobiteEntity.this.isHungry()) {
                super.m_8041_();
            }
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            ChunkAccess chunkaccess = pLevel.m_6522_(SectionPos.m_123171_((int)pPos.m_123341_()), SectionPos.m_123171_((int)pPos.m_123343_()), ChunkStatus.f_62326_, false);
            if (chunkaccess == null) {
                return false;
            }
            return chunkaccess.m_8055_(pPos).m_60713_((Block)ANBlocks.ANOMALOCARIS_EGGS.get());
        }

        public void m_8037_() {
            super.m_8037_();
            Level level = TrilobiteEntity.this.m_9236_();
            BlockPos blockpos = TrilobiteEntity.this.m_20183_();
            BlockPos blockpos1 = this.m_25852_(blockpos, (BlockGetter)level);
            RandomSource randomsource = TrilobiteEntity.this.m_217043_();
            if (this.m_25625_() && blockpos1 != null) {
                if (this.ticksSinceReachedGoal > 0) {
                    TrilobiteEntity.this.m_20334_(0.0, 0.0, 0.0);
                    if (!level.f_46443_) {
                        double d0 = 0.08;
                        ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ANBlocks.ANOMALOCARIS_EGGS.get())), (double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.7, (double)blockpos1.m_123343_() + 0.5, 3, ((double)randomsource.m_188501_() - 0.5) * 0.08, ((double)randomsource.m_188501_() - 0.5) * 0.08, ((double)randomsource.m_188501_() - 0.5) * 0.08, (double)0.15f);
                    }
                }
                if (this.ticksSinceReachedGoal % 2 == 0) {
                    Vec3 vec31 = TrilobiteEntity.this.m_20184_();
                    TrilobiteEntity.this.m_20334_(vec31.f_82479_, -0.3, vec31.f_82481_);
                    if (this.ticksSinceReachedGoal % 6 == 0) {
                        this.m_7659_((LevelAccessor)level, this.f_25602_);
                    }
                }
                if (this.ticksSinceReachedGoal > 60) {
                    level.m_7471_(blockpos1, false);
                    if (!level.f_46443_) {
                        for (int i = 0; i < 20; ++i) {
                            double d3 = randomsource.m_188583_() * 0.02;
                            double d1 = randomsource.m_188583_() * 0.02;
                            double d2 = randomsource.m_188583_() * 0.02;
                            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_(), (double)blockpos1.m_123343_() + 0.5, 1, d3, d1, d2, (double)0.15f);
                        }
                        TrilobiteEntity.this.setHunger(300);
                        this.m_5777_(level, blockpos1);
                    }
                }
                ++this.ticksSinceReachedGoal;
            }
        }

        @Nullable
        private BlockPos m_25852_(BlockPos pPos, BlockGetter pLevel) {
            BlockPos[] ablockpos;
            if (pLevel.m_8055_(pPos).m_60713_((Block)ANBlocks.ANOMALOCARIS_EGGS.get())) {
                return pPos;
            }
            for (BlockPos blockpos : ablockpos = new BlockPos[]{pPos.m_7495_(), pPos.m_122024_(), pPos.m_122029_(), pPos.m_122012_(), pPos.m_122019_(), pPos.m_7495_().m_7495_()}) {
                if (!pLevel.m_8055_(blockpos).m_60713_((Block)ANBlocks.ANOMALOCARIS_EGGS.get())) continue;
                return blockpos;
            }
            return null;
        }

        public void m_7659_(LevelAccessor pLevel, @NotNull BlockPos pPos) {
            pLevel.m_5594_((Player)null, pPos, (SoundEvent)ANSounds.TRILOBITES_HURT.get(), SoundSource.HOSTILE, 0.5f, 0.9f + TrilobiteEntity.this.f_19796_.m_188501_() * 0.2f);
        }

        public void m_5777_(Level pLevel, @NotNull BlockPos pPos) {
            pLevel.m_5594_((Player)null, pPos, (SoundEvent)ANSounds.TRILOBITES_HIDE.get(), SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.f_46441_.m_188501_() * 0.2f);
        }

        public double m_8052_() {
            return 1.14;
        }
    }

    static class GoToWaterGoal
    extends Goal {
        private final PathfinderMob mob;
        private final double speedModifier;
        private final Level level;
        private double wantedX;
        private double wantedY;
        private double wantedZ;

        public GoToWaterGoal(PathfinderMob pMob, double pSpeedModifier) {
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.level = pMob.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20069_()) {
                return false;
            }
            Vec3 vec3 = this.getWaterPos();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3 getWaterPos() {
            RandomSource randomsource = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(randomsource.m_188503_(20) - 10, 2 - randomsource.m_188503_(8), randomsource.m_188503_(20) - 10);
                if (!this.level.m_8055_(blockpos1).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }
}

