/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.WormEntity;
import net.reaper.ancientnature.common.entity.ai.control.SmoothBodyRotationControl;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.enums.BaseAnimalPose;
import net.reaper.ancientnature.common.goals.AttackGoal;
import net.reaper.ancientnature.common.goals.PanicSprintingGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANEntities;
import org.jetbrains.annotations.NotNull;

public class TuataraEntity
extends BaseSleepingAnimal<TuataraEntity> {
    public float tailRot;
    public float prevTailRot;
    public int tickControlled;

    public TuataraEntity(EntityType<? extends BaseSleepingAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 1;
        this.m_7105_(false);
        this.m_274367_(1.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (!TuataraEntity.this.m_5803_()) {
                    super.m_8126_();
                }
            }
        };
    }

    public static boolean canSpawn(EntityType<TuataraEntity> tEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return Animal.m_218104_(tEntityType, (LevelAccessor)serverLevelAccessor, (MobSpawnType)spawnType, (BlockPos)blockPos, (RandomSource)randomSource) && !serverLevelAccessor.m_6106_().m_6533_();
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isEating() || this.m_5803_();
    }

    @Override
    @NotNull
    protected BodyRotationControl m_7560_() {
        return new SmoothBodyRotationControl<TuataraEntity>(this);
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.5f, (float)0.4f);
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevTailRot = this.tailRot;
        this.tailRot += (-(this.f_20883_ - this.f_20884_) - this.tailRot) * 0.15f;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicSprintingGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal(this, 1.75, true, this.getAttackAnimationDamageDelay(), this.getAnimationLengthInTicks(BaseAnimalPose.ATTACK)));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, entity -> !this.m_20072_() && !this.m_6162_() && this.m_5803_(), 300));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<WormEntity>((Mob)this, WormEntity.class, true, true){

            @NotNull
            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(10.0, 4.0, 10.0);
            }
        });
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.TUATARA_DIET_ITEMS);
    }

    @Override
    public int getAttackAnimationDamageDelay() {
        return 6;
    }

    @Override
    public int getEatAnimationConsumeDelay() {
        return 29;
    }

    @Override
    public int getAnimationLengthInTicks(@NotNull BaseAnimalPose pose) {
        return switch (pose) {
            default -> throw new IncompatibleClassChangeError();
            case BaseAnimalPose.IDLE -> (int)((this.m_6162_() ? 1.4583 : 1.5625) * 20.0);
            case BaseAnimalPose.WALK -> 29;
            case BaseAnimalPose.RUN -> 10;
            case BaseAnimalPose.EAT -> 29;
            case BaseAnimalPose.HIDE -> 0;
            case BaseAnimalPose.HIDING -> 0;
            case BaseAnimalPose.UNHIDE -> 0;
            case BaseAnimalPose.ATTACK -> 7;
            case BaseAnimalPose.ATTACK2 -> 0;
            case BaseAnimalPose.ATTACK3 -> 0;
            case BaseAnimalPose.ROAR -> 0;
            case BaseAnimalPose.DOWN -> 0;
            case BaseAnimalPose.FALL_ASLEEP -> 20;
            case BaseAnimalPose.WAKE_UP -> 20;
            case BaseAnimalPose.SNIFF -> 0;
            case BaseAnimalPose.INTIMATED -> 0;
            case BaseAnimalPose.DANCE -> 0;
            case BaseAnimalPose.UP -> 0;
            case BaseAnimalPose.SIT -> 0;
            case BaseAnimalPose.SLEEP -> 41;
            case BaseAnimalPose.SWIM -> 20;
            case BaseAnimalPose.COMMUNICATE -> 0;
            case BaseAnimalPose.FLOP -> 0;
        };
    }

    @Override
    protected void m_267689_(float pPartialTick) {
        float speed = !this.m_6162_() ? (this.m_20142_() ? 0.7f : 6.0f) : 1.3f;
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * speed, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 1.0f);
    }

    public TuataraEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (TuataraEntity)((EntityType)ANEntities.TUATARA.get()).m_20615_((Level)pLevel);
    }
}

