/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.reaper.ancientnature.client.entity.animation.SmoothAnimationState;
import net.reaper.ancientnature.common.base.BaseWaterAnimal;
import net.reaper.ancientnature.common.entity.ai.goal.base.movement.SwimNearCoralGoal;
import net.reaper.ancientnature.common.entity.ai.hunger.DinoDiets;
import net.reaper.ancientnature.common.entity.ai.pathing.water.ObstacleNodeEvaluator;
import net.reaper.ancientnature.common.enums.Gender;
import net.reaper.ancientnature.common.goals.EggBreedGoal;
import net.reaper.ancientnature.common.goals.WildBreedGoal;
import net.reaper.ancientnature.common.goals.water.WaterSmartAnimalTemptGoal;
import net.reaper.ancientnature.common.toremove.AnimalDiet;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANItems;
import org.jetbrains.annotations.NotNull;

public class TuzoiaEntity
extends BaseWaterAnimal<TuzoiaEntity>
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(TuzoiaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static int gestration_time = 48000;
    public final SmoothAnimationState floppingAnimationState = new SmoothAnimationState();
    public final SmoothAnimationState swimAnimationState = new SmoothAnimationState();
    public final int EGG_LAYING_COOLDOWN = this.getGender() == Gender.MALE ? 6000 : gestration_time;
    public float currentRoll = 0.0f;
    public float tailRot;
    public float prevTailRot;
    private int swimAnimationTimeout = 0;

    public TuzoiaEntity(EntityType<? extends BaseWaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 1.0f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 75);
        this.f_21344_ = new WaterBoundPathNavigation((Mob)this, pLevel){

            @NotNull
            protected PathFinder m_5532_(int max) {
                this.f_26508_ = new ObstacleNodeEvaluator(10, true);
                return new PathFinder(this.f_26508_, max);
            }
        };
    }

    private InteractionResult bucketPregnantPickup(Player player, InteractionHand hand, TuzoiaEntity entity) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41619_() && entity.m_6084_() && entity.isPregnant()) {
            player.m_5496_(entity.m_142623_(), 1.0f, 1.0f);
            ItemStack eggStack = new ItemStack((ItemLike)ANItems.TUZOIA_EGGS.get(), 1);
            player.m_21008_(hand, eggStack);
            entity.setIsPregnant(false);
            return InteractionResult.CONSUME;
        }
        if (itemstack.m_41720_() == Items.f_42447_ && entity.m_6084_() && entity.isPregnant()) {
            player.m_5496_(entity.m_142623_(), 1.0f, 1.0f);
            ItemStack eggBucketStack = new ItemStack((ItemLike)ANItems.TUZOIA_EGGS_BUCKET.get());
            player.m_21008_(hand, eggBucketStack);
            entity.setIsPregnant(false);
            return InteractionResult.CONSUME;
        }
        if (itemstack.m_41720_() == Items.f_42447_ && entity.m_6084_()) {
            player.m_5496_(entity.m_142623_(), 1.0f, 1.0f);
            ItemStack bucketStack = new ItemStack((ItemLike)ANItems.TUZOIA_BUCKET.get());
            player.m_21008_(hand, bucketStack);
            entity.m_146870_();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void defineDiet(AnimalDiet.Builder pDietBuilder) {
        super.defineDiet(pDietBuilder);
        pDietBuilder.addItems(DinoDiets.TUZOIA_DIET_ITEMS);
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new SwimNearCoralGoal((PathfinderMob)this, 1.0, 30, 10));
        this.f_21345_.m_25352_(2, (Goal)new WildBreedGoal((Animal)this, entity -> this.m_20072_() && !this.isPregnant(), 300));
        this.f_21345_.m_25352_(2, (Goal)new EggBreedGoal(this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new WaterSmartAnimalTemptGoal(this, 1.2, false));
        this.f_21345_.m_25352_(7, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
    }

    @Override
    public boolean m_5957_() {
        return super.m_5957_() && !this.m_6162_() && !this.isPregnant() && this.m_20072_();
    }

    @Override
    protected EntityDimensions getBabyBox() {
        return EntityDimensions.m_20395_((float)0.2f, (float)0.2f);
    }

    protected float m_6431_(@Nonnull Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.9f;
    }

    @Override
    public void m_8119_() {
        if (this.m_6084_() && !this.m_21525_() && this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.m_6084_() && !this.m_21525_() && !this.m_9236_().f_46443_ && this.isPregnant() && this.m_146764_() <= 0) {
            this.m_27563_((ServerLevel)this.m_9236_(), (Animal)this);
            this.setIsPregnant(false);
        }
        super.m_8119_();
    }

    @Override
    public void setupAnimationStates() {
        if (!this.m_20072_()) {
            this.floppingAnimationState.m_216982_(this.f_19797_);
        } else {
            this.floppingAnimationState.m_216973_();
        }
        if (this.f_267362_.m_267780_() && this.m_20072_()) {
            if (this.swimAnimationTimeout <= 0) {
                this.swimAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
                this.swimAnimationState.m_216982_(this.f_19797_);
            } else {
                --this.swimAnimationTimeout;
            }
        }
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(@Nonnull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(@Nonnull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
    }

    public boolean isPregnant() {
        return this.doesHaveEggs();
    }

    public void setIsPregnant(boolean isPregnant) {
        this.setHasEggs(isPregnant);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    @Override
    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player pPlayer, @Nonnull InteractionHand pHand) {
        return this.bucketPregnantPickup(pPlayer, pHand, this);
    }

    public void m_6872_(@Nonnull ItemStack pStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)pStack);
        CompoundTag compoundtag = pStack.m_41784_();
        compoundtag.m_128405_("Age", this.m_146764_());
        compoundtag.m_128405_("isPregnant", this.isPregnant() ? 1 : 0);
        compoundtag.m_128359_("Gender", this.getGender().toString());
        compoundtag.m_128405_("isBaby", this.m_6162_() ? 1 : 0);
    }

    @Override
    public boolean canFlop() {
        return false;
    }

    @Override
    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    @Override
    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public void m_142278_(@Nonnull CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
        if (pTag.m_128441_("Age")) {
            this.m_146762_(pTag.m_128451_("Age"));
        }
        if (pTag.m_128441_("isPregnant")) {
            this.setIsPregnant(pTag.m_128451_("isPregnant") == 1);
        }
        if (pTag.m_128441_("Gender")) {
            this.setGender(Gender.valueOf(pTag.m_128461_("Gender").toUpperCase()));
        }
        if (pTag.m_128441_("isBaby")) {
            this.m_6863_(pTag.m_128451_("isBaby") == 1);
        }
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ANItems.TUZOIA_BUCKET.get());
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public TuzoiaEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (TuzoiaEntity)((EntityType)ANEntities.TUZOIA.get()).m_20615_((Level)pLevel);
    }
}

