/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.dance;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.reaper.ancientnature.ANLogger;
import net.reaper.ancientnature.api.common.misc.BooleanWatcher;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.ai.dance.IDanceable;
import net.reaper.ancientnature.common.entity.ai.dance.JukeboxListener;
import net.reaper.ancientnature.common.entity.ai.dance.RecordFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DanceController<T extends BaseAnimal<T>> {
    public static final int RADIUS = GameEvent.f_238690_.m_157827_();
    @NotNull
    private final T animal;
    private final DynamicGameEventListener<JukeboxListener> listener;
    @Nullable
    private BlockPos jukeboxPos = null;
    private final BooleanWatcher danceWatcher = new BooleanWatcher(false);

    public DanceController(@NotNull T animal, @NotNull RecordFilter filter) {
        if (!(animal instanceof IDanceable)) {
            throw new IllegalArgumentException("Mob must implement IDanceable interface!");
        }
        this.animal = animal;
        this.listener = new DynamicGameEventListener((GameEventListener)new JukeboxListener((PositionSource)new EntityPositionSource(animal, animal.m_20192_()), RADIUS, filter, new BiConsumer<BlockPos, Boolean>(){

            @Override
            public void accept(@NotNull BlockPos pos, @NotNull Boolean playing) {
                DanceController.this.setJukeboxPlaying(pos, playing);
            }
        }));
    }

    public abstract boolean isDance();

    public abstract void setDance(boolean var1);

    private boolean canStop() {
        return this.jukeboxPos == null || !this.jukeboxPos.m_203195_((Position)this.animal.m_20182_(), (double)RADIUS) || !this.animal.m_9236_().m_8055_(this.jukeboxPos).m_60713_(Blocks.f_50131_);
    }

    private void setJukeboxPlaying(@NotNull BlockPos pos, boolean playing) {
        if (playing) {
            if (!this.isDance() && ((IDanceable)this.animal).canDance()) {
                this.jukeboxPos = pos;
                this.setDance(true);
            }
        } else if (pos.equals((Object)this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDance(false);
        }
    }

    protected void onDanceStart() {
    }

    protected void onDanceStop() {
    }

    public void update() {
        if (!this.animal.m_9236_().f_46443_ && this.animal.m_6084_()) {
            if (this.isDance()) {
                ((IDanceable)this.animal).tickDance();
            }
            if (!this.animal.m_21525_()) {
                if (this.canStop() && ((BaseAnimal)this.animal).f_19797_ % 20 == 0) {
                    this.setDance(false);
                    this.jukeboxPos = null;
                }
                this.danceWatcher.update(this.isDance(), new BooleanWatcher.Listener(){

                    @Override
                    public void onTrue() {
                        DanceController.this.onDanceStart();
                        ANLogger.log(ANLogger.Color.GREEN, String.format("%s started dancing on pos: %s", DanceController.this.animal.m_7755_().getString(), DanceController.this.jukeboxPos), new Object[0]);
                    }

                    @Override
                    public void onFalse() {
                        DanceController.this.onDanceStop();
                        ANLogger.log(ANLogger.Color.GREEN, String.format("%s stopped dancing", DanceController.this.animal.m_7755_().getString()), new Object[0]);
                    }
                });
            }
        }
    }

    public void updateListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer) {
        consumer.accept(this.listener, (ServerLevel)this.animal.m_9236_());
    }
}

