/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.dance;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class RecordFilter
implements Predicate<ItemStack> {
    private final Set<Item> whitelist = new HashSet<Item>();
    private final Set<Item> blacklist = new HashSet<Item>();
    private final Set<TagKey<Item>> tagWhitelist = new HashSet<TagKey<Item>>();
    private final Set<TagKey<Item>> tagBlacklist = new HashSet<TagKey<Item>>();
    private boolean allowAll = false;
    private boolean denyAll = false;

    private RecordFilter() {
    }

    @NotNull
    public static RecordFilter create() {
        return new RecordFilter();
    }

    @NotNull
    public RecordFilter allowAll() {
        this.allowAll = true;
        this.denyAll = false;
        return this;
    }

    @NotNull
    public RecordFilter denyAll() {
        this.denyAll = true;
        this.allowAll = false;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public RecordFilter allow(ItemLike ... items) {
        for (ItemLike item : items) {
            this.whitelist.add(item.m_5456_());
        }
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public RecordFilter deny(ItemLike ... items) {
        for (ItemLike item : items) {
            this.blacklist.add(item.m_5456_());
        }
        return this;
    }

    @NotNull
    public RecordFilter allowTag(@NotNull TagKey<Item> tag) {
        this.tagWhitelist.add(tag);
        return this;
    }

    @NotNull
    public RecordFilter denyTag(@NotNull TagKey<Item> tag) {
        this.tagBlacklist.add(tag);
        return this;
    }

    @Override
    public boolean test(@NotNull ItemStack stack) {
        if (!stack.m_41619_() && !this.denyAll) {
            if (this.allowAll) {
                return true;
            }
            Item item = stack.m_41720_();
            if (!this.blacklist.contains(item)) {
                boolean deniedByTag = false;
                for (TagKey<Item> tag : this.tagBlacklist) {
                    if (!stack.m_204117_(tag)) continue;
                    deniedByTag = true;
                    break;
                }
                if (!deniedByTag) {
                    if (this.whitelist.contains(item)) {
                        return true;
                    }
                    for (TagKey<Item> tag : this.tagWhitelist) {
                        if (!stack.m_204117_(tag)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

