/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.goal.base.hunt;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HuntRules {
    private final Map<Class<? extends LivingEntity>, BiPredicate<Mob, LivingEntity>> targetConditions = new HashMap<Class<? extends LivingEntity>, BiPredicate<Mob, LivingEntity>>();
    private BiPredicate<Mob, LivingEntity> defaultCondition;

    private HuntRules(@Nullable BiPredicate<Mob, LivingEntity> defaultCondition) {
        if (defaultCondition == null) {
            throw new IllegalArgumentException("Default condition must not be null");
        }
        this.defaultCondition = defaultCondition;
    }

    @Contract(value=" -> new")
    @NotNull
    public static HuntRules smallerThanHunter() {
        return new HuntRules((hunter, target) -> target.m_20205_() < hunter.m_20205_() && target.m_20206_() < hunter.m_20206_());
    }

    @Contract(value="_ -> new")
    @NotNull
    public static HuntRules healthBelow(float health) {
        return new HuntRules((hunter, target) -> target.m_21223_() < health);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static HuntRules ofType(Class<? extends LivingEntity> type) {
        return new HuntRules((hunter, target) -> type.isAssignableFrom(target.getClass()));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static HuntRules excludeTargetType(Class<? extends LivingEntity> type) {
        return new HuntRules((hunter, target) -> !type.isAssignableFrom(target.getClass()));
    }

    public <T extends LivingEntity> HuntRules addCondition(Class<T> targetClazz, BiPredicate<Mob, T> condition) {
        this.targetConditions.put(targetClazz, condition);
        return this;
    }

    @NotNull
    public HuntRules withDefaultCondition(BiPredicate<Mob, LivingEntity> condition) {
        this.defaultCondition = condition;
        return this;
    }

    @NotNull
    public HuntRules and(@NotNull HuntRules other) {
        return new HuntRules((hunter, target) -> this.test((Mob)hunter, (LivingEntity)target) && other.test((Mob)hunter, (LivingEntity)target));
    }

    @NotNull
    public HuntRules or(@NotNull HuntRules other) {
        return new HuntRules((hunter, target) -> this.test((Mob)hunter, (LivingEntity)target) || other.test((Mob)hunter, (LivingEntity)target));
    }

    @NotNull
    public HuntRules copy() {
        HuntRules copy = new HuntRules(this.defaultCondition);
        copy.targetConditions.putAll(this.targetConditions);
        return copy;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public boolean test(@Nullable Mob hunter, @Nullable LivingEntity target) {
        if (hunter == null || target == null) {
            return false;
        }
        for (Map.Entry<Class<? extends LivingEntity>, BiPredicate<Mob, LivingEntity>> entry : this.targetConditions.entrySet()) {
            if (!entry.getKey().isAssignableFrom(target.getClass())) continue;
            return entry.getValue().test(hunter, target);
        }
        return this.defaultCondition.test(hunter, target);
    }
}

