/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.goal.base.hunt;

import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.ai.goal.base.hunt.HuntRules;
import net.reaper.ancientnature.common.util.EntityUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HuntTargetGoal
extends NearestAttackableTargetGoal<LivingEntity> {
    public BaseAnimal<?> animal;
    protected final HuntRules rules;
    @Nullable
    private final Predicate<Mob> shouldSprint;
    public double range = -1.0;

    public HuntTargetGoal(@NotNull Mob mob, @NotNull HuntRules rules) {
        this(mob, rules, null);
    }

    public HuntTargetGoal(@NotNull Mob mob, @NotNull HuntRules rules, @Nullable Predicate<Mob> shouldSprint) {
        super(mob, LivingEntity.class, 10, true, true, null);
        if (!(mob instanceof BaseAnimal)) {
            throw new IllegalArgumentException("Mob must be extends BaseAnimal class");
        }
        BaseAnimal animal = (BaseAnimal)mob;
        this.animal = animal;
        this.rules = rules;
        this.shouldSprint = shouldSprint;
        this.f_26051_ = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(this::isValidTarget);
    }

    @NotNull
    public HuntTargetGoal withRange(double range) {
        this.range = range;
        return this;
    }

    protected double m_7623_() {
        if (this.range == -1.0) {
            return super.m_7623_();
        }
        return this.range;
    }

    @Contract(value="null->false")
    protected boolean isValidTarget(@Nullable LivingEntity entity) {
        return this.rules.test(this.f_26135_, entity);
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldSprint != null) {
            this.f_26135_.m_6858_(EntityUtils.isEntityMoving((Entity)this.f_26135_, 0.05f) && this.shouldSprint.test(this.f_26135_));
        }
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.shouldSprint != null) {
            this.f_26135_.m_6858_(false);
        }
    }
}

