/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.goal.base.movement;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeaFloorLocator {
    private static final Map<Level, SeaFloorLocator> LOCATORS = new ConcurrentHashMap<Level, SeaFloorLocator>();
    private final Level level;
    public static final int MAX_CACHE_SIZE = 10000;
    private final Long2ObjectLinkedOpenHashMap<BlockPos> cache = new Long2ObjectLinkedOpenHashMap();

    public SeaFloorLocator(@NotNull Level level) {
        this.level = level;
    }

    @Nullable
    public synchronized BlockPos findSeaFloor(int x, int y, int z, int distFromFloor) {
        long posKey = BlockPos.m_121882_((int)x, (int)0, (int)z);
        if (this.cache.containsKey(posKey)) {
            this.cache.getAndMoveToLast(posKey);
            return (BlockPos)this.cache.get(posKey);
        }
        BlockPos pos = this.findSeaFloorUncached(x, y, z, distFromFloor);
        if (pos != null) {
            this.cache.put(posKey, (Object)pos);
            if (this.cache.size() > 10000) {
                this.cache.removeFirst();
            }
        }
        return pos;
    }

    @Nullable
    public synchronized BlockPos findSeaFloor(@NotNull BlockPos pos, int distFromFloor) {
        return this.findSeaFloor(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), distFromFloor);
    }

    @Nullable
    private BlockPos findSolidFloorUnderWater(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BlockPos.MutableBlockPos pos, int minY, int distFromFloor) {
        int depth = this.measureWaterDepth(pos.m_122032_());
        if (depth >= 3) {
            BlockPos.MutableBlockPos floorCheck = pos.m_122032_().m_122184_(0, -depth, 0);
            int solid = 0;
            while (floorCheck.m_123342_() > minY) {
                BlockState state = this.level.m_8055_((BlockPos)floorCheck);
                if (!state.m_60795_() && state.m_280296_()) {
                    if (++solid >= 2) {
                        return floorCheck.m_6630_(distFromFloor).m_7949_();
                    }
                } else {
                    solid = 0;
                }
                floorCheck.m_122184_(0, -1, 0);
            }
        }
        return null;
    }

    @Nullable
    public BlockPos findSeaFloorUncached(int x, int y, int z, int distFromFloor) {
        if (!this.level.f_46443_) {
            int minY = this.level.m_141937_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
            while (pos.m_123342_() >= minY) {
                if (this.isWater((BlockPos)pos)) {
                    BlockPos floor = this.findSolidFloorUnderWater(pos, minY, distFromFloor);
                    if (floor != null) {
                        return floor;
                    }
                    pos.m_142448_(pos.m_123342_() - this.measureWaterDepth(pos.m_122032_()));
                    continue;
                }
                pos.m_122184_(0, -1, 0);
            }
        }
        return null;
    }

    private int measureWaterDepth(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull BlockPos.MutableBlockPos pos) {
        int depth = 0;
        while (pos.m_123342_() >= this.level.m_141937_() && this.isWater((BlockPos)pos)) {
            ++depth;
            pos.m_122184_(0, -1, 0);
        }
        return depth;
    }

    private boolean isWater(@NotNull BlockPos pos) {
        return this.level.m_8055_(pos).m_60819_().m_192917_((Fluid)Fluids.f_76193_);
    }

    public synchronized void invalidateCacheForColumn(int x, int z) {
        this.cache.remove(BlockPos.m_121882_((int)x, (int)0, (int)z));
    }

    public synchronized void invalidateCacheForChunk(int chunkX, int chunkZ) {
        this.cache.keySet().removeIf(key -> {
            BlockPos pos = BlockPos.m_122022_((long)key);
            return pos.m_123341_() >> 4 == chunkX && pos.m_123343_() >> 4 == chunkZ;
        });
    }

    @NotNull
    public static SeaFloorLocator get(@NotNull Level level) {
        return LOCATORS.computeIfAbsent(level, SeaFloorLocator::new);
    }

    @Mod.EventBusSubscriber(modid="ancientnature")
    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void onChunkLoad(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ChunkEvent.Load event) {
            ChunkPos pos = event.getChunk().m_7697_();
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof Level) {
                Level level = (Level)levelAccessor;
                SeaFloorLocator.get(level).invalidateCacheForChunk(pos.f_45578_, pos.f_45579_);
            }
        }

        @SubscribeEvent
        public static void onChunkUnload(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ChunkEvent.Unload event) {
            ChunkPos pos = event.getChunk().m_7697_();
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof Level) {
                Level level = (Level)levelAccessor;
                SeaFloorLocator.get(level).invalidateCacheForChunk(pos.f_45578_, pos.f_45579_);
            }
        }
    }
}

