/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.goal.base.movement;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwimNearCoralGoal
extends RandomSwimmingGoal {
    private final int radius;

    public SwimNearCoralGoal(@NotNull PathfinderMob mob, double speed, int interval, int radius) {
        super(mob, speed, interval);
        this.radius = radius;
    }

    @Nullable
    protected Vec3 m_7037_() {
        BlockPos coral = this.findRandomNearbyCoralPos();
        if (coral != null) {
            for (int attempt = 0; attempt < 12; ++attempt) {
                int rx = this.f_25725_.m_217043_().m_188503_(15) - 7;
                int ry = this.f_25725_.m_217043_().m_188503_(13) - 6;
                int rz = this.f_25725_.m_217043_().m_188503_(15) - 7;
                BlockPos targetPos = coral.m_7918_(rx, ry, rz);
                if (!this.f_25725_.m_9236_().m_6425_(targetPos).m_192917_((Fluid)Fluids.f_76193_)) continue;
                return Vec3.m_82512_((Vec3i)targetPos);
            }
        }
        return super.m_7037_();
    }

    @Nullable
    private BlockPos findRandomNearbyCoralPos() {
        BlockPos mobPos = this.f_25725_.m_20183_();
        ArrayList<BlockPos> corals = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int dx = -this.radius; dx <= this.radius; ++dx) {
            for (int dy = -this.radius; dy <= this.radius; ++dy) {
                for (int dz = -this.radius; dz <= this.radius; ++dz) {
                    mutable.m_122178_(mobPos.m_123341_() + dx, mobPos.m_123342_() + dy, mobPos.m_123343_() + dz);
                    if (!(this.f_25725_.m_9236_().m_8055_((BlockPos)mutable).m_60734_() instanceof CoralBlock)) continue;
                    corals.add(mutable.m_7949_());
                }
            }
        }
        if (!corals.isEmpty()) {
            return (BlockPos)corals.get(this.f_25725_.m_217043_().m_188503_(corals.size()));
        }
        return null;
    }

    public int getRadius() {
        return this.radius;
    }
}

