/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.hunger;

import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.event.ForgeEventFactory;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.IAnimateable;
import net.reaper.ancientnature.api.common.animator.MobAnimator;
import net.reaper.ancientnature.api.common.misc.Timer;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.base.BaseSleepingAnimal;
import net.reaper.ancientnature.common.entity.ai.hunger.IEatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EatBlockGoal
extends Goal {
    private final Mob mob;
    private final float speed;
    private final int radius;
    private final boolean mustSee;
    @Nullable
    public BlockPos targetPos = null;
    private int recalcTicks = 0;
    private int stuckTime = 0;
    private boolean drop = true;
    public final int breakId;
    public static IntegerProperty BUSH_AGE = SweetBerryBushBlock.f_57244_;
    private Mode mode = Mode.DESTROY;
    public int breakProgress = 0;
    private final Timer breakTimer = new Timer(0);
    private int searchCooldown = 0;
    private final Predicate<BlockState> berryBushCondition = new Predicate<BlockState>(){

        @Override
        public boolean test(@NotNull BlockState state) {
            return state.m_60713_(Blocks.f_50685_) && (Integer)state.m_61143_((Property)BUSH_AGE) >= 2;
        }
    };

    public EatBlockGoal(@NotNull Mob mob, float speed, int radius) {
        if (!(mob instanceof IEatable)) {
            throw new IllegalArgumentException("Mob must implement IEatable interface!");
        }
        this.mob = mob;
        this.speed = speed;
        this.radius = radius;
        this.mustSee = true;
        this.breakId = mob.m_19879_() % 255;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @NotNull
    public EatBlockGoal setDropBlock(boolean drop) {
        this.drop = drop;
        return this;
    }

    public boolean m_8036_() {
        BaseAnimal animal;
        if (!this.mob.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) || !ForgeEventFactory.getMobGriefingEvent((Level)this.mob.m_9236_(), (Entity)this.mob)) {
            return false;
        }
        Mob mob = this.mob;
        if (mob instanceof BaseAnimal) {
            animal = (BaseAnimal)mob;
            if (animal.hunger != null && !animal.hunger.isHungry()) {
                return false;
            }
        }
        if (this.mob.m_20160_() || this.mob.m_21188_() != null || (mob = this.mob) instanceof BaseSleepingAnimal && (((BaseSleepingAnimal)(animal = (BaseSleepingAnimal)mob)).isSleep() || ((BaseSleepingAnimal)animal).isRest()) || this.mob.m_5448_() != null || !((IEatable)this.mob).canStart()) {
            return false;
        }
        if (--this.searchCooldown > 0) {
            return false;
        }
        Optional melon = BlockPos.m_121930_((BlockPos)this.mob.m_20183_(), (int)this.radius, (int)3, pos -> {
            BlockState state;
            block6: {
                block5: {
                    Vec3 eyePos = this.mob.m_20299_(1.0f);
                    BlockHitResult result = this.mob.m_9236_().m_45547_(new ClipContext(eyePos, Vec3.m_82512_((Vec3i)pos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob));
                    if (this.mustSee && result.m_6662_() == HitResult.Type.BLOCK && !result.m_82425_().equals(pos)) {
                        return false;
                    }
                    state = this.mob.m_9236_().m_8055_(pos);
                    Mob patt4350$temp = this.mob;
                    if (!(patt4350$temp instanceof BaseAnimal)) break block5;
                    BaseAnimal animal = (BaseAnimal)patt4350$temp;
                    if (animal.animalDiet.getBlocks().contains(state.m_60734_()) && !state.m_60795_()) break block6;
                }
                return false;
            }
            if (state.m_60734_() instanceof SweetBerryBushBlock && !this.berryBushCondition.test(state)) {
                return false;
            }
            return ((IEatable)this.mob).canEatBlock(state, (BlockPos)pos, this.mob.m_9236_());
        });
        if (melon.isPresent()) {
            this.targetPos = (BlockPos)melon.get();
            if (this.mob.m_21573_().m_7864_(this.targetPos, 0) == null) {
                this.targetPos = null;
                this.searchCooldown = this.m_183277_(20);
                return false;
            }
            return true;
        }
        this.searchCooldown = this.m_183277_(15 + this.mob.m_9236_().f_46441_.m_188503_(40));
        return false;
    }

    public void m_8056_() {
        this.resetCalc();
        if (this.targetPos != null) {
            this.mode = ((IEatable)this.mob).getEatMode(this.mob.m_9236_().m_8055_(this.targetPos), this.targetPos, this.mob.m_9236_());
            this.mob.m_21573_().m_26519_((double)((float)this.targetPos.m_123341_() + 0.5f), (double)this.targetPos.m_123342_(), (double)((float)this.targetPos.m_123343_() + 0.5f), (double)this.speed);
        }
    }

    public void pickBerries(@NotNull BlockPos pos, @NotNull BlockState state) {
        int age;
        if (state.m_60734_() instanceof SweetBerryBushBlock && (age = ((Integer)state.m_61143_((Property)BUSH_AGE)).intValue()) >= 2) {
            this.mob.m_5496_(SoundEvents.f_12457_, 1.0f, 0.8f + this.mob.m_9236_().f_46441_.m_188501_() * 0.4f);
            BlockState newState = (BlockState)state.m_61124_((Property)BUSH_AGE, (Comparable)Integer.valueOf(1));
            this.mob.m_9236_().m_7731_(pos, newState, 3);
            ((IEatable)this.mob).onBlockPick(newState, pos);
        }
    }

    public void m_8037_() {
        block13: {
            PathNavigation path;
            block14: {
                block15: {
                    BaseAnimation gatherAnim;
                    MobAnimator animator;
                    block16: {
                        if (this.targetPos == null) break block13;
                        path = this.mob.m_21573_();
                        if (!this.mob.m_20183_().m_123314_((Vec3i)this.targetPos, (double)1.8f)) break block14;
                        if (path.m_26570_() != null) {
                            path.m_26573_();
                        }
                        Vec3 toBlock = Vec3.m_82512_((Vec3i)this.targetPos).m_82546_(this.mob.m_20182_());
                        Vec3 toBlockHoriz = new Vec3(toBlock.f_82479_, 0.0, toBlock.f_82481_);
                        if (toBlockHoriz.m_82556_() > 1.0E-6) {
                            toBlockHoriz = toBlockHoriz.m_82541_();
                            float targetYaw = (float)(Math.atan2(toBlockHoriz.f_82481_, toBlockHoriz.f_82479_) * 57.29577951308232) - 90.0f;
                            this.mob.m_146922_(this.mob.m_146908_() + Mth.m_14177_((float)(targetYaw - this.mob.m_146908_())) * 0.2f);
                            this.mob.f_20885_ = this.mob.m_146908_();
                        }
                        this.mob.m_21563_().m_24946_((double)((float)this.targetPos.m_123341_() + 0.5f), (double)((float)this.targetPos.m_123342_() + 0.5f), (double)((float)this.targetPos.m_123343_() + 0.5f));
                        Mob mob = this.mob;
                        if (!(mob instanceof IAnimateable)) break block15;
                        IAnimateable animable = (IAnimateable)mob;
                        animator = animable.getAnimator();
                        if (toBlockHoriz.m_82556_() <= 1.0E-6) break block16;
                        Vec3 vec3 = new Vec3((double)(-Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)))), 0.0, (double)Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180))));
                        if (!(toBlockHoriz.m_82526_(vec3) >= (double)Mth.m_14089_((float)((float)Math.toRadians(5.0))))) break block15;
                    }
                    if (this.mode == Mode.DESTROY) {
                        BaseAnimation breakAnim = ((IEatable)this.mob).getBreakAnim();
                        if (breakAnim != null && !animator.isPlaying(breakAnim.getName())) {
                            animator.play(breakAnim);
                        }
                    } else if (this.mode == Mode.PICK && (gatherAnim = ((IEatable)this.mob).getGatherAnim()) != null && !animator.isPlaying(gatherAnim.getName())) {
                        animator.play(gatherAnim);
                    }
                }
                return;
            }
            this.stopBreaking();
            if (++this.recalcTicks >= 20) {
                this.recalcTicks = 0;
                if (path.m_26571_()) {
                    if (++this.stuckTime > 2) {
                        this.stuckTime = 0;
                        path.m_26519_((double)((float)this.targetPos.m_123341_() + 0.5f), (double)this.targetPos.m_123342_(), (double)((float)this.targetPos.m_123343_() + 0.5f), (double)this.speed);
                    }
                } else {
                    this.stuckTime = 0;
                }
            }
        }
    }

    public void resetCalc() {
        this.recalcTicks = 0;
        this.stuckTime = 0;
    }

    public void stopBreaking() {
        if (this.targetPos != null) {
            this.mob.m_9236_().m_6801_(this.breakId, this.targetPos, -1);
        }
    }

    public boolean m_8045_() {
        BlockState state;
        if (this.targetPos != null && this.mob.m_9236_().m_46749_(this.targetPos) && !this.mob.m_20160_() && this.mob.m_21188_() == null && this.mob.m_5448_() == null && !(state = this.mob.m_9236_().m_8055_(this.targetPos)).m_60795_()) {
            return ((IEatable)this.mob).canEatBlock(state, this.targetPos, this.mob.m_9236_());
        }
        return false;
    }

    public void m_8041_() {
        this.stopBreaking();
        this.targetPos = null;
        this.mob.m_21573_().m_26573_();
        this.resetCalc();
    }

    public boolean m_183429_() {
        return true;
    }

    public static enum Mode implements IExtensibleEnum
    {
        DESTROY(new Action(){

            @Override
            public void apply(@NotNull Mob mob, @NotNull EatBlockGoal goal, @NotNull BlockState state) {
                if (goal.targetPos != null) {
                    if (ForgeEventFactory.onEntityDestroyBlock((LivingEntity)mob, (BlockPos)goal.targetPos, (BlockState)state)) {
                        mob.m_9236_().m_46953_(goal.targetPos, goal.drop, (Entity)mob);
                        ((IEatable)mob).onBlockEat(state, goal.targetPos);
                    }
                    goal.targetPos = null;
                    goal.breakTimer.reset();
                    goal.breakProgress = 0;
                }
            }
        }),
        PICK(new Action(){

            @Override
            public void apply(@NotNull Mob mob, @NotNull EatBlockGoal goal, @NotNull BlockState state) {
                if (goal.targetPos != null) {
                    goal.pickBerries(goal.targetPos, state);
                    ((IEatable)mob).onBlockPick(state, goal.targetPos);
                    goal.targetPos = null;
                }
            }
        });

        private final Action action;

        private Mode(Action action) {
            this.action = action;
        }

        @NotNull
        public Action getAction() {
            return this.action;
        }

        @NotNull
        public static Mode create(String name, @NotNull Action action) {
            throw new IllegalStateException(String.format("%s enum cannot be extended automatically. Use Forge Enum Helper.", Mode.class.getName()));
        }

        @FunctionalInterface
        public static interface Action {
            public void apply(@NotNull Mob var1, @NotNull EatBlockGoal var2, @NotNull BlockState var3);
        }
    }
}

