/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.hunger;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.ANLogger;
import net.reaper.ancientnature.AncientNature;
import net.reaper.ancientnature.api.common.misc.DistanceSorter;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.ai.hunger.IEatable;
import net.reaper.ancientnature.core.registry.ANItems;
import org.jetbrains.annotations.NotNull;

public class EatDroppedItemGoal
extends Goal {
    private final BaseAnimal mob;
    private final float speed;
    private float radius = 10.0f;
    private int ticksUntilNextRecalc = 0;
    private int pathRetries = 0;
    private final boolean mustSee;
    private final float reach;

    public EatDroppedItemGoal(@NotNull BaseAnimal mob, float speed, boolean mustSee, float reach) {
        if (!(mob instanceof IEatable)) {
            throw new IllegalArgumentException("Mob must implement IEatable interface!");
        }
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.mob = mob;
        this.speed = speed;
        this.mustSee = mustSee;
        this.reach = reach;
    }

    @NotNull
    public EatDroppedItemGoal setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public boolean m_8036_() {
        if (this.mob.m_20160_() || this.mob.m_5448_() != null || !this.mob.canStart()) {
            return false;
        }
        AABB area = new AABB(this.mob.m_20183_()).m_82400_((double)this.radius);
        List items = this.mob.m_9236_().m_6443_(ItemEntity.class, area, item -> {
            if (this.mustSee && !this.mob.m_142582_((Entity)item)) {
                return false;
            }
            return item != null && !item.m_213877_() && !item.m_32055_().m_41619_() && this.mob.canEatItem((ItemEntity)item);
        });
        if (!items.isEmpty()) {
            items.sort(new DistanceSorter((Entity)this.mob));
            this.mob.setTargetItem((ItemEntity)items.get(0));
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.ticksUntilNextRecalc = 0;
        this.pathRetries = 0;
    }

    public void m_8037_() {
        ItemEntity targetItem = this.mob.getTargetItem();
        if (targetItem != null) {
            if (targetItem.m_213877_() || targetItem.m_32055_().m_41619_()) {
                this.m_8041_();
                return;
            }
            if (this.mob.getTargetItem() != null) {
                Entity entity;
                if (this.mob.m_21824_() && targetItem.m_19749_() == this.mob.m_269323_() && this.mob.m_269323_() instanceof Player && this.mob.m_5957_()) {
                    this.mob.m_27595_((Player)this.mob.m_269323_());
                }
                if (!this.mob.m_21824_() && (entity = targetItem.m_19749_()) instanceof Player) {
                    Player player = (Player)entity;
                    if (this.mob.canBeTamed()) {
                        float chance = this.mob.m_217043_().m_188501_();
                        AncientNature.LOGGER.info("chance: " + chance);
                        if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ANItems.TAMERS_HAT.get()) {
                            if (chance > 0.3f) {
                                this.mob.m_21828_(player);
                                Level level = this.mob.m_9236_();
                                if (level instanceof ServerLevel) {
                                    serverLevel = (ServerLevel)level;
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.mob.m_20185_(), this.mob.m_20186_() + 0.5, this.mob.m_20189_(), 5, 0.25, 0.25, 0.25, 0.005);
                                }
                            } else {
                                Level level = this.mob.m_9236_();
                                if (level instanceof ServerLevel) {
                                    serverLevel = (ServerLevel)level;
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.mob.m_20185_(), this.mob.m_20186_() + 0.5, this.mob.m_20189_(), 5, 0.25, 0.25, 0.25, 0.005);
                                }
                            }
                        } else if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() != ANItems.TAMERS_HAT.get()) {
                            if (chance > 0.65f) {
                                this.mob.m_21828_(player);
                                Level level = this.mob.m_9236_();
                                if (level instanceof ServerLevel) {
                                    serverLevel = (ServerLevel)level;
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.mob.m_20185_(), this.mob.m_20186_() + 0.5, this.mob.m_20189_(), 5, 0.25, 0.25, 0.25, 0.005);
                                }
                            } else {
                                Level level = this.mob.m_9236_();
                                if (level instanceof ServerLevel) {
                                    serverLevel = (ServerLevel)level;
                                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.mob.m_20185_(), this.mob.m_20186_() + 0.5, this.mob.m_20189_(), 5, 0.25, 0.25, 0.25, 0.005);
                                }
                            }
                        }
                    }
                }
            }
            if (this.mob.m_20280_((Entity)targetItem) > (double)this.getItemReachSqr(targetItem)) {
                if (--this.ticksUntilNextRecalc <= 0) {
                    this.ticksUntilNextRecalc = 10 + this.mob.m_217043_().m_188503_(5);
                    boolean success = this.mob.m_21573_().m_5624_((Entity)targetItem, (double)this.speed);
                    if (!success) {
                        ++this.pathRetries;
                        if (this.pathRetries > 3) {
                            this.m_8041_();
                        }
                    } else {
                        this.pathRetries = 0;
                    }
                }
                this.mob.m_21566_().m_6849_(targetItem.m_20185_(), targetItem.m_20186_(), targetItem.m_20189_(), (double)this.speed);
            } else {
                this.mob.m_21573_().m_26573_();
                Vec3 toItem = targetItem.m_20182_().m_82546_(this.mob.m_20182_());
                Vec3 toItemHoriz = new Vec3(toItem.f_82479_, 0.0, toItem.f_82481_);
                double horizLenSqr = toItemHoriz.m_82556_();
                if (horizLenSqr < 1.0E-6) {
                    this.tryEat(targetItem);
                } else {
                    toItemHoriz = toItemHoriz.m_82541_();
                    float targetYaw = (float)(Mth.m_14136_((double)toItemHoriz.f_82481_, (double)toItemHoriz.f_82479_) * 57.2957763671875) - 90.0f;
                    this.mob.m_146922_(this.mob.m_146908_() + Mth.m_14177_((float)(targetYaw - this.mob.m_146908_())) * 0.2f);
                    this.mob.f_20885_ = this.mob.m_146908_();
                    float yaw = this.mob.m_146908_() * ((float)Math.PI / 180);
                    Vec3 lookDir = new Vec3((double)(-Mth.m_14031_((float)yaw)), 0.0, (double)Mth.m_14089_((float)yaw));
                    if (lookDir.m_82526_(toItemHoriz) >= (double)Mth.m_14089_((float)((float)Math.toRadians(5.0)))) {
                        ANLogger.log(ANLogger.Color.GREEN, String.format("Attempting to eat: %s, at pos: %s", targetItem.m_32055_().m_41778_(), targetItem.m_20183_()), new Object[0]);
                        this.tryEat(targetItem);
                    }
                }
            }
        }
    }

    public boolean m_8045_() {
        ItemStack stack;
        boolean canContinue = false;
        ItemEntity targetItem = this.mob.getTargetItem();
        if (targetItem != null && !targetItem.m_213877_() && !(stack = targetItem.m_32055_()).m_41619_() && this.mob.canEatItem(targetItem) && this.mob.m_20270_((Entity)targetItem) <= this.radius) {
            canContinue = true;
        }
        if (!canContinue && targetItem != null) {
            this.mob.onEatFail(targetItem);
        }
        return canContinue;
    }

    public void m_8041_() {
        this.mob.setTargetItem(null);
        this.mob.m_21573_().m_26573_();
    }

    private boolean tryEat(@NotNull ItemEntity item) {
        if (item.m_213877_() || item.m_32055_().m_41619_()) {
            return false;
        }
        ItemStack stack = item.m_32055_();
        if (!stack.m_41619_()) {
            this.mob.m_9236_().m_220400_((Entity)this.mob, GameEvent.f_157806_, this.mob.m_20182_());
            this.mob.onItemEat(item, stack.m_41777_());
            return true;
        }
        return false;
    }

    protected float getItemReachSqr(@NotNull ItemEntity item) {
        return Mth.m_14207_((float)(this.reach + item.m_20205_() * 0.5f));
    }

    public float getRadius() {
        return this.radius;
    }
}

