/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.hunger;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.reaper.ancientnature.api.common.misc.Cooldown;
import net.reaper.ancientnature.api.common.misc.RandomRunnable;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.MobDiet;
import org.jetbrains.annotations.NotNull;

public abstract class HungerController<T extends BaseAnimal<T>> {
    @NotNull
    private final T animal;
    @NotNull
    private final MobDiet diet;
    private final int maxHunger;
    @NotNull
    private final Params params;
    private final RandomRunnable starvationBehavior = new RandomRunnable();
    private final Cooldown damageCooldown = new Cooldown(0);
    private final Cooldown healCooldown = new Cooldown(0);

    public HungerController(@NotNull T animal, @NotNull Params params) {
        this.animal = animal;
        this.diet = ((BaseAnimal)animal).diet;
        this.maxHunger = this.getMaxHunger();
        this.params = params;
        ((BaseAnimal)this.animal).setHunger(this.maxHunger);
        this.starvationBehavior.addAction(new RandomRunnable.Action(1.0f, 40, new Runnable(){
            final /* synthetic */ BaseAnimal val$animal;
            {
                this.val$animal = baseAnimal;
            }

            @Override
            public void run() {
                this.val$animal.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 1, false, false));
                this.val$animal.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1, false, false));
            }
        }));
    }

    public void update() {
        if (!this.animal.m_9236_().f_46443_) {
            float size = (this.animal.m_20205_() + this.animal.m_20206_()) / 2.0f;
            float health = this.animal.m_21223_();
            float max = this.animal.m_21233_();
            int hunger = ((BaseAnimal)this.animal).getHunger();
            int starvationTicks = ((BaseAnimal)this.animal).getStarvationTicks();
            if (hunger > 0) {
                starvationTicks = 0;
                int baseInterval = 720;
                int interval = Math.max(Math.round((float)baseInterval * size * 0.8f), 100);
                if (((BaseAnimal)this.animal).f_19797_ % interval == 0) {
                    --hunger;
                }
                if (health < max) {
                    if (health < max / 2.0f & !this.animal.m_5912_()) {
                        this.animal.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0, false, false));
                    } else if (this.healCooldown.tickAndCheck()) {
                        this.animal.m_5634_(1.0f);
                        this.healCooldown.reset(120);
                    }
                }
            } else {
                float minHealth;
                this.starvationBehavior.update();
                if (++starvationTicks >= 600 && this.damageCooldown.tickAndCheck() && health > (minHealth = max * 0.05f)) {
                    this.animal.m_6469_(this.animal.m_269291_().m_269064_(), 1.0f);
                    this.damageCooldown.reset(200);
                }
            }
            ((BaseAnimal)this.animal).setHunger(hunger);
            ((BaseAnimal)this.animal).setStarvationTicks(starvationTicks);
        }
    }

    @NotNull
    public HungerController<T> starve(int hunger) {
        ((BaseAnimal)this.animal).setHunger(Math.max(((BaseAnimal)this.animal).getHunger() - hunger, 0));
        return this;
    }

    public abstract int getMaxHunger();

    public void onKillEntity(@NotNull LivingEntity target) {
        this.eat(this.params.saturationPerKill);
    }

    @NotNull
    public HungerController<T> eat(int saturation) {
        ((BaseAnimal)this.animal).setHunger(Math.min(((BaseAnimal)this.animal).getHunger() + saturation, this.maxHunger));
        return this;
    }

    public boolean tryEatItem(@NotNull ItemStack stack) {
        if (((BaseAnimal)this.animal).animalDiet.test(stack)) {
            this.eat(this.params.saturationPerKill);
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    public boolean isHungry() {
        return ((BaseAnimal)this.animal).getHunger() <= this.maxHunger / 2;
    }

    public boolean isFull() {
        return ((BaseAnimal)this.animal).getHunger() >= this.maxHunger;
    }

    @NotNull
    public String toString() {
        return String.format("Current hunger: %s, Max Hunger: %s", ((BaseAnimal)this.animal).getHunger(), this.maxHunger);
    }

    public record Params(int saturationPerKill, int decayRate) {
        @Override
        @NotNull
        public String toString() {
            return String.format("Saturation per kill: %s, Decay rate: %s", this.saturationPerKill, this.decayRate);
        }
    }

    @Mod.EventBusSubscriber(modid="ancientnature")
    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void onLivingDeath(@NotNull LivingDeathEvent event) {
            Entity entity = event.getSource().m_7640_();
            if (entity instanceof BaseAnimal) {
                BaseAnimal animal = (BaseAnimal)entity;
                HungerController hunger = animal.hunger;
                if (hunger != null) {
                    hunger.onKillEntity(event.getEntity());
                }
            }
        }

        @SubscribeEvent
        public static void onLivingDrops(@NotNull LivingDropsEvent event) {
            Entity entity = event.getSource().m_7640_();
            if (entity instanceof BaseAnimal) {
                BaseAnimal animal = (BaseAnimal)entity;
                if (animal.hunger != null) {
                    event.getDrops().removeIf(itemEntity -> {
                        FoodProperties food = itemEntity.m_32055_().m_41720_().m_41473_();
                        return food != null && food.m_38746_();
                    });
                }
            }
        }
    }
}

