/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.hunger;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.common.base.BaseAnimal;
import net.reaper.ancientnature.common.entity.ai.hunger.EatBlockGoal;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.core.util.ANUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IEatable {
    default public boolean canStart() {
        return true;
    }

    default public boolean canEatItem(@NotNull ItemEntity item) {
        return !item.m_213877_() && !item.m_32055_().m_41619_();
    }

    default public void onItemEat(@NotNull ItemEntity item, @NotNull ItemStack eatedStack) {
        eatedStack.m_41774_(1);
    }

    default public void onEatFail(ItemEntity item) {
    }

    default public boolean canEatBlock(@NotNull BlockState state, @NotNull BlockPos pos, @NotNull Level level) {
        return true;
    }

    default public void onBlockEat(@NotNull BlockState state, @NotNull BlockPos pos) {
    }

    default public void onBlockPick(@NotNull BlockState state, @NotNull BlockPos pos) {
    }

    @NotNull
    default public EatBlockGoal.Mode getEatMode(@NotNull BlockState state, @NotNull BlockPos pos, @NotNull Level level) {
        if (state.m_60734_() instanceof SweetBerryBushBlock) {
            return EatBlockGoal.Mode.PICK;
        }
        return EatBlockGoal.Mode.DESTROY;
    }

    @Nullable
    public ItemEntity getTargetItem();

    public void setTargetItem(@Nullable ItemEntity var1);

    default public void tameParticles(@NotNull BaseAnimal<?> animal, boolean success) {
        if (!animal.m_9236_().f_46443_) {
            animal.m_9236_().m_7605_(animal, success ? (byte)7 : 6);
        }
    }

    default public void tameByItem(@NotNull BaseAnimal<?> animal, @NotNull ItemEntity item) {
        Entity entity;
        if (!animal.m_21824_() && (entity = item.m_19749_()) instanceof Player) {
            Player player = (Player)entity;
            if (animal.canBeTamed()) {
                float chance = animal.m_217043_().m_188501_();
                boolean tamed = false;
                if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ANItems.TAMERS_HAT.get()) {
                    if (chance > 0.3f) {
                        tamed = true;
                    }
                } else if (chance > 0.65f) {
                    tamed = true;
                }
                if (tamed) {
                    if (!ForgeEventFactory.onAnimalTame(animal, (Player)player)) {
                        animal.m_21828_(player);
                        this.tameParticles(animal, true);
                    } else {
                        this.tameParticles(animal, false);
                    }
                } else {
                    this.tameParticles(animal, false);
                }
            }
        }
    }

    @Nullable
    default public BaseAnimation getBreakAnim() {
        return null;
    }

    @Nullable
    default public BaseAnimation getGatherAnim() {
        return null;
    }

    @NotNull
    default public BaseAnimation createEatAnim(final @NotNull BaseAnimal<?> animal, @NotNull AnimData data, float duration, final int eatAtTick) {
        return new SimpleAnimation("eat", data, Loop.ONCE, 0, duration).addListener(new AnimationListener(){

            @Override
            public void onTick(@NotNull BaseAnimation anim, int tick) {
                ItemEntity item;
                if (tick == eatAtTick && !animal.m_9236_().f_46443_ && (item = IEatable.this.getTargetItem()) != null && !item.m_213877_()) {
                    animal.m_21008_(InteractionHand.MAIN_HAND, item.m_32055_().m_41777_());
                    IEatable.this.tameByItem(animal, item);
                    if (animal.hunger != null) {
                        animal.hunger.tryEatItem(item.m_32055_());
                    }
                    animal.m_9236_().m_247517_(null, animal.m_20183_(), SoundEvents.f_11912_, SoundSource.MASTER);
                    IEatable.this.setTargetItem(null);
                }
            }
        });
    }

    @NotNull
    default public BaseAnimation createBreakAnim(final @NotNull BaseAnimal<?> animal, @NotNull AnimData data, final int brokeAtTick, final int ... nextStageAtTick) {
        return new SimpleAnimation("break", data, Loop.ONCE, 0, 2.2f).addListener(new AnimationListener(){
            private int lastStage = -1;

            @Override
            public void onTick(@NotNull BaseAnimation anim, int tick) {
                Goal goal;
                if (!animal.m_9236_().f_46443_ && animal.m_6084_() && (goal = ANUtils.getCurrentGoal((Mob)animal)) instanceof EatBlockGoal) {
                    EatBlockGoal goal2 = (EatBlockGoal)goal;
                    if (goal2.targetPos != null) {
                        BlockPos pos = goal2.targetPos;
                        int stage = 0;
                        for (int i = 0; i < nextStageAtTick.length && tick >= nextStageAtTick[i]; ++i) {
                            stage = i + 1;
                        }
                        if (stage > 0) {
                            animal.m_9236_().m_6801_(goal2.breakId, pos, Math.min(9, stage));
                            if (stage != this.lastStage) {
                                animal.m_9236_().m_5594_(null, pos, animal.m_9236_().m_8055_(pos).m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                this.lastStage = stage;
                            }
                        }
                        if (tick == brokeAtTick) {
                            EatBlockGoal.Mode.DESTROY.getAction().apply((Mob)animal, goal2, animal.m_9236_().m_8055_(pos));
                            goal2.stopBreaking();
                            animal.m_9236_().m_5594_(null, pos, animal.m_9236_().m_8055_(pos).m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            animal.m_9236_().m_6801_(goal2.breakId, pos, -1);
                        }
                    }
                }
            }
        });
    }

    @NotNull
    default public BaseAnimation createGatherAnim(final @NotNull BaseAnimal<?> animal, @NotNull AnimData data, final int tickToPick) {
        return new SimpleAnimation("gather", data, Loop.ONCE, 0, 1.0989f).addListener(new AnimationListener(){

            @Override
            public void onTick(@NotNull BaseAnimation anim, int tick) {
                Goal goal;
                if (!animal.m_9236_().f_46443_ && animal.m_6084_() && (goal = ANUtils.getCurrentGoal((Mob)animal)) instanceof EatBlockGoal) {
                    EatBlockGoal goal2 = (EatBlockGoal)goal;
                    if (goal2.targetPos != null && tick == tickToPick) {
                        EatBlockGoal.Mode.PICK.getAction().apply((Mob)animal, goal2, animal.m_9236_().m_8055_(goal2.targetPos));
                        if (animal.hunger != null) {
                            animal.hunger.tryEatItem(new ItemStack((ItemLike)Items.f_42780_));
                        }
                    }
                }
            }
        });
    }
}

