/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.hunger.diet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.entry.DietEntry;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.entry.ItemEntry;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.entry.TagEntry;
import org.jetbrains.annotations.NotNull;

public class MobDiet {
    private final CopyOnWriteArrayList<DietEntry> dietEntries = new CopyOnWriteArrayList();

    @NotNull
    public MobDiet addFood(@NotNull ItemLike food) {
        this.dietEntries.add(new ItemEntry(food));
        return this;
    }

    @NotNull
    public MobDiet addFoodTag(@NotNull TagKey<Item> foodTag) {
        this.dietEntries.add(new TagEntry(foodTag));
        return this;
    }

    @NotNull
    public List<Item> getAllDietFood() {
        ArrayList<Item> items = new ArrayList<Item>();
        this.dietEntries.forEach(entry -> {
            if (entry instanceof ItemEntry) {
                ItemEntry itemEntry = (ItemEntry)entry;
                items.add(itemEntry.item().m_5456_());
            } else if (entry instanceof TagEntry) {
                TagEntry tagEntry = (TagEntry)entry;
                ITagManager tags = ForgeRegistries.ITEMS.tags();
                if (tags != null) {
                    ITag tag = tags.getTag(tagEntry.itemTag());
                    tag.forEach(items::add);
                }
            }
        });
        return items;
    }

    @NotNull
    public MobDiet copy() {
        MobDiet newDiet = new MobDiet();
        this.dietEntries.forEach(entry -> newDiet.dietEntries.add(entry.copy()));
        return newDiet;
    }

    @NotNull
    public static MobDiet createFrom(ItemLike ... foods) {
        MobDiet diet = new MobDiet();
        Arrays.stream(foods).forEach(diet::addFood);
        return diet;
    }

    public boolean isFoodInDiet(@NotNull ItemLike food) {
        return this.dietEntries.stream().anyMatch(entry -> entry.matches(food));
    }

    @NotNull
    public List<DietEntry> getAllEntries() {
        return new ArrayList<DietEntry>(this.dietEntries);
    }

    @NotNull
    public static MobDiet create(@NotNull Consumer<Builder> builderConsumer) {
        MobDiet diet = new MobDiet();
        Builder builder = new Builder(diet);
        builderConsumer.accept(builder);
        return diet;
    }

    public static class Builder {
        private final MobDiet diet;

        private Builder(MobDiet diet) {
            this.diet = diet;
        }

        @NotNull
        public Builder addFood(@NotNull ItemLike food) {
            this.diet.addFood(food);
            return this;
        }

        @NotNull
        public Builder addFoodTag(@NotNull TagKey<Item> foodTag) {
            this.diet.addFoodTag(foodTag);
            return this;
        }
    }
}

