/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.hunger.diet;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.reaper.ancientnature.common.entity.ai.hunger.diet.MobDiet;
import net.reaper.ancientnature.core.registry.ANEntities;
import net.reaper.ancientnature.core.registry.ANItems;
import net.reaper.ancientnature.io.config.MobDietConfig;
import org.jetbrains.annotations.NotNull;

public class MobDietRegistry {
    public static final MobDietRegistry INSTANCE = new MobDietRegistry();
    private final Map<ResourceLocation, MobDiet> DEFAULT_DIETS = new HashMap<ResourceLocation, MobDiet>();

    @NotNull
    public MobDietRegistry add(@NotNull EntityType<?> entityType, @NotNull MobDiet diet) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        if (id != null) {
            this.DEFAULT_DIETS.put(id, diet);
        }
        return this;
    }

    @NotNull
    public MobDiet getOrLoad(@NotNull EntityType<?> entityType) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        if (id == null) {
            return new MobDiet();
        }
        return MobDietConfig.loadOrCreate(id, this.DEFAULT_DIETS.getOrDefault(id, new MobDiet()));
    }

    public static void init() {
        INSTANCE.add((EntityType)ANEntities.JAKAPIL.get(), MobDiet.create(builder -> {
            builder.addFood((ItemLike)Items.f_41864_);
            builder.addFood((ItemLike)Items.f_41865_);
            builder.addFood((ItemLike)Items.f_42211_);
        }));
        INSTANCE.add((EntityType)ANEntities.THYLACINE.get(), MobDiet.create(builder -> {
            builder.addFood((ItemLike)Items.f_42579_);
            builder.addFood((ItemLike)Items.f_42580_);
            builder.addFood((ItemLike)Items.f_42581_);
            builder.addFood((ItemLike)Items.f_42582_);
            builder.addFood((ItemLike)Items.f_42697_);
            builder.addFood((ItemLike)Items.f_42698_);
            builder.addFood((ItemLike)Items.f_42485_);
            builder.addFood((ItemLike)Items.f_42486_);
            builder.addFood((ItemLike)Items.f_42658_);
            builder.addFood((ItemLike)Items.f_42659_);
            builder.addFood((ItemLike)ANItems.RAW_DODO.get());
            builder.addFood((ItemLike)ANItems.COOKED_DODO.get());
        }));
        INSTANCE.add((EntityType)ANEntities.ESTEMMENOSUCHUS.get(), MobDiet.create(builder -> {
            builder.addFood((ItemLike)Items.f_42579_);
            builder.addFood((ItemLike)Items.f_42580_);
            builder.addFood((ItemLike)Items.f_42581_);
            builder.addFood((ItemLike)Items.f_42582_);
            builder.addFood((ItemLike)Items.f_42697_);
            builder.addFood((ItemLike)Items.f_42698_);
            builder.addFood((ItemLike)Items.f_42485_);
            builder.addFood((ItemLike)Items.f_42486_);
            builder.addFood((ItemLike)Items.f_42658_);
            builder.addFood((ItemLike)Items.f_42659_);
            builder.addFood((ItemLike)ANItems.RAW_DODO.get());
            builder.addFood((ItemLike)ANItems.COOKED_DODO.get());
        }));
        INSTANCE.add((EntityType)ANEntities.DODO.get(), MobDiet.create(builder -> builder.addFood((ItemLike)Items.f_42575_)));
    }
}

