/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.pathing.water;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.reaper.ancientnature.common.entity.ai.pathing.water.BoidMoveControl;
import net.reaper.ancientnature.common.entity.ai.pathing.water.BoidSettings;

public class Boid {
    public final BoidSettings settings = new BoidSettings();
    public final List<Boid> boids = new ArrayList<Boid>();
    public List<? extends Mob> nearbyMobs = new ArrayList<Mob>();
    public Vec3 position = Vec3.f_82478_;
    public Vec3 forward = new Vec3(0.0, 0.0, 1.0);
    public Vec3 velocity;
    public Vec3 acceleration = Vec3.f_82478_;
    public Vec3 avgFlockHeading = Vec3.f_82478_;
    public Vec3 avgAvoidanceHeading = Vec3.f_82478_;
    public Vec3 centreOfFlockmates = Vec3.f_82478_;
    public int numPerceivedFlockmates;
    public Vec3 target;
    public final Mob mob;

    public Boid(Mob mob) {
        this.mob = mob;
        float startSpeed = (this.settings.minSpeed + this.settings.maxSpeed) / 2.0f;
        this.velocity = this.forward.m_82490_((double)startSpeed);
    }

    public void tick() {
        this.tickNearbyMobs();
        this.compute(new ArrayList<Boid>(this.boids), this.settings.perceptionRadius, this.settings.avoidanceRadius);
        Vec3 acceleration = Vec3.f_82478_;
        if (this.target != null) {
            Vec3 offsetToTarget = this.target.m_82546_(this.position);
            acceleration = this.steerTowards(offsetToTarget).m_82490_((double)this.settings.targetWeight);
        }
        if (this.numPerceivedFlockmates != 0) {
            this.centreOfFlockmates = this.centreOfFlockmates.m_82490_((double)(1.0f / (float)this.numPerceivedFlockmates));
            Vec3 offsetToFlockmatesCentre = this.centreOfFlockmates.m_82546_(this.position);
            Vec3 alignmentForce = this.steerTowards(this.avgFlockHeading).m_82490_((double)this.settings.alignWeight);
            Vec3 cohesionForce = this.steerTowards(offsetToFlockmatesCentre).m_82490_((double)this.settings.cohesionWeight);
            Vec3 seperationForce = this.steerTowards(this.avgAvoidanceHeading).m_82490_((double)this.settings.seperateWeight);
            acceleration = acceleration.m_82549_(alignmentForce);
            acceleration = acceleration.m_82549_(cohesionForce);
            acceleration = acceleration.m_82549_(seperationForce);
        }
        if (this.isHeadingForCollision()) {
            Vec3 collisionAvoidDir = this.obstacleRays();
            Vec3 collisionAvoidForce = this.steerTowards(collisionAvoidDir).m_82490_((double)this.settings.avoidCollisionWeight);
            acceleration = acceleration.m_82549_(collisionAvoidForce);
        }
        this.velocity = this.velocity.m_82549_(acceleration);
        double speed = this.velocity.m_82553_();
        Vec3 dir = this.velocity.m_82490_(1.0 / speed);
        speed = Mth.m_14008_((double)speed, (double)this.settings.minSpeed, (double)this.settings.maxSpeed);
        this.velocity = dir.m_82490_(speed);
        this.position = this.mob.m_20182_().m_82549_(this.velocity.m_82490_((double)0.005f));
        this.forward = dir;
        this.mob.m_246865_(this.velocity.m_82490_((double)0.005f));
    }

    public void compute(List<Boid> boids, float viewRadius, float avoidRadius) {
        int numBoids = boids.size();
        double viewSqr = viewRadius * viewRadius;
        double avoidSqr = avoidRadius * avoidRadius;
        for (int i = 0; i < numBoids; ++i) {
            Boid boidA = boids.get(i);
            boidA.numPerceivedFlockmates = 0;
            boidA.avgFlockHeading = Vec3.f_82478_;
            boidA.centreOfFlockmates = Vec3.f_82478_;
            boidA.avgAvoidanceHeading = Vec3.f_82478_;
            for (int j = 0; j < numBoids; ++j) {
                if (i == j) continue;
                Boid boidB = boids.get(j);
                Vec3 offset = boidB.position.m_82546_(boidA.position);
                double sqrDst = offset.m_82556_();
                if (!(sqrDst < viewSqr)) continue;
                ++boidA.numPerceivedFlockmates;
                boidA.avgFlockHeading = boidA.avgFlockHeading.m_82549_(boidB.forward);
                boidA.centreOfFlockmates = boidA.centreOfFlockmates.m_82549_(boidB.position);
                if (!(sqrDst < avoidSqr) || !(sqrDst > 1.0E-4)) continue;
                Vec3 separation = offset.m_82490_(1.0 / sqrDst);
                boidA.avgAvoidanceHeading = boidA.avgAvoidanceHeading.m_82546_(separation);
            }
        }
    }

    public Vec3 steerTowards(Vec3 vector) {
        Vec3 v = vector.m_82541_().m_82490_((double)this.settings.maxSpeed).m_82546_(this.velocity);
        if (v.m_82553_() > (double)this.settings.maxSteerForce) {
            v = v.m_82541_().m_82490_((double)this.settings.maxSteerForce);
        }
        return v;
    }

    public boolean isHeadingForCollision() {
        Vec3 start = this.position;
        Vec3 end = start.m_82549_(this.forward.m_82490_((double)this.settings.collisionAvoidDst));
        BlockHitResult hit = this.mob.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob));
        return hit.m_6662_() != HitResult.Type.MISS;
    }

    public Vec3 obstacleRays() {
        for (int i = 0; i < 360; i += 45) {
            for (int j = 0; j < 360; j += 45) {
                Vec3 start = this.position;
                Vec3 dir = this.calculateViewVector(this.mob.m_146909_() + (float)j, this.mob.m_146908_() + (float)i).m_82541_();
                Vec3 end = this.position.m_82549_(dir.m_82490_((double)this.settings.collisionAvoidDst));
                BlockHitResult hit = this.mob.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob));
                if (hit.m_6662_() != HitResult.Type.MISS) continue;
                return dir;
            }
        }
        return this.forward;
    }

    public Vec3 calculateViewVector(float xRot, float yRot) {
        float f = xRot * ((float)Math.PI / 180);
        float f1 = -yRot * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public void tickNearbyMobs() {
        Object boid;
        BoidMoveControl boidControl;
        if (this.mob.f_19797_ % 60 == 0 || this.nearbyMobs.isEmpty()) {
            this.nearbyMobs = this.mob.m_9236_().m_6443_(this.mob.getClass(), this.mob.m_20191_().m_82400_(6.0), t -> !t.m_21224_());
            this.nearbyMobs.sort(Comparator.comparing(Entity::m_20148_));
        }
        this.nearbyMobs.removeIf(t -> t.m_21224_());
        for (Mob mob : this.nearbyMobs) {
            MoveControl moveControl = mob.m_21566_();
            if (!(moveControl instanceof BoidMoveControl)) continue;
            boidControl = (BoidMoveControl)moveControl;
            boid = boidControl.boid;
            if (this.boids.contains(boid)) continue;
            this.boids.add((Boid)boid);
        }
        for (Mob mob : this.nearbyMobs) {
            boid = mob.m_21566_();
            if (!(boid instanceof BoidMoveControl)) continue;
            boidControl = (BoidMoveControl)((Object)boid);
            Vec3 targetPos = boidControl.targetPos;
            if (targetPos.equals((Object)Vec3.f_82478_)) continue;
            this.target = targetPos;
            break;
        }
    }
}

