/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.pathing.water;

import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.SwimNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IExtensibleEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObstacleNodeEvaluator
extends SwimNodeEvaluator {
    public static final BlockPathTypes BUBBLE_COLUMN = BlockPathTypes.create((String)"ancientnature:bubble_column", (float)-1.0f);
    private final Long2BooleanMap cache = new Long2BooleanOpenHashMap();
    private final int radius;
    public boolean avoidWalls;

    public ObstacleNodeEvaluator(int radius, boolean avoidWalls) {
        super(false);
        this.radius = radius;
        this.avoidWalls = avoidWalls;
    }

    public void m_6028_(@NotNull PathNavigationRegion level, @NotNull Mob mob) {
        super.m_6028_(level, mob);
        this.cache.clear();
    }

    @NotNull
    public Node m_7171_() {
        int startZ;
        int startY;
        int startX = Mth.m_14107_((double)this.f_77313_.m_20191_().f_82288_);
        Node start = this.m_5676_(startX, startY = Mth.m_14107_((double)(this.f_77313_.m_20191_().f_82289_ + 0.5)), startZ = Mth.m_14107_((double)this.f_77313_.m_20191_().f_82290_));
        if (this.m_192961_(start)) {
            return start;
        }
        int maxSearch = Math.max(8, this.radius * 2);
        Node closest = null;
        int bestDist = Integer.MAX_VALUE;
        for (int r = 1; r <= maxSearch; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        int nx = startX + dx;
                        int ny = startY + dy;
                        int nz = startZ + dz;
                        Node node = this.m_262844_(nx, ny, nz);
                        if (node == null || !this.m_192961_(node)) continue;
                        BlockPos pos = new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_);
                        int dist = Math.abs(dx) + Math.abs(dy) + Math.abs(dz);
                        if (!this.isNearObstacle(pos, this.radius)) {
                            return node;
                        }
                        if (closest != null && dist >= bestDist) continue;
                        closest = node;
                        bestDist = dist;
                    }
                }
            }
        }
        if (closest != null) {
            return closest;
        }
        return start;
    }

    @Nullable
    protected Node m_262844_(int x, int y, int z) {
        Node result = super.m_262844_(x, y, z);
        if (result != null) {
            if (this.canAvoid(this.f_77313_.m_9236_(), this.f_77313_) && this.avoidWalls) {
                result.f_77281_ += Type.WALL.getCost();
            }
            return result;
        }
        return null;
    }

    public int m_6065_(Node @NotNull [] output, @NotNull Node node) {
        int total = super.m_6065_(output, node);
        int valid = 0;
        for (int i = 0; i < total; ++i) {
            Node neighbor = output[i];
            if (neighbor == null) continue;
            if (this.isNearObstacle(new BlockPos(neighbor.f_77271_, neighbor.f_77272_, neighbor.f_77273_), this.radius)) {
                neighbor.f_77281_ += Type.WALL.getCost();
            }
            output[valid++] = neighbor;
        }
        return valid;
    }

    @NotNull
    public BlockPathTypes m_7209_(@NotNull BlockGetter level, int x, int y, int z, @NotNull Mob mob) {
        int extra = 1;
        AABB area = new AABB((double)(x - extra), (double)y, (double)(z - extra), (double)(x + this.f_77315_ + extra), (double)(y + this.f_77316_), (double)(z + this.f_77317_ + extra));
        for (int ix = Mth.m_14107_((double)area.f_82288_); ix <= Mth.m_14107_((double)area.f_82291_); ++ix) {
            for (int iy = Mth.m_14107_((double)area.f_82289_); iy <= Mth.m_14107_((double)area.f_82292_); ++iy) {
                for (int iz = Mth.m_14107_((double)area.f_82290_); iz <= Mth.m_14107_((double)area.f_82293_); ++iz) {
                    if (!level.m_8055_(new BlockPos(ix, iy, iz)).m_60713_(Blocks.f_50628_)) continue;
                    return BUBBLE_COLUMN;
                }
            }
        }
        return super.m_7209_(level, x, y, z, mob);
    }

    public void m_6802_() {
        super.m_6802_();
        this.cache.clear();
    }

    public boolean canAvoid(@NotNull Level level, @NotNull Mob mob) {
        return true;
    }

    private boolean isFullBlockAt(@NotNull BlockPos pos) {
        return this.f_77312_.m_8055_(pos).m_60838_((BlockGetter)this.f_77312_, pos);
    }

    @NotNull
    private AABB getMobAreaAt(@NotNull BlockPos pos, int extraRadius) {
        float width = this.f_77313_.m_20205_() / 2.0f + (float)extraRadius;
        float height = this.f_77313_.m_20206_() + (float)extraRadius;
        double x = (float)pos.m_123341_() + 0.5f;
        double y = pos.m_123342_();
        double z = (float)pos.m_123343_() + 0.5f;
        return new AABB(x - (double)width, y, z - (double)width, x + (double)width, y + (double)height, z + (double)width);
    }

    private boolean isNearObstacle(@NotNull BlockPos center, int extraRadius) {
        long key = center.m_121878_();
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        AABB area = this.getMobAreaAt(center, extraRadius);
        boolean nearby = false;
        for (int x = Mth.m_14107_((double)area.f_82288_); x <= Mth.m_14107_((double)area.f_82291_) && !nearby; ++x) {
            block1: for (int y = Mth.m_14107_((double)area.f_82289_); y <= Mth.m_14107_((double)area.f_82292_) && !nearby; ++y) {
                for (int z = Mth.m_14107_((double)area.f_82290_); z <= Mth.m_14107_((double)area.f_82293_); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (pos.equals((Object)center) || !this.isFullBlockAt(pos)) continue;
                    nearby = true;
                    continue block1;
                }
            }
        }
        this.cache.put(key, nearby);
        return nearby;
    }

    public int getRadius() {
        return this.radius;
    }

    public static enum Type implements StringRepresentable,
    IExtensibleEnum
    {
        WALL(32.0f, new IObstacleCheck(){

            @Override
            public boolean isValid(@NotNull BlockPos pos, @NotNull Mob mob, @NotNull BlockGetter level) {
                return false;
            }
        });

        private final float cost;
        private final IObstacleCheck check;

        private Type(float cost, IObstacleCheck check) {
            this.cost = cost;
            this.check = check;
        }

        public float getCost() {
            return this.cost;
        }

        public boolean isValid(@NotNull BlockPos pos, @NotNull Mob mob, @NotNull BlockGetter level) {
            return this.check.isValid(pos, mob, level);
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @NotNull
        public static Type create(String name, float cost, @NotNull IObstacleCheck check) {
            throw new IllegalStateException("Enum not extended: " + name);
        }

        @FunctionalInterface
        public static interface IObstacleCheck {
            public boolean isValid(@NotNull BlockPos var1, @NotNull Mob var2, @NotNull BlockGetter var3);
        }
    }
}

