/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.reaper.ancientnature.common.base.BaseAnimal;
import org.jetbrains.annotations.NotNull;

public class AnimalProperties {
    public final Map<Property<?>, Enum<?>> properties = new HashMap();
    public static final Property<Type> TYPE = new Property<Type>(Type.class);
    public static final Property<Size> SIZE = new Property<Size>(Size.class);
    public static final Property<Intelligence> INTELLIGENCE = new Property<Intelligence>(Intelligence.class);
    public static final Property<Behavior> BEHAVIOR = new Property<Behavior>(Behavior.class);

    public <T extends Enum<T>> void addProperty(Property<T> pProperty, T pValue) {
        this.properties.put(pProperty, pValue);
    }

    public <T extends Enum<T>> T getProperty(@NotNull Property<T> pProperty) {
        return (T)((Enum)pProperty.type().cast(this.properties.get(pProperty)));
    }

    public <T extends Enum<T>> boolean hasProperty(Property<T> pProperty) {
        return this.properties.containsKey(pProperty);
    }

    public boolean isIdenticalTo(@NotNull BaseAnimal pAnimal) {
        return this.properties.equals(pAnimal.getProperties().properties);
    }

    public String toString() {
        return this.properties.toString();
    }

    public record Property<T extends Enum<T>>(Class<T> type) {
    }

    public static enum Type {
        NONE,
        CARNIVORE,
        HERBIVORE,
        FISH,
        INSECT;

    }

    public static enum Size {
        ENORMOUS,
        BIG,
        MEDIUM,
        SMALL,
        VERY_SMALL;

    }

    public static enum Intelligence {
        SMART,
        MID,
        LOW;

    }

    public static enum Behavior {
        AGGRESSIVE,
        TERRITORIAL,
        NEUTRAL,
        PASSIVE;

    }

    public static class Builder {
        private final AnimalProperties properties = new AnimalProperties();

        public Builder withType(Type pType) {
            this.properties.addProperty(TYPE, pType);
            return this;
        }

        public Builder withSize(Size pSize) {
            this.properties.addProperty(SIZE, pSize);
            return this;
        }

        public Builder withBehavior(Behavior pBehavior) {
            this.properties.addProperty(BEHAVIOR, pBehavior);
            return this;
        }

        public Builder withIntelligence(Intelligence pIntelligence) {
            this.properties.addProperty(INTELLIGENCE, pIntelligence);
            return this;
        }

        public AnimalProperties build() {
            return this.properties;
        }

        public static AnimalProperties build(@NotNull Consumer<Builder> builderConsumer) {
            Builder builder = new Builder();
            builderConsumer.accept(builder);
            return builder.build();
        }
    }
}

