/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.reaper.ancientnature.common.base.BaseAnimal;
import org.jetbrains.annotations.NotNull;

public class SpeedHandler<T extends BaseAnimal<T>> {
    private final List<Entry<T>> entries = new ArrayList<Entry<T>>();

    @NotNull
    public SpeedHandler<T> add(float value, Predicate<T> condition) {
        this.entries.add(new Entry<T>(value, condition));
        return this;
    }

    public float getTotal(T animal, float base) {
        float result = base;
        for (Entry<T> entry : this.entries) {
            if (!entry.condition.test(animal)) continue;
            result += entry.value;
        }
        return result;
    }

    private record Entry<E>(float value, @NotNull Predicate<E> condition) {
    }
}

