/*
 * Decompiled with CFR 0.152.
 */
package net.reaper.ancientnature.common.entity.ai.roar;

import net.reaper.ancientnature.api.common.animator.AnimData;
import net.reaper.ancientnature.api.common.animator.AnimationListener;
import net.reaper.ancientnature.api.common.animator.BaseAnimation;
import net.reaper.ancientnature.api.common.animator.Loop;
import net.reaper.ancientnature.api.common.animator.SimpleAnimation;
import net.reaper.ancientnature.common.base.BaseAnimal;
import org.jetbrains.annotations.NotNull;

public interface IRoaringAnimal {
    @NotNull
    public BaseAnimal<?> entity();

    public boolean isRoaring();

    public void setRoaring(boolean var1);

    default public void playRoarSound() {
    }

    @NotNull
    default public BaseAnimation createRoarAnim(final @NotNull BaseAnimal<?> animal, @NotNull AnimData data, float duration, final int roarSoundAtTick) {
        return new SimpleAnimation("roar", data, Loop.ONCE, 0, duration).addListener(new AnimationListener(){

            @Override
            public void onStart(@NotNull BaseAnimation anim) {
                IRoaringAnimal.this.setRoaring(true);
            }

            @Override
            public void onTick(@NotNull BaseAnimation anim, int tick) {
                if (!animal.m_9236_().f_46443_ && tick == roarSoundAtTick) {
                    IRoaringAnimal.this.playRoarSound();
                }
            }

            @Override
            public void onEnd(@NotNull BaseAnimation anim) {
                IRoaringAnimal.this.setRoaring(false);
            }
        });
    }
}

